/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.buffer;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.dataset.Buffer;
import org.gvsig.fmap.dal.coverage.datastruct.BandList;
import org.gvsig.fmap.dal.coverage.datastruct.Extent;
import org.gvsig.fmap.dal.coverage.datastruct.NoData;
import org.gvsig.fmap.dal.coverage.exception.FileNotExistsException;
import org.gvsig.fmap.dal.coverage.exception.InvalidSetViewException;
import org.gvsig.fmap.dal.coverage.exception.NotSupportedExtensionException;
import org.gvsig.fmap.dal.coverage.exception.QueryException;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.fmap.dal.coverage.store.RasterQuery;
import org.gvsig.fmap.dal.coverage.util.RasterUtils;
import org.gvsig.raster.cache.tile.TileCacheLibrary;
import org.gvsig.raster.cache.tile.provider.CacheStruct;
import org.gvsig.raster.cache.tile.provider.TileListener;
import org.gvsig.raster.impl.DefaultRasterManager;
import org.gvsig.raster.impl.buffer.SpiRasterQuery;
import org.gvsig.raster.impl.buffer.cache.RasterReadOnlyBuffer;
import org.gvsig.raster.impl.datastruct.ExtentImpl;
import org.gvsig.raster.impl.store.QueryableRaster;
import org.gvsig.timesupport.Time;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.task.TaskStatus;

public class DefaultRasterQuery
implements RasterQuery,
SpiRasterQuery {
    public static final int TYPE_UNDEFINED = -1;
    public static final int TYPE_ENTIRE = 0;
    public static final int TYPE_WCOORDS = 1;
    public static final int TYPE_WCOORDS_RESCALED = 2;
    public static final int TYPE_WCOORDS_SHIFT = 3;
    public static final int TYPE_PX = 4;
    public static final int TYPE_PX_RESCALED = 5;
    public static final int TYPE_PX_SHIFT = 6;
    public static final int TYPE_PX_RESCALED_SHIFT = 7;
    public static final int TYPE_TILED = 8;
    public static final int TYPE_ONE_TILE = 9;
    private int type = 0;
    private Rectangle pixelWindow = null;
    private Rectangle adjustedPixelWindow = null;
    private Extent requestBoundingBox = null;
    private Extent adjustedBoundingBox = null;
    private int widthForResampling = -1;
    private int heightForResampling = -1;
    private int adjustedBufferWidth = 0;
    private int adjustedBufferHeight = 0;
    private double[] step = null;
    private int tileRow = 0;
    private int tileCol = 0;
    private int resolutionLevel = -1;
    private boolean adjustToSrcExtent = true;
    private int[] drawableBands = new int[]{0};
    private boolean readOnly = false;
    private boolean memoryBuffer = false;
    private boolean storeLastBuffer = false;
    private Time time = null;
    private boolean supersamplingLoadingBuffer = false;
    private NoData noDataValueToFill = null;
    private TileListener listener = null;
    private int alphaBandNumber = -1;
    private boolean dontBuildBuffer = false;
    private CacheStruct cacheStruct = null;
    private TaskStatus taskStatus = null;
    private BandList bandList = null;
    private Buffer bufferForProviders = null;
    private boolean forceARGBBuffer = false;
    private boolean forceRGBBuffer = false;

    public void setAreaOfInterest() {
        this.type = 0;
    }

    public void setAreaOfInterest(Rectangle pixelWindow) {
        this.pixelWindow = pixelWindow;
        this.type = 4;
    }

    public void setAreaOfInterest(Rectangle pixelWindow, int bufWidth, int bufHeight) {
        this.pixelWindow = pixelWindow;
        this.widthForResampling = bufWidth;
        this.heightForResampling = bufHeight;
        this.type = 4;
    }

    public void setAreaOfInterest(Extent requestBoundingBox, int bufWidth, int bufHeight) {
        this.widthForResampling = bufWidth;
        this.heightForResampling = bufHeight;
        this.requestBoundingBox = requestBoundingBox;
        this.type = 1;
    }

    public void setAreaOfInterest(Extent boundingBox) {
        this.requestBoundingBox = boundingBox;
        this.type = 1;
    }

    public void setAreaOfInterest(Extent requestBoundingBox, int bufWidth, int bufHeight, TileListener listener) {
        this.requestBoundingBox = requestBoundingBox;
        this.widthForResampling = bufWidth;
        this.heightForResampling = bufHeight;
        this.type = 8;
        this.listener = listener;
    }

    public void setTileParameters(int level, int tileCol, int tileRow) {
        this.type = 9;
        this.resolutionLevel = level;
        this.tileRow = tileRow;
        this.tileCol = tileCol;
    }

    public void setTileParameters(int level, int tileCol, int tileRow, Extent bbox, CacheStruct cacheStruct) {
        this.type = 9;
        this.requestBoundingBox = bbox;
        this.resolutionLevel = level;
        this.tileRow = tileRow;
        this.tileCol = tileCol;
        int[] size = null;
        if (cacheStruct != null) {
            this.cacheStruct = cacheStruct;
            size = cacheStruct.getTileSizeByLevel(level);
        } else {
            size = new int[]{TileCacheLibrary.DEFAULT_TILEWIDTH, TileCacheLibrary.DEFAULT_TILEHEIGHT};
        }
        this.widthForResampling = size[0];
        this.heightForResampling = size[1];
    }

    @Override
    public boolean requestIsTiled() {
        switch (this.type) {
            case 8: 
            case 9: {
                return true;
            }
        }
        return false;
    }

    public boolean requestHasShift() {
        switch (this.type) {
            case 3: 
            case 6: 
            case 7: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean requestIsPixelCoordinates() {
        switch (this.type) {
            case 0: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean requestIsInWorldCoordinates() {
        switch (this.type) {
            case 1: 
            case 2: 
            case 3: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    public boolean requestIsRescaled() {
        switch (this.type) {
            case 2: 
            case 5: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    public boolean isSupersamplingTheRequest() {
        if (!this.requestHasShift()) {
            return this.getBufWidth() > this.getAdjustedWidth() || this.getBufHeight() > this.getAdjustedHeight();
        }
        return this.getAdjustedBufWidth() > this.getAdjustedWidth() || this.getAdjustedBufHeight() > this.getAdjustedHeight();
    }

    @Override
    public RasterQuery clone() {
        DefaultRasterQuery q = new DefaultRasterQuery();
        q.type = this.type;
        q.pixelWindow = (Rectangle)this.pixelWindow.clone();
        q.adjustToSrcExtent = this.adjustToSrcExtent;
        q.widthForResampling = this.widthForResampling;
        q.heightForResampling = this.heightForResampling;
        q.requestBoundingBox = this.requestBoundingBox != null ? this.requestBoundingBox.clone() : null;
        q.tileCol = this.tileCol;
        q.tileRow = this.tileRow;
        q.resolutionLevel = this.resolutionLevel;
        q.readOnly = this.readOnly;
        q.memoryBuffer = this.memoryBuffer;
        q.storeLastBuffer = this.storeLastBuffer;
        if (this.drawableBands != null) {
            q.drawableBands = new int[this.drawableBands.length];
            for (int i = 0; i < q.drawableBands.length; ++i) {
                q.drawableBands[i] = this.drawableBands[i];
            }
        }
        q.supersamplingLoadingBuffer = this.supersamplingLoadingBuffer;
        q.noDataValueToFill = this.noDataValueToFill != null ? (NoData)this.noDataValueToFill.clone() : null;
        q.listener = this.listener;
        q.alphaBandNumber = this.alphaBandNumber;
        q.bandList = this.bandList != null ? (BandList)this.bandList.clone() : null;
        q.bufferForProviders = this.bufferForProviders;
        return q;
    }

    public void calculateParameters(RasterDataStore store) throws QueryException {
        this.calculateRequestType(store);
        if (this.requestIsPixelCoordinates()) {
            this.calculateAdjustedPxSizeFromPxSize((int)store.getWidth(), (int)store.getHeight());
            this.calculateBoundingBoxesFromPxRequest(store);
        }
        if (this.requestIsInWorldCoordinates()) {
            this.calculateAdjustedWCWindowFromWCWindow(store.getAffineTransform(), (int)store.getWidth(), (int)store.getHeight());
            this.calculatePxWindowsFromBoundingBoxes(store);
        }
        this.calculateOutputSizeFromPxWindow(store);
        this.step = null;
        if (this.isSupersamplingTheRequest() && !store.isRasterEnclosed()) {
            this.calculateStep(store);
            this.supersampledBuffers(store);
        }
        this.buildDrawableBandList(store.getBands());
        if (!this.dontBuildBuffer) {
            this.createBuffer(store);
        }
    }

    private void calculateAdjustedWCWindowFromWCWindow(AffineTransform at, int w, int h) {
        if (this.requestHasShift()) {
            this.setAdjustedRequestBoundingBox(this.getRequestBoundingBox().clone());
        }
        RasterUtils util = RasterLocator.getManager().getRasterUtils();
        Extent adjustedDataExtent = util.calculateAdjustedView(this.getRequestBoundingBox(), at, (double)w, (double)h);
        this.setAdjustedRequestBoundingBox(adjustedDataExtent);
    }

    private void calculateAdjustedPxSizeFromPxSize(int sourceWidth, int sourceHeight) {
        this.adjustedPixelWindow = (Rectangle)this.pixelWindow.clone();
        if (this.requestHasShift()) {
            return;
        }
        if (this.getAdjustedX() < 0) {
            this.setAdjustedX(0);
        }
        if (this.getAdjustedY() < 0) {
            this.setAdjustedY(0);
        }
        if (this.getAdjustedX() + this.getAdjustedWidth() > sourceWidth) {
            this.setAdjustedWidth(sourceWidth - this.getX());
        }
        if (this.getAdjustedY() + this.getAdjustedHeight() > sourceHeight) {
            this.setAdjustedHeight(sourceHeight - this.getAdjustedY());
        }
    }

    private void calculateBoundingBoxesFromPxRequest(RasterDataStore store) {
        ExtentImpl extent = new ExtentImpl(store.rasterToWorld((Point2D)new Point2D.Double(this.getX(), this.getY())), store.rasterToWorld((Point2D)new Point2D.Double(this.getX() + this.getWidth(), this.getY() + this.getHeight())));
        this.setRequestBoundingBox(extent);
        ExtentImpl adjustedExtent = new ExtentImpl(store.rasterToWorld((Point2D)new Point2D.Double(this.getAdjustedX(), this.getAdjustedY())), store.rasterToWorld((Point2D)new Point2D.Double(this.getAdjustedX() + this.getAdjustedWidth(), this.getAdjustedY() + this.getAdjustedHeight())));
        this.setAdjustedRequestBoundingBox(adjustedExtent);
    }

    private double round(double value) {
        double a = value - (double)((int)value);
        return a > 0.95 || a < 0.05 ? (double)Math.round(value) : value;
    }

    private void calculateOutputSizeFromPxWindow(RasterDataStore store) {
        if (!this.requestIsRescaled()) {
            this.setBufHeight(this.getHeight());
            this.setBufWidth(this.getWidth());
            this.setAdjustedBufWidth(this.getAdjustedWidth());
            this.setAdjustedBufHeight(this.getAdjustedHeight());
        } else {
            double scaleWidth = (double)this.getWidth() / (double)this.getBufWidth();
            double scaleHeight = (double)this.getHeight() / (double)this.getBufHeight();
            this.setAdjustedBufWidth((int)Math.ceil(this.round((double)this.getAdjustedWidth() / scaleWidth)));
            this.setAdjustedBufHeight((int)Math.ceil(this.round((double)this.getAdjustedHeight() / scaleHeight)));
        }
    }

    private void calculatePxWindowsFromBoundingBoxes(RasterDataStore store) {
        Rectangle r;
        Extent requestBBox = this.getRequestBoundingBox();
        Point2D ul = store.worldToRaster(requestBBox.getUL());
        Point2D lr = store.worldToRaster(requestBBox.getLR());
        int w = (int)Math.ceil(Math.abs(this.round(ul.getX()) - this.round(lr.getX())));
        int h = (int)Math.ceil(Math.abs(this.round(ul.getY()) - this.round(lr.getY())));
        this.pixelWindow = r = new Rectangle((int)ul.getX(), (int)ul.getY(), w, h);
        Extent adjustedBBox = this.getAdjustedRequestBoundingBox();
        ul = store.worldToRaster(adjustedBBox.getUL());
        lr = store.worldToRaster(adjustedBBox.getLR());
        w = (int)Math.ceil(Math.abs(this.round(ul.getX()) - this.round(lr.getX())));
        h = (int)Math.ceil(Math.abs(this.round(ul.getY()) - this.round(lr.getY())));
        this.adjustedPixelWindow = r = new Rectangle((int)ul.getX(), (int)ul.getY(), w, h);
    }

    private void supersampledBuffers(RasterDataStore store) {
        if ((double)(this.getAdjustedX() + this.getAdjustedWidth()) < store.getWidth()) {
            this.setAdjustedWidth(this.getAdjustedWidth() + 1);
        }
        if ((double)(this.getAdjustedY() + this.getAdjustedHeight()) < store.getHeight()) {
            this.setAdjustedHeight(this.getAdjustedHeight() + 1);
        }
        this.setAdjustedBufWidth(this.getAdjustedWidth());
        this.setAdjustedBufHeight(this.getAdjustedHeight());
        Point2D ul = store.rasterToWorld((Point2D)new Point2D.Double(this.adjustedPixelWindow.getX(), this.adjustedPixelWindow.getY()));
        Point2D lr = store.rasterToWorld((Point2D)new Point2D.Double(this.adjustedPixelWindow.getX() + this.adjustedPixelWindow.getWidth(), this.adjustedPixelWindow.getY() + this.adjustedPixelWindow.getHeight()));
        this.setAdjustedRequestBoundingBox(new ExtentImpl(ul, lr));
    }

    private void calculateStep(RasterDataStore store) {
        Point2D tl = store.worldToRaster(this.getAdjustedRequestBoundingBox().getUL());
        Point2D br = store.worldToRaster(this.getAdjustedRequestBoundingBox().getLR());
        double scaleWidth = (double)this.getWidth() / (double)this.getBufWidth();
        double scaleHeight = (double)this.getHeight() / (double)this.getBufHeight();
        int srcOriginalAdjustedWidth = (int)Math.ceil(this.round((double)this.getAdjustedWidth() / scaleWidth));
        int srcOriginalAdjustedHeight = (int)Math.ceil(this.round((double)this.getAdjustedHeight() / scaleHeight));
        double wPx = (double)srcOriginalAdjustedWidth / Math.abs(br.getX() - tl.getX());
        double hPx = (double)srcOriginalAdjustedHeight / Math.abs(br.getY() - tl.getY());
        int x = (int)(tl.getX() > br.getX() ? Math.floor(br.getX()) : Math.floor(tl.getX()));
        int y = (int)(tl.getY() > br.getY() ? Math.floor(br.getY()) : Math.floor(tl.getY()));
        double a = tl.getX() > br.getX() ? Math.abs(br.getX() - (double)x) : Math.abs(tl.getX() - (double)x);
        double b = tl.getY() > br.getY() ? Math.abs(br.getY() - (double)y) : Math.abs(tl.getY() - (double)y);
        double stpX = (int)(a * (double)srcOriginalAdjustedWidth / Math.abs(br.getX() - tl.getX()));
        double stpY = (int)(b * (double)srcOriginalAdjustedHeight / Math.abs(br.getY() - tl.getY()));
        this.step = new double[]{stpX, stpY, wPx, hPx};
    }

    @Override
    public Buffer createBuffer(RasterDataStore store) throws QueryException {
        if (this.isReadOnly()) {
            this.bufferForProviders = DefaultRasterManager.getInstance().createReadOnlyBuffer(store.getDataType()[0], this.getAdjustedBufWidth(), this.getAdjustedBufHeight(), store.getBandCount());
            try {
                ((RasterReadOnlyBuffer)this.bufferForProviders).setBufferParams((QueryableRaster)store, this.getAdjustedX(), this.getAdjustedY(), this.getAdjustedX() + this.getAdjustedWidth() - 1, this.getAdjustedY() + this.getAdjustedHeight() - 1, this.bandList);
            }
            catch (FileNotExistsException e) {
                throw new QueryException("Error setting buffer params in a RO buffer", (Exception)((Object)e));
            }
            catch (NotSupportedExtensionException e) {
                throw new QueryException("Error setting buffer params in a RO buffer", (Exception)((Object)e));
            }
            catch (InvalidSetViewException e) {
                throw new QueryException("Error setting buffer params in a RO buffer", (Exception)((Object)e));
            }
        } else {
            BandList bandList = this.buildDrawableBandList(store.getBands());
            int bandCount = bandList.getDrawableBandsCount();
            if (this.forceARGBBuffer) {
                bandCount = 4;
            }
            if (this.forceRGBBuffer) {
                bandCount = 3;
            }
            this.bufferForProviders = this.isMemoryBuffer() ? DefaultRasterManager.getInstance().createMemoryBuffer(store.getDataType()[0], this.getAdjustedBufWidth(), this.getAdjustedBufHeight(), bandCount, true) : DefaultRasterManager.getInstance().createBuffer(store.getDataType()[0], this.getAdjustedBufWidth(), this.getAdjustedBufHeight(), bandCount, true);
        }
        this.bufferForProviders.setDataExtent(this.getAdjustedRequestBoundingBox().toRectangle2D());
        return this.bufferForProviders;
    }

    public BandList buildDrawableBandList(BandList storeBandList) {
        this.bandList = (BandList)storeBandList.clone();
        if (this.drawableBands != null) {
            this.bandList.setDrawableBands(this.drawableBands);
        }
        return this.bandList;
    }

    private boolean isAdjustingPixelWindowToStore(RasterDataStore store) {
        return this.pixelWindow.getX() >= 0.0 && this.pixelWindow.getY() >= 0.0 && this.pixelWindow.getWidth() <= store.getWidth() && this.pixelWindow.getHeight() <= store.getHeight();
    }

    private boolean isBufferSizeDefined() {
        return this.widthForResampling != -1 && this.heightForResampling != -1;
    }

    private boolean isAdjustingRequestBBoxToStore(RasterDataStore store) {
        Extent intersection = this.requestBoundingBox.intersection(store.getExtent());
        return intersection.equals((Object)store.getExtent());
    }

    private void calculateRequestType(RasterDataStore store) {
        if (this.type == 0) {
            this.pixelWindow = new Rectangle(0, 0, (int)store.getWidth(), (int)store.getHeight());
            return;
        }
        if (!this.adjustToSrcExtent) {
            if (this.type == 4) {
                this.type = this.isAdjustingPixelWindowToStore(store) ? (this.isBufferSizeDefined() ? 5 : 4) : (this.isBufferSizeDefined() ? 7 : 6);
            }
            if (this.type == 1 && this.isBufferSizeDefined()) {
                this.type = this.isAdjustingRequestBBoxToStore(store) ? 2 : 3;
            }
        } else {
            if (this.type == 4 && this.isBufferSizeDefined()) {
                this.type = 5;
            }
            if (this.type == 1 && this.isBufferSizeDefined()) {
                this.type = 2;
            }
        }
    }

    public Object getQueryParameter(String name) {
        return null;
    }

    public double getScale() {
        return 0.0;
    }

    public void setQueryParameter(String name, Object value) {
    }

    public void setScale(double scale) {
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
    }

    public void saveToState(PersistentState state) throws PersistenceException {
    }

    public void forceARGBRequest() {
        this.forceARGBBuffer = true;
        this.forceRGBBuffer = false;
    }

    public void forceRGBRequest() {
        this.forceRGBBuffer = true;
        this.forceARGBBuffer = false;
    }

    public boolean isforcingRGBRequest() {
        return this.forceRGBBuffer && !this.forceARGBBuffer;
    }

    public boolean isforcingARGBRequest() {
        return this.forceARGBBuffer && !this.forceRGBBuffer;
    }

    @Override
    public void dontBuildBuffer() {
        this.dontBuildBuffer = true;
    }

    @Override
    public int getType() {
        return this.type;
    }

    public void storeLastBuffer(boolean store) {
        this.storeLastBuffer = store;
    }

    public boolean isStoredLastBuffer() {
        return this.storeLastBuffer;
    }

    public void setAdjustToExtent(boolean adjustToExtent) {
        this.adjustToSrcExtent = adjustToExtent;
    }

    public boolean isAdjustToExtent() {
        return this.adjustToSrcExtent;
    }

    @Override
    public int[] getDrawableBands() {
        return this.drawableBands;
    }

    public void setAllDrawableBands() {
        this.drawableBands = null;
    }

    public void setDrawableBands(int[] drawableBands) {
        this.drawableBands = drawableBands;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    @Override
    public boolean isSupersamplingOptionActive() {
        return this.supersamplingLoadingBuffer;
    }

    public void setSupersamplingOption(boolean supersamplingLoadingBuffer) {
        this.supersamplingLoadingBuffer = supersamplingLoadingBuffer;
    }

    public void setMemoryBuffer(boolean memoryBuffer) {
        this.memoryBuffer = memoryBuffer;
    }

    public boolean isMemoryBuffer() {
        return this.memoryBuffer;
    }

    public void setNoDataToFill(NoData noData) {
        this.noDataValueToFill = noData;
    }

    public void setAlphaBand(int bandNumber) {
        this.alphaBandNumber = bandNumber;
    }

    @Override
    public int getAlphaBandNumber() {
        return this.alphaBandNumber;
    }

    @Override
    public NoData getNoDataValueToFill() {
        return this.noDataValueToFill;
    }

    public void setRequestPixelWindow(Rectangle pixelWindow) {
        this.pixelWindow = pixelWindow;
    }

    public int getX() {
        return (int)this.pixelWindow.getX();
    }

    public int getY() {
        return (int)this.pixelWindow.getY();
    }

    public int getWidth() {
        return (int)this.pixelWindow.getWidth();
    }

    public int getHeight() {
        return (int)this.pixelWindow.getHeight();
    }

    public void setX(int x) {
        this.pixelWindow.setLocation(x, this.getY());
    }

    public void setY(int y) {
        this.pixelWindow.setLocation(this.getX(), y);
    }

    public void setWidth(int w) {
        this.pixelWindow.setSize(w, this.getWidth());
    }

    public void setHeight(int h) {
        this.pixelWindow.setSize(this.getHeight(), h);
    }

    @Override
    public int getAdjustedX() {
        return (int)this.adjustedPixelWindow.getX();
    }

    @Override
    public int getAdjustedY() {
        return (int)this.adjustedPixelWindow.getY();
    }

    @Override
    public int getAdjustedWidth() {
        return (int)this.adjustedPixelWindow.getWidth();
    }

    @Override
    public int getAdjustedHeight() {
        return (int)this.adjustedPixelWindow.getHeight();
    }

    public void setAdjustedX(int x) {
        this.adjustedPixelWindow.setLocation(x, this.getAdjustedY());
    }

    public void setAdjustedY(int y) {
        this.adjustedPixelWindow.setLocation(this.getAdjustedX(), y);
    }

    public void setAdjustedWidth(int w) {
        this.adjustedPixelWindow.setSize(w, this.getAdjustedHeight());
    }

    public void setAdjustedHeight(int h) {
        this.adjustedPixelWindow.setSize(this.getAdjustedWidth(), h);
    }

    @Override
    public Rectangle getRequestPxWindow() {
        return this.pixelWindow;
    }

    @Override
    public Rectangle getAdjustedRequestPxWindow() {
        return this.adjustedPixelWindow;
    }

    @Override
    public Extent getRequestBoundingBox() {
        return this.requestBoundingBox;
    }

    public void setRequestBoundingBox(Extent requestBoundingBox) {
        this.requestBoundingBox = requestBoundingBox;
    }

    @Override
    public Extent getAdjustedRequestBoundingBox() {
        return this.adjustedBoundingBox;
    }

    public void setAdjustedRequestBoundingBox(Extent adjustedBoundingBox) {
        this.adjustedBoundingBox = adjustedBoundingBox;
    }

    @Override
    public int getBufWidth() {
        return this.widthForResampling;
    }

    @Override
    public int getBufHeight() {
        return this.heightForResampling;
    }

    public void setBufHeight(int h) {
        this.heightForResampling = h;
    }

    public void setBufWidth(int w) {
        this.widthForResampling = w;
    }

    @Override
    public int getAdjustedBufWidth() {
        return this.adjustedBufferWidth;
    }

    @Override
    public int getAdjustedBufHeight() {
        return this.adjustedBufferHeight;
    }

    public void setAdjustedBufHeight(int h) {
        this.adjustedBufferHeight = h;
    }

    public void setAdjustedBufWidth(int w) {
        this.adjustedBufferWidth = w;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public TileListener getTileListener() {
        return this.listener;
    }

    public void setTileListener(TileListener listener) {
        this.listener = listener;
    }

    @Override
    public Time getTime() {
        return this.time;
    }

    public void setTime(Time time) {
        this.time = time;
    }

    @Override
    public int getTileRow() {
        return this.tileRow;
    }

    @Override
    public int getTileCol() {
        return this.tileCol;
    }

    @Override
    public CacheStruct getCacheStruct() {
        return this.cacheStruct;
    }

    @Override
    public void setCacheStruct(CacheStruct cacheStruct) {
        this.cacheStruct = cacheStruct;
    }

    @Override
    public int getResolutionLevel() {
        return this.resolutionLevel;
    }

    public void setTaskStatus(TaskStatus taskStatus) {
        this.taskStatus = taskStatus;
    }

    @Override
    public BandList getBandList() {
        return this.bandList;
    }

    @Override
    public void setBandList(BandList bandList) {
        this.bandList = bandList;
    }

    @Override
    public Buffer getBufferForProviders() {
        return this.bufferForProviders;
    }

    @Override
    public void setBufferResult(Buffer buffer) {
        this.bufferForProviders = buffer;
    }

    public void setBufferForProviders(Buffer buffer) throws QueryException {
        if (buffer.getWidth() != this.getAdjustedBufWidth() || buffer.getHeight() != this.getAdjustedBufHeight()) {
            throw new QueryException("Error in buffer size");
        }
        this.bufferForProviders = buffer;
    }

    public double[] getStep() {
        return this.step;
    }

    @Override
    public TaskStatus getTaskStatus() {
        return this.taskStatus;
    }
}

