/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.grid;

import java.util.Arrays;
import org.gvsig.fmap.dal.coverage.RasterLibrary;
import org.gvsig.fmap.dal.coverage.dataset.Buffer;
import org.gvsig.fmap.dal.coverage.datastruct.Extent;
import org.gvsig.fmap.dal.coverage.datastruct.GridCell;
import org.gvsig.fmap.dal.coverage.datastruct.GridExtent;
import org.gvsig.fmap.dal.coverage.datastruct.NoData;
import org.gvsig.fmap.dal.coverage.exception.FilterAddException;
import org.gvsig.fmap.dal.coverage.exception.GridException;
import org.gvsig.fmap.dal.coverage.exception.OutOfGridException;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.exception.RasterBufferInvalidAccessException;
import org.gvsig.fmap.dal.coverage.exception.RasterBufferInvalidException;
import org.gvsig.fmap.dal.coverage.grid.Grid;
import org.gvsig.fmap.dal.coverage.grid.RasterFilterList;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.fmap.dal.coverage.store.props.BasicStats;
import org.gvsig.fmap.dal.coverage.store.props.ColorTable;
import org.gvsig.fmap.dal.coverage.store.props.Transparency;
import org.gvsig.raster.impl.DefaultRasterManager;
import org.gvsig.raster.impl.buffer.RasterBuffer;
import org.gvsig.raster.impl.datastruct.ExtentImpl;
import org.gvsig.raster.impl.grid.GridCellImpl;
import org.gvsig.raster.impl.grid.GridExtentImpl;
import org.gvsig.raster.impl.grid.GridInterpolated;
import org.gvsig.raster.impl.grid.GridNotInterpolated;
import org.gvsig.raster.impl.grid.GridReader;
import org.gvsig.raster.impl.grid.GridStatistic;
import org.gvsig.raster.impl.grid.GridWriter;
import org.gvsig.raster.impl.grid.filter.DefaultRasterFilterList;
import org.gvsig.raster.impl.store.QueryableRaster;
import org.gvsig.raster.impl.store.properties.DataStoreColorInterpretation;
import org.gvsig.raster.impl.store.properties.DataStoreColorTable;
import org.gvsig.raster.impl.store.properties.DataStoreTransparency;

public class GridImpl
implements Grid {
    public static final double DEG_45_IN_RAD = 0.7853981633974483;
    public static final double DEG_90_IN_RAD = 1.5707963267948966;
    public static final double DEG_180_IN_RAD = Math.PI;
    public static final double DEG_270_IN_RAD = 4.71238898038469;
    public static final double DEG_360_IN_RAD = Math.PI * 2;
    private static final int[] m_iOffsetX = new int[]{0, 1, 1, 1, 0, -1, -1, -1};
    private static final int[] m_iOffsetY = new int[]{1, 1, 0, -1, -1, -1, 0, 1};
    private double[] m_dDist;
    public double _2DX;
    public double _6DX;
    public double _DX_2;
    public double _4DX_2;
    private int[] bands = null;
    private int dataType = 32;
    private Buffer rasterBuf = null;
    private GridReader reader = null;
    private GridWriter writer = null;
    private GridExtent windowExtent = null;
    private GridExtent layerExtent = null;
    private GridStatistic statistic = null;
    private ColorTable palette = null;
    private RasterFilterList filterList = null;

    public GridImpl(RasterDataStore datasource, int[] bands, GridExtent windowExtent) throws RasterBufferInvalidException {
        double[] cellSize = this.calcCellSize(datasource, datasource.getWidth(), datasource.getHeight());
        this.layerExtent = new GridExtentImpl(datasource.getExtent(), cellSize[0], cellSize[1]);
        if (datasource.getDataType() != null) {
            this.dataType = datasource.getDataType()[0];
        }
        this.bands = bands;
        this.windowExtent = windowExtent == null ? this.layerExtent : windowExtent;
        this.reader = this.windowExtent.fitsIn(this.layerExtent) ? new GridNotInterpolated(datasource, this.layerExtent, this.windowExtent, bands) : new GridInterpolated(datasource, this.layerExtent, this.windowExtent, bands);
        this.rasterBuf = datasource.getLastBuffer();
        this.writer = new GridWriter(this.layerExtent, this.dataType, this.rasterBuf);
        this.init(datasource);
    }

    public void loadWriterData() throws GridException {
        this.rasterBuf = DefaultRasterManager.getInstance().createBuffer(this.dataType, this.reader.getNX(), this.reader.getNY(), this.bands.length, true);
        this.writer = new GridWriter(this.windowExtent, this.dataType, this.rasterBuf);
        int x = 0;
        int y = 0;
        try {
            switch (this.rasterBuf.getDataType()) {
                case 0: {
                    for (x = 0; x < this.getNX(); ++x) {
                        for (y = 0; y < this.getNY(); ++y) {
                            this.writer.setCellValue(x, y, this.reader.getCellValueAsByte(x, y));
                        }
                    }
                    break;
                }
                case 2: {
                    for (x = 0; x < this.getNX(); ++x) {
                        for (y = 0; y < this.getNY(); ++y) {
                            this.writer.setCellValue(x, y, this.reader.getCellValueAsShort(x, y));
                        }
                    }
                    break;
                }
                case 3: {
                    for (x = 0; x < this.getNX(); ++x) {
                        for (y = 0; y < this.getNY(); ++y) {
                            this.writer.setCellValue(x, y, this.reader.getCellValueAsInt(x, y));
                        }
                    }
                    break;
                }
                case 4: {
                    for (x = 0; x < this.getNX(); ++x) {
                        for (y = 0; y < this.getNY(); ++y) {
                            this.writer.setCellValue(x, y, this.reader.getCellValueAsFloat(x, y));
                        }
                    }
                    break;
                }
                case 5: {
                    for (x = 0; x < this.getNX(); ++x) {
                        for (y = 0; y < this.getNY(); ++y) {
                            this.writer.setCellValue(x, y, this.reader.getCellValueAsDouble(x, y));
                        }
                    }
                    break;
                }
            }
        }
        catch (RasterBufferInvalidException e) {
            throw new GridException("Buffer de datos no v\u00e1lido " + x + " " + y, (Exception)((Object)e));
        }
        catch (OutOfGridException e1) {
            throw new GridException("Acceso fuera de los l\u00edmites del Grid " + x + " " + y, (Exception)((Object)e1));
        }
        catch (RasterBufferInvalidAccessException e) {
            throw new GridException("Acceso al grid no v\u00e1lido " + x + " " + y, (Exception)((Object)e));
        }
    }

    public GridImpl(GridExtent layerExtent, GridExtent windowExtent, int dataType, int[] bands) throws RasterBufferInvalidException {
        this.windowExtent = windowExtent;
        this.layerExtent = layerExtent;
        this.dataType = dataType;
        this.rasterBuf = DefaultRasterManager.getInstance().createBuffer(dataType, layerExtent.getNX(), layerExtent.getNY(), bands.length, true);
        this.reader = windowExtent.fitsIn(layerExtent) ? new GridNotInterpolated(this.rasterBuf, layerExtent, windowExtent, bands) : new GridInterpolated(this.rasterBuf, layerExtent, windowExtent, bands);
        this.writer = new GridWriter(layerExtent, dataType, this.rasterBuf);
        this.init(null);
    }

    public GridImpl(Buffer buf, RasterDataStore datasource, boolean notInterp) {
        double[] cellSize = this.calcCellSize(datasource, datasource.getWidth(), datasource.getHeight());
        this.layerExtent = new GridExtentImpl(datasource.getExtent(), cellSize[0], cellSize[1]);
        if (datasource.getDataType() != null) {
            this.dataType = datasource.getDataType()[0];
        }
        if (datasource instanceof QueryableRaster) {
            this.bands = ((QueryableRaster)datasource).getDrawableBands();
        } else {
            this.bands = new int[datasource.getBandCount()];
            for (int i = 0; i < this.bands.length; ++i) {
                this.bands[i] = i;
            }
        }
        this.windowExtent = new GridExtentImpl(new ExtentImpl(buf.getDataExtent()), cellSize[0], cellSize[1]);
        this.rasterBuf = buf;
        this.reader = notInterp ? new GridNotInterpolated(this.rasterBuf, this.layerExtent, this.windowExtent, this.bands) : (this.windowExtent.fitsIn(this.layerExtent) ? new GridNotInterpolated(this.rasterBuf, this.layerExtent, this.windowExtent, this.bands) : new GridInterpolated(this.rasterBuf, this.layerExtent, this.windowExtent, this.bands));
        this.writer = new GridWriter(this.layerExtent, this.dataType, this.rasterBuf);
        this.init(datasource);
    }

    public GridImpl(RasterDataStore datasource, int[] bands) throws RasterBufferInvalidException {
        double[] cellSize = this.calcCellSize(datasource, datasource.getWidth(), datasource.getHeight());
        this.windowExtent = this.layerExtent = new GridExtentImpl(datasource.getExtent(), cellSize[0], cellSize[1]);
        if (datasource.getDataType() != null) {
            this.dataType = datasource.getDataType()[0];
        }
        this.bands = bands;
        this.reader = new GridNotInterpolated(datasource, this.layerExtent, this.windowExtent, bands);
        this.rasterBuf = datasource.getLastBuffer();
        this.writer = new GridWriter(this.windowExtent, this.dataType, this.rasterBuf);
        this.init(datasource);
    }

    public GridImpl(RasterDataStore datasource) throws RasterBufferInvalidException {
        double[] cellSize = this.calcCellSize(datasource, datasource.getWidth(), datasource.getHeight());
        this.windowExtent = this.layerExtent = new GridExtentImpl(datasource.getExtent(), cellSize[0], cellSize[1]);
        if (datasource.getDataType() != null) {
            this.dataType = datasource.getDataType()[0];
        }
        this.bands = new int[datasource.getBandCount()];
        for (int i = 0; i < datasource.getBandCount(); ++i) {
            this.bands[i] = i;
        }
        this.reader = new GridNotInterpolated(datasource, this.layerExtent, this.windowExtent, this.bands);
        this.rasterBuf = datasource.getLastBuffer();
        this.writer = new GridWriter(this.windowExtent, this.dataType, this.rasterBuf);
        this.init(datasource);
    }

    private double[] calcCellSize(RasterDataStore mDataset, double w, double h) {
        double[] dCellsize = new double[2];
        try {
            Extent e = mDataset.getExtent();
            dCellsize[0] = (e.getLRX() - e.getULX()) / w;
            dCellsize[1] = (e.getLRY() - e.getULY()) / h;
            return dCellsize;
        }
        catch (NullPointerException e) {
            dCellsize[0] = 1.0;
            dCellsize[1] = 1.0;
            return dCellsize;
        }
    }

    public void switchToInterpolationMethod(boolean interpolation) {
        this.reader = interpolation ? new GridInterpolated(this.rasterBuf, this.layerExtent, this.windowExtent, this.bands) : new GridNotInterpolated(this.rasterBuf, this.layerExtent, this.windowExtent, this.bands);
        this.init(null);
    }

    private void init(RasterDataStore ds) {
        Transparency transparency = null;
        double dCellSize = this.getCellSize();
        this.statistic = new GridStatistic(this);
        if (ds == null) {
            DataStoreColorInterpretation ci = new DataStoreColorInterpretation(this.rasterBuf.getBandCount());
            transparency = new DataStoreTransparency(ci);
        } else {
            transparency = ds.getTransparency().cloneTransparency();
            this.palette = new DataStoreColorTable(ds.getColorTable());
        }
        this.filterList = new DefaultRasterFilterList();
        if (ds != null) {
            this.filterList.addEnvParam("SrcStatistics", (Object)ds.getStatistics());
        }
        this.filterList.addEnvParam("Transparency", (Object)transparency);
        if (this.rasterBuf != null) {
            this.filterList.setInitRasterBuf(this.rasterBuf);
        }
        this.m_dDist = new double[8];
        for (int i = 0; i < 8; ++i) {
            this.m_dDist[i] = Math.sqrt((double)m_iOffsetX[i] * dCellSize * (double)m_iOffsetX[i] * dCellSize + (double)m_iOffsetY[i] * dCellSize * (double)m_iOffsetY[i] * dCellSize);
        }
        this._2DX = dCellSize * 2.0;
        this._6DX = dCellSize * 6.0;
        this._DX_2 = dCellSize * dCellSize;
        this._4DX_2 = 4.0 * this._DX_2;
    }

    public int getBandCount() {
        if (this.rasterBuf != null) {
            return this.rasterBuf.getBandCount();
        }
        return 0;
    }

    public void assign(byte value) throws GridException {
        try {
            this.writer.assign(value);
        }
        catch (RasterBufferInvalidAccessException e) {
            throw new GridException("Error wrinting buffer");
        }
    }

    public void assign(short value) throws GridException {
        try {
            this.writer.assign(value);
        }
        catch (RasterBufferInvalidAccessException e) {
            throw new GridException("Error wrinting buffer");
        }
    }

    public void assign(int value) throws GridException {
        try {
            this.writer.assign(value);
        }
        catch (RasterBufferInvalidAccessException e) {
            throw new GridException("Error wrinting buffer");
        }
    }

    public void assign(float value) throws GridException {
        try {
            this.writer.assign(value);
        }
        catch (RasterBufferInvalidAccessException e) {
            throw new GridException("Error wrinting buffer");
        }
    }

    public void assign(double value) throws GridException {
        try {
            this.writer.assign(value);
        }
        catch (RasterBufferInvalidAccessException e) {
            throw new GridException("Error wrinting buffer");
        }
    }

    public void assign(RasterDataStore dSource) throws GridException {
        GridImpl window = null;
        try {
            window = new GridImpl(dSource, this.bands, this.windowExtent);
            this.write(window);
            this.writer.setNoDataValue(window.getNoDataValue());
        }
        catch (RasterBufferInvalidException e) {
            throw new GridException("Error writing buffer");
        }
    }

    public void assign(Grid driver) throws GridException {
        if (driver.getGridExtent().equals(this.layerExtent)) {
            this.write(driver);
            this.writer.setNoDataValue(driver.getNoDataValue());
        }
    }

    private void write(Grid g) throws GridException {
        try {
            switch (this.rasterBuf.getDataType()) {
                case 0: {
                    for (int x = 0; x < g.getNX(); ++x) {
                        for (int y = 0; y < g.getNY(); ++y) {
                            this.writer.setCellValue(x, y, g.getCellValueAsByte(x, y));
                        }
                    }
                    break;
                }
                case 2: {
                    for (int x = 0; x < g.getNX(); ++x) {
                        for (int y = 0; y < g.getNY(); ++y) {
                            this.writer.setCellValue(x, y, g.getCellValueAsShort(x, y));
                        }
                    }
                    break;
                }
                case 3: {
                    for (int x = 0; x < g.getNX(); ++x) {
                        for (int y = 0; y < g.getNY(); ++y) {
                            this.writer.setCellValue(x, y, g.getCellValueAsInt(x, y));
                        }
                    }
                    break;
                }
                case 4: {
                    for (int x = 0; x < g.getNX(); ++x) {
                        for (int y = 0; y < g.getNY(); ++y) {
                            this.writer.setCellValue(x, y, g.getCellValueAsFloat(x, y));
                        }
                    }
                    break;
                }
                case 5: {
                    for (int x = 0; x < g.getNX(); ++x) {
                        for (int y = 0; y < g.getNY(); ++y) {
                            this.writer.setCellValue(x, y, g.getCellValueAsDouble(x, y));
                        }
                    }
                    break;
                }
            }
        }
        catch (OutOfGridException e) {
            throw new GridException("");
        }
    }

    public void assignNoData() {
        try {
            if (!this.rasterBuf.getNoDataValue().isDefined()) {
                return;
            }
            switch (this.rasterBuf.getDataType()) {
                case 0: {
                    this.writer.assign(this.rasterBuf.getNoDataValue().getValue().byteValue());
                    break;
                }
                case 2: {
                    this.writer.assign(this.rasterBuf.getNoDataValue().getValue().shortValue());
                    break;
                }
                case 3: {
                    this.writer.assign(this.rasterBuf.getNoDataValue().getValue().intValue());
                    break;
                }
                case 4: {
                    this.writer.assign(this.rasterBuf.getNoDataValue().getValue().floatValue());
                    break;
                }
                case 5: {
                    this.writer.assign(this.rasterBuf.getNoDataValue().getValue().doubleValue());
                }
            }
        }
        catch (RasterBufferInvalidAccessException e) {
            e.printStackTrace();
        }
    }

    public void setCellValue(int x, int y, byte value) throws OutOfGridException {
        this.writer.setCellValue(x, y, value);
    }

    public void setCellValue(int x, int y, short value) throws OutOfGridException {
        this.writer.setCellValue(x, y, value);
    }

    public void setCellValue(int x, int y, int value) throws OutOfGridException {
        this.writer.setCellValue(x, y, value);
    }

    public void setCellValue(int x, int y, float value) throws OutOfGridException {
        this.writer.setCellValue(x, y, value);
    }

    public void setCellValue(int x, int y, double value) throws OutOfGridException {
        this.writer.setCellValue(x, y, value);
    }

    public void add(Grid g) throws GridException {
        if (g.getGridExtent().equals(this.getGridExtent())) {
            boolean interp = this.reader instanceof GridInterpolated;
            this.switchToInterpolationMethod(false);
            try {
                switch (this.rasterBuf.getDataType()) {
                    case 0: {
                        for (int x = 0; x < g.getNX(); ++x) {
                            for (int y = 0; y < g.getNY(); ++y) {
                                this.writer.setCellValue(x, y, this.reader.getCellValueAsByte(x, y) + g.getCellValueAsByte(x, y));
                            }
                        }
                        break;
                    }
                    case 2: {
                        for (int x = 0; x < g.getNX(); ++x) {
                            for (int y = 0; y < g.getNY(); ++y) {
                                this.writer.setCellValue(x, y, this.reader.getCellValueAsShort(x, y) + g.getCellValueAsShort(x, y));
                            }
                        }
                        break;
                    }
                    case 3: {
                        for (int x = 0; x < g.getNX(); ++x) {
                            for (int y = 0; y < g.getNY(); ++y) {
                                this.writer.setCellValue(x, y, this.reader.getCellValueAsInt(x, y) + g.getCellValueAsInt(x, y));
                            }
                        }
                        break;
                    }
                    case 4: {
                        for (int x = 0; x < g.getNX(); ++x) {
                            for (int y = 0; y < g.getNY(); ++y) {
                                this.writer.setCellValue(x, y, this.reader.getCellValueAsFloat(x, y) + g.getCellValueAsFloat(x, y));
                            }
                        }
                        break;
                    }
                    case 5: {
                        for (int x = 0; x < g.getNX(); ++x) {
                            for (int y = 0; y < g.getNY(); ++y) {
                                this.writer.setCellValue(x, y, this.reader.getCellValueAsDouble(x, y) + g.getCellValueAsDouble(x, y));
                            }
                        }
                        break;
                    }
                }
            }
            catch (OutOfGridException e) {
                throw new GridException("");
            }
            catch (RasterBufferInvalidAccessException e1) {
                throw new GridException("");
            }
            catch (RasterBufferInvalidException e) {
                throw new GridException("");
            }
            this.switchToInterpolationMethod(interp);
        }
    }

    public void addToCellValue(int x, int y, byte value) throws GridException {
        try {
            this.writer.setCellValue(x, y, (byte)(this.reader.getCellValueAsByte(x, y) + value));
        }
        catch (OutOfGridException e) {
            throw new GridException("");
        }
        catch (RasterBufferInvalidAccessException e) {
            throw new GridException("");
        }
        catch (RasterBufferInvalidException e) {
            throw new GridException("");
        }
    }

    public void addToCellValue(int x, int y, short value) throws GridException {
        try {
            this.writer.setCellValue(x, y, (short)(this.reader.getCellValueAsShort(x, y) + value));
        }
        catch (OutOfGridException e) {
            throw new GridException("");
        }
        catch (RasterBufferInvalidAccessException e) {
            throw new GridException("");
        }
        catch (RasterBufferInvalidException e) {
            throw new GridException("");
        }
    }

    public void addToCellValue(int x, int y, int value) throws GridException {
        try {
            this.writer.setCellValue(x, y, this.reader.getCellValueAsInt(x, y) + value);
        }
        catch (OutOfGridException e) {
            throw new GridException("");
        }
        catch (RasterBufferInvalidAccessException e) {
            throw new GridException("");
        }
        catch (RasterBufferInvalidException e) {
            throw new GridException("");
        }
    }

    public void addToCellValue(int x, int y, float value) throws GridException {
        try {
            this.writer.setCellValue(x, y, this.reader.getCellValueAsFloat(x, y) + value);
        }
        catch (OutOfGridException e) {
            throw new GridException("");
        }
        catch (RasterBufferInvalidAccessException e) {
            throw new GridException("");
        }
        catch (RasterBufferInvalidException e) {
            throw new GridException("");
        }
    }

    public void addToCellValue(int x, int y, double value) throws GridException {
        try {
            this.writer.setCellValue(x, y, this.reader.getCellValueAsDouble(x, y) + value);
        }
        catch (OutOfGridException e) {
            throw new GridException("");
        }
        catch (RasterBufferInvalidAccessException e) {
            throw new GridException("");
        }
        catch (RasterBufferInvalidException e) {
            throw new GridException("");
        }
    }

    public void multiply(double value) throws GridException {
        boolean interp = this.reader instanceof GridInterpolated;
        this.switchToInterpolationMethod(false);
        try {
            switch (this.rasterBuf.getDataType()) {
                case 0: {
                    for (int x = 0; x < this.getNX(); ++x) {
                        for (int y = 0; y < this.getNY(); ++y) {
                            this.writer.setCellValue(x, y, (byte)((double)this.reader.getCellValueAsByte(x, y) * value));
                        }
                    }
                    break;
                }
                case 2: {
                    for (int x = 0; x < this.getNX(); ++x) {
                        for (int y = 0; y < this.getNY(); ++y) {
                            this.writer.setCellValue(x, y, (short)((double)this.reader.getCellValueAsShort(x, y) * value));
                        }
                    }
                    break;
                }
                case 3: {
                    for (int x = 0; x < this.getNX(); ++x) {
                        for (int y = 0; y < this.getNY(); ++y) {
                            this.writer.setCellValue(x, y, (int)((double)this.reader.getCellValueAsInt(x, y) * value));
                        }
                    }
                    break;
                }
                case 4: {
                    for (int x = 0; x < this.getNX(); ++x) {
                        for (int y = 0; y < this.getNY(); ++y) {
                            this.writer.setCellValue(x, y, (float)((double)this.reader.getCellValueAsFloat(x, y) * value));
                        }
                    }
                    break;
                }
                case 5: {
                    for (int x = 0; x < this.getNX(); ++x) {
                        for (int y = 0; y < this.getNY(); ++y) {
                            this.writer.setCellValue(x, y, this.reader.getCellValueAsDouble(x, y) * value);
                        }
                    }
                    break;
                }
            }
        }
        catch (RasterBufferInvalidException e) {
            throw new GridException("Buffer de datos no v\u00e1lido", (Exception)((Object)e));
        }
        catch (OutOfGridException e1) {
            throw new GridException("Acceso fuera de los l\u00edmites del Grid", (Exception)((Object)e1));
        }
        catch (RasterBufferInvalidAccessException e) {
            throw new GridException("Acceso al grid no v\u00e1lido", (Exception)((Object)e));
        }
        this.switchToInterpolationMethod(interp);
    }

    public void setNoDataValue(NoData dNoDataValue) {
        this.writer.setNoDataValue(dNoDataValue);
    }

    public void setNoData(int x, int y) {
        this.writer.setNoData(x, y);
    }

    public boolean isNoDataValue(double noDataValue) {
        return this.reader.getNoDataValue() == noDataValue;
    }

    public boolean isInGrid(int x, int y) {
        return this.reader.isCellInGrid(x, y);
    }

    public double getCellSize() {
        return this.reader.getCellSize();
    }

    public byte getCellValueAsByte(int x, int y) throws GridException {
        try {
            return this.reader.getCellValueAsByte(x, y);
        }
        catch (RasterBufferInvalidAccessException e) {
            throw new GridException("Position: (" + x + "," + y + ") not valid");
        }
        catch (RasterBufferInvalidException e) {
            throw new GridException("Buffer not valid");
        }
    }

    public short getCellValueAsShort(int x, int y) throws GridException {
        try {
            return this.reader.getCellValueAsShort(x, y);
        }
        catch (RasterBufferInvalidAccessException e) {
            throw new GridException("Position: (" + x + "," + y + ") not valid");
        }
        catch (RasterBufferInvalidException e) {
            throw new GridException("Buffer not valid");
        }
    }

    public int getCellValueAsInt(int x, int y) throws GridException {
        try {
            return this.reader.getCellValueAsInt(x, y);
        }
        catch (RasterBufferInvalidAccessException e) {
            throw new GridException("Position: (" + x + "," + y + ") not valid");
        }
        catch (RasterBufferInvalidException e) {
            throw new GridException("Buffer not valid");
        }
    }

    public float getCellValueAsFloat(int x, int y) throws GridException {
        try {
            return this.reader.getCellValueAsFloat(x, y);
        }
        catch (RasterBufferInvalidAccessException e) {
            throw new GridException("Position: (" + x + "," + y + ") not valid");
        }
        catch (RasterBufferInvalidException e) {
            throw new GridException("Buffer not valid");
        }
    }

    public double getCellValueAsDouble(int x, int y) throws GridException {
        try {
            return this.reader.getCellValueAsDouble(x, y);
        }
        catch (RasterBufferInvalidAccessException e) {
            throw new GridException("Position: (" + x + "," + y + ") not valid");
        }
        catch (RasterBufferInvalidException e) {
            throw new GridException("Buffer not valid");
        }
    }

    public double getCellValue(int x, int y) throws GridException {
        try {
            return this.reader.getCellValue(x, y);
        }
        catch (RasterBufferInvalidAccessException e) {
            throw new GridException("Position: (" + x + "," + y + ") not valid");
        }
        catch (RasterBufferInvalidException e) {
            throw new GridException("Buffer not valid");
        }
    }

    public NoData getNoDataValue() {
        return this.rasterBuf.getNoDataValue();
    }

    public void setInterpolationMethod(int iMethod) {
        if (this.reader instanceof GridInterpolated) {
            ((GridInterpolated)this.reader).setInterpolationMethod(iMethod);
        } else {
            this.switchToInterpolationMethod(true);
            ((GridInterpolated)this.reader).setInterpolationMethod(iMethod);
        }
    }

    public int getNX() {
        return this.reader.getNX();
    }

    public int getNY() {
        return this.reader.getNY();
    }

    public int getLayerNX() {
        return this.layerExtent.getNX();
    }

    public int getLayerNY() {
        return this.layerExtent.getNY();
    }

    public int getDataType() {
        return this.dataType;
    }

    private boolean getSubMatrix3x3(int x, int y, double[] subMatrix) throws GridException {
        double z = this.getCellValueAsDouble(x, y);
        if (this.isNoDataValue(z)) {
            return false;
        }
        for (int i = 0; i < 4; ++i) {
            int iDir = 2 * i;
            double z2 = this.getCellValueAsDouble(x + m_iOffsetX[iDir], y + m_iOffsetY[iDir]);
            subMatrix[i] = !this.isNoDataValue(z2) ? z2 - z : (!this.isNoDataValue(z2 = this.getCellValueAsDouble(x + m_iOffsetX[(iDir + 4) % 8], y + m_iOffsetY[(iDir + 4) % 8])) ? z - z2 : 0.0);
        }
        return true;
    }

    public double getSlope(int x, int y) throws GridException {
        double[] zm = new double[4];
        try {
            if (this.getSubMatrix3x3(x, y, zm)) {
                double G = (zm[0] - zm[2]) / this._2DX;
                double H = (zm[1] - zm[3]) / this._2DX;
                return Math.atan(Math.sqrt(G * G + H * H));
            }
            return this.rasterBuf.getNoDataValue().isDefined() ? this.rasterBuf.getNoDataValue().getValue().doubleValue() : RasterLibrary.defaultDoubleNoDataValue;
        }
        catch (GridException e) {
            throw new GridException("Problems accesing 3x3 submatrix");
        }
    }

    public double getAspect(int x, int y) throws GridException {
        double[] zm = new double[4];
        try {
            if (this.getSubMatrix3x3(x, y, zm)) {
                double G = (zm[0] - zm[2]) / this._2DX;
                double H = (zm[1] - zm[3]) / this._2DX;
                double dAspect = G != 0.0 ? Math.PI + Math.atan2(H, G) : (H > 0.0 ? 4.71238898038469 : (H < 0.0 ? 1.5707963267948966 : -1.0));
                return dAspect;
            }
            return this.rasterBuf.getNoDataValue().isDefined() ? this.rasterBuf.getNoDataValue().getValue().doubleValue() : RasterLibrary.defaultDoubleNoDataValue;
        }
        catch (GridException e) {
            throw new GridException("Problems accesing 3x3 submatrix");
        }
    }

    public static int getXOffsetInDir(int iDir) {
        return m_iOffsetX[iDir];
    }

    public static int getYOffsetInDir(int iDir) {
        return m_iOffsetY[iDir];
    }

    public double getDistToNeighborInDir(int iDir) {
        return this.m_dDist[iDir];
    }

    public static double getUnitDistToNeighborInDir(int iDir) {
        return iDir % 2 != 0 ? Math.sqrt(2.0) : 1.0;
    }

    public int getDirToNextDownslopeCell(int x, int y) throws GridException {
        return this.getDirToNextDownslopeCell(x, y, true);
    }

    public int getDirToNextDownslopeCell(int x, int y, boolean bForceDirToNoDataCell) throws GridException {
        double z = this.getCellValueAsDouble(x, y);
        if (this.isNoDataValue(z)) {
            return -1;
        }
        double dMaxSlope = 0.0;
        int iDir = -1;
        for (int i = 0; i < 8; ++i) {
            double z2 = this.getCellValueAsDouble(x + m_iOffsetX[i], y + m_iOffsetY[i]);
            if (this.isNoDataValue(z2)) {
                if (bForceDirToNoDataCell) {
                    return i;
                }
                return -1;
            }
            double dSlope = (z - z2) / this.getDistToNeighborInDir(i);
            if (!(dSlope > dMaxSlope)) continue;
            iDir = i;
            dMaxSlope = dSlope;
        }
        return iDir;
    }

    public GridCell[] getSortedArrayOfCells() throws GridException {
        int iNX = this.getNX();
        int iCells = this.getNX() * this.getNY();
        Object[] cells = null;
        cells = new GridCellImpl[iCells];
        for (int i = 0; i < iCells; ++i) {
            int iX = i % iNX;
            int iY = i / iNX;
            cells[i] = this.getGridCell(iX, iY);
        }
        Arrays.sort(cells);
        return cells;
    }

    public GridCell getGridCell(int iX, int iY) throws GridException {
        switch (this.getDataType()) {
            case 0: {
                return new GridCellImpl(iX, iY, this.getCellValueAsByte(iX, iY));
            }
            case 2: {
                return new GridCellImpl(iX, iY, this.getCellValueAsShort(iX, iY));
            }
            case 3: {
                return new GridCellImpl(iX, iY, this.getCellValueAsInt(iX, iY));
            }
            case 4: {
                return new GridCellImpl(iX, iY, this.getCellValueAsFloat(iX, iY));
            }
            case 5: {
                return new GridCellImpl(iX, iY, this.getCellValueAsDouble(iX, iY));
            }
        }
        return null;
    }

    public ColorTable getPalette() {
        return this.palette;
    }

    public int calculateStatistics() {
        if (this.rasterBuf != null) {
            return this.rasterBuf.getBandCount();
        }
        return 0;
    }

    public void setPalette(ColorTable palette) {
        this.palette = palette;
    }

    public RasterFilterList getFilterList() {
        return this.filterList;
    }

    public void setFilterList(RasterFilterList filterList) {
        this.filterList = filterList;
    }

    public void applyFilters() throws ProcessInterruptedException, FilterAddException {
        if (this.filterList == null) {
            return;
        }
        this.filterList.setInitRasterBuf(this.rasterBuf);
        this.filterList.addEnvParam("GridExtent", (Object)this.getGridExtent());
        this.filterList.addEnvParam("WindowExtent", (Object)this.getWindowExtent());
        this.filterList.execute();
        if (this.filterList.getResult() != null) {
            this.rasterBuf = (RasterBuffer)this.filterList.getResult();
        }
        this.dataType = this.rasterBuf.getDataType();
    }

    public Buffer getRasterBuf() {
        return this.rasterBuf;
    }

    public BasicStats getStatistics() {
        return this.statistic;
    }

    public void setBandToOperate(int band) {
        if (this.writer != null) {
            this.writer.setBandToOperate(band);
        }
        if (this.reader != null) {
            this.reader.setBandToOperate(band);
        }
        if (this.statistic != null) {
            this.statistic.setBandToOperate(band);
        }
    }

    public GridExtent getWindowExtent() {
        return this.windowExtent;
    }

    public GridExtent getGridExtent() {
        return this.layerExtent;
    }

    public void dispose() {
        if (this.rasterBuf != null) {
            this.rasterBuf.dispose();
        }
        if (this.reader != null) {
            this.reader.dispose();
        }
        if (this.writer != null) {
            this.writer.dispose();
        }
        if (this.statistic != null) {
            this.statistic.dispose();
        }
        if (this.writer != null) {
            this.writer.dispose();
        }
        try {
            this.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void finalize() throws Throwable {
        this.bands = null;
        this.rasterBuf = null;
        this.reader = null;
        this.writer = null;
        this.windowExtent = null;
        this.layerExtent = null;
        this.statistic = null;
        this.palette = null;
        this.filterList = null;
        super.finalize();
    }
}

