/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.grid.filter;

import java.util.List;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.dataset.Buffer;
import org.gvsig.fmap.dal.coverage.exception.FilterAddException;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.filter.FilterLoader;
import org.gvsig.fmap.dal.coverage.grid.RasterFilterList;
import org.gvsig.fmap.dal.coverage.store.props.HistogramComputer;
import org.gvsig.fmap.dal.coverage.store.props.Statistics;
import org.gvsig.fmap.dal.coverage.store.props.Transparency;
import org.gvsig.raster.roi.ROI;
import org.slf4j.LoggerFactory;

public class FilterLoaderImpl
implements FilterLoader {
    private RasterFilterList filterList = null;
    private Buffer inputBuffer = null;

    public FilterLoaderImpl(int dataType) {
        this.filterList = RasterLocator.getManager().createEmptyFilterList(dataType);
    }

    public FilterLoaderImpl(RasterFilterList filterList) {
        this.filterList = filterList;
    }

    public void addTransparency(Transparency transparency) {
        if (transparency != null) {
            this.filterList.addEnvParam("Transparency", (Object)transparency.cloneTransparency());
        }
    }

    public void addSrcDataType(int datatype) {
        this.filterList.addEnvParam("SrcDataType", (Object)datatype);
    }

    public void addSrcBandCount(int bandcount) {
        this.filterList.addEnvParam("SrcBandCount", (Object)bandcount);
    }

    public void addSrcStatistics(Statistics statistics) {
        this.filterList.addEnvParam("SrcStatistics", (Object)statistics);
    }

    public void addSrcROI(List<ROI> roi) {
        this.filterList.addEnvParam("SrcROI", roi);
    }

    public void addSrcHistogram(HistogramComputer histogram) {
        this.filterList.addEnvParam("SrcHistogram", (Object)histogram);
    }

    public Buffer applyFilters(Buffer buffer) {
        this.inputBuffer = buffer;
        Transparency transparency = (Transparency)this.filterList.getEnvParam("Transparency");
        if (transparency != null && transparency.existAlphaBand() && transparency.getAlphaBandNumber() >= buffer.getBandCount()) {
            transparency.setTransparencyBand(-1);
            transparency.activeTransparency();
        }
        this.filterList.setInitRasterBuf(this.inputBuffer);
        try {
            this.filterList.execute();
        }
        catch (ProcessInterruptedException e) {
            return this.inputBuffer;
        }
        catch (FilterAddException e) {
            LoggerFactory.getLogger(this.getClass()).debug("Filters cannot be applied", (Throwable)e);
            return this.inputBuffer;
        }
        if (this.filterList.getResult() != null) {
            return this.filterList.getResult();
        }
        return this.inputBuffer;
    }

    public Transparency getTransparency() {
        Transparency t = this.filterList.getTransparency();
        t.setDataBuffer(this.inputBuffer);
        return t;
    }

    public Buffer getBufferResult() {
        if (this.filterList.getResult() != null) {
            return this.filterList.getResult();
        }
        return this.inputBuffer;
    }
}

