/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.grid.filter;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.datastruct.Params;
import org.gvsig.fmap.dal.coverage.exception.FilterManagerException;
import org.gvsig.fmap.dal.coverage.exception.FilterTypeException;
import org.gvsig.fmap.dal.coverage.grid.RasterFilter;
import org.gvsig.fmap.dal.coverage.grid.RasterFilterList;
import org.gvsig.fmap.dal.coverage.grid.RasterFilterListManager;
import org.gvsig.fmap.dal.coverage.util.RasterUtils;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.extensionpoint.ExtensionPoint;
import org.gvsig.tools.extensionpoint.ExtensionPointManager;

public class RasterFilterListManagerImpl {
    protected RasterFilterList rasterFilterList = null;
    protected List<String> filterList = null;
    private List<RasterFilterListManager> managers = new ArrayList<RasterFilterListManager>();

    public RasterFilterListManagerImpl(RasterFilterList filterStack) {
        this.rasterFilterList = filterStack;
        ExtensionPointManager extensionPoints = ToolsLocator.getExtensionPointManager();
        ExtensionPoint point = extensionPoints.get("RasterFilter");
        for (ExtensionPoint.Extension entry : point) {
            Class RasterClass;
            Object obj;
            if (entry == null || (obj = RasterFilterListManagerImpl.loadClass(RasterClass = entry.getExtension(), this)) == null) continue;
            this.managers.add((RasterFilterListManager)obj);
        }
    }

    public void controlTypes() throws FilterTypeException {
        RasterUtils util = RasterLocator.getManager().getRasterUtils();
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (int i = 0; i < this.rasterFilterList.lenght(); ++i) {
            String strPackage;
            String newClass;
            Matcher m;
            Pattern p;
            String classFilter = null;
            String packageFilter = null;
            String oldClass = null;
            try {
                RasterFilter rf = this.rasterFilterList.get(i);
                if (rf == null) {
                    return;
                }
                classFilter = rf.getClass().toString();
                packageFilter = classFilter.substring(classFilter.indexOf(" ") + 1, classFilter.lastIndexOf("."));
                oldClass = classFilter.substring(classFilter.lastIndexOf(".") + 1, classFilter.length());
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                return;
            }
            catch (NullPointerException ex) {
                return;
            }
            if (i == 0) {
                if (this.rasterFilterList.getInitDataType() == this.rasterFilterList.get(i).getInRasterDataType()) continue;
                p = Pattern.compile(util.typesToString(this.rasterFilterList.get(i).getInRasterDataType()));
                m = p.matcher(oldClass);
                newClass = m.replaceAll(util.typesToString(this.rasterFilterList.getInitDataType()));
                strPackage = packageFilter + "." + newClass;
                this.renewFilterFromControlTypes(strPackage, i, exceptions);
                continue;
            }
            if (this.rasterFilterList.get(i - 1).getOutRasterDataType() == this.rasterFilterList.get(i).getInRasterDataType()) continue;
            p = Pattern.compile(util.typesToString(this.rasterFilterList.get(i).getInRasterDataType()));
            m = p.matcher(oldClass);
            newClass = m.replaceAll(util.typesToString(this.rasterFilterList.get(i - 1).getOutRasterDataType()));
            strPackage = packageFilter + "." + newClass;
            this.renewFilterFromControlTypes(strPackage.trim(), i, exceptions);
        }
        if (exceptions.size() > 0) {
            throw new FilterTypeException("");
        }
    }

    private void renewFilterFromControlTypes(String nameFilter, int pos, List<Exception> exceptions) {
        try {
            RasterFilter newFilter = this.rasterFilterList.createEmptyFilter(nameFilter);
            newFilter.setParams(this.rasterFilterList.get(pos).getParams());
            if (newFilter.getParams().get("filterName") != null) {
                newFilter.setName((String)newFilter.getParams().get("filterName"));
            } else {
                newFilter.setName(this.rasterFilterList.get(pos).getName());
            }
            this.rasterFilterList.replace(newFilter, pos);
        }
        catch (FilterTypeException e) {
            exceptions.add((Exception)((Object)e));
        }
    }

    public boolean isActive(String name) {
        return this.rasterFilterList.isActive(name);
    }

    public void removeFilter(String name) throws FilterTypeException {
        this.rasterFilterList.remove(name);
        this.controlTypes();
    }

    public static String getElem(String cadena) {
        if (cadena != null) {
            return cadena.substring(0, cadena.indexOf("="));
        }
        return null;
    }

    public static String getValue(String cadena) {
        if (cadena != null) {
            return cadena.substring(cadena.indexOf("=") + 1, cadena.length());
        }
        return null;
    }

    public static Object loadClass(Class<?> clase, RasterFilterListManagerImpl stackManager) {
        Object obj = null;
        try {
            try {
                Constructor<?> hazNuevo = clase.getConstructor(RasterFilterList.class);
                obj = hazNuevo.newInstance(stackManager.getFilterList());
            }
            catch (NoSuchMethodException e) {
                Constructor<?> hazNuevo = clase.getConstructor(RasterFilterListManagerImpl.class);
                obj = hazNuevo.newInstance(stackManager);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return obj;
    }

    public RasterFilterList getFilterList() {
        return this.rasterFilterList;
    }

    public RasterFilterListManager getManagerByID(String id) throws FilterManagerException {
        ExtensionPointManager extensionPoints = ToolsLocator.getExtensionPointManager();
        ExtensionPoint point = extensionPoints.get("RasterFilter");
        ExtensionPoint.Extension ext = point.get(id);
        if (ext != null) {
            Class clase = ext.getExtension();
            Class[] args = new Class[]{RasterFilterListManagerImpl.class};
            try {
                Constructor hazNuevo = clase.getConstructor(args);
                Object[] args2 = new Object[]{this};
                return (RasterFilterListManager)hazNuevo.newInstance(args2);
            }
            catch (SecurityException e) {
                throw new FilterManagerException("Error SecurityException in open", (Exception)e);
            }
            catch (NoSuchMethodException e) {
                throw new FilterManagerException("Error NoSuchMethodException in open", (Exception)e);
            }
            catch (IllegalArgumentException e) {
                throw new FilterManagerException("Error IllegalArgumentException in open", (Exception)e);
            }
            catch (InstantiationException e) {
                throw new FilterManagerException("Error InstantiationException in open", (Exception)e);
            }
            catch (IllegalAccessException e) {
                throw new FilterManagerException("Error IllegalAccessException in open", (Exception)e);
            }
            catch (InvocationTargetException e) {
                throw new FilterManagerException("Error opening this image with " + clase, (Exception)e);
            }
        }
        return null;
    }

    public RasterFilterListManager getManagerByClass(Class<?> c) {
        for (int j = 0; j < this.managers.size(); ++j) {
            if (!this.managers.get(j).getClass().equals(c)) continue;
            return this.managers.get(j);
        }
        return null;
    }

    public RasterFilterListManager getManagerByFilterClass(Class<?> c) {
        for (int i = 0; i < this.managers.size(); ++i) {
            RasterFilterListManager localMan = this.managers.get(i);
            for (int j = 0; j < localMan.getRasterFilterList().size(); ++j) {
                Class f = (Class)localMan.getRasterFilterList().get(j);
                if (!f.isAssignableFrom(c)) continue;
                return localMan;
            }
        }
        return null;
    }

    public List<Class<?>> getRasterFilterList() {
        ArrayList filters = new ArrayList();
        for (int i = 0; i < this.managers.size(); ++i) {
            List auxFilters = this.managers.get(i).getRasterFilterList();
            for (int j = 0; j < auxFilters.size(); ++j) {
                filters.add((Class<?>)auxFilters.get(j));
            }
        }
        return filters;
    }

    public List<Class<?>> getRasterFilterListByDataType(int dataType) {
        ArrayList filters = new ArrayList();
        for (int i = 0; i < this.managers.size(); ++i) {
            RasterFilterListManager man = this.managers.get(i);
            if (!man.isDataTypeSupported(dataType)) continue;
            List auxFilters = man.getRasterFilterList();
            for (int j = 0; j < auxFilters.size(); ++j) {
                filters.add((Class<?>)auxFilters.get(j));
            }
        }
        return filters;
    }

    public void addFilter(Class<?> classFilter, Params params) throws FilterTypeException {
    }

    public void addFilter(Params params) throws FilterTypeException {
        throw new FilterTypeException("Method not implemented in globar manager");
    }

    protected void finalize() throws Throwable {
        this.rasterFilterList = null;
        if (this.managers != null) {
            this.managers.clear();
            this.managers = null;
        }
        if (this.filterList != null) {
            this.filterList.clear();
            this.filterList = null;
        }
        super.finalize();
    }
}

