/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.grid.filter.convolution;

import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.dal.coverage.datastruct.Params;
import org.gvsig.fmap.dal.coverage.exception.FilterTypeException;
import org.gvsig.fmap.dal.coverage.grid.AbstractRasterFilterManager;
import org.gvsig.fmap.dal.coverage.grid.RasterFilter;
import org.gvsig.fmap.dal.coverage.grid.RasterFilterList;
import org.gvsig.fmap.dal.coverage.grid.RegistrableFilterListener;
import org.gvsig.raster.impl.datastruct.Kernel;
import org.gvsig.raster.impl.grid.filter.RasterFilterListManagerImpl;
import org.gvsig.raster.impl.grid.filter.convolution.ConvolutionByteFilter;
import org.gvsig.raster.impl.grid.filter.convolution.ConvolutionFilter;
import org.gvsig.raster.impl.grid.filter.convolution.ConvolutionUI;
import org.gvsig.raster.impl.store.ParamImpl;

public class ConvolutionListManager
extends AbstractRasterFilterManager {
    private static String ID = "Convolucion";

    public ConvolutionListManager(RasterFilterList filterList) {
        super(filterList);
    }

    public String getManagerID() {
        return ID;
    }

    public static void register() {
        AbstractRasterFilterManager.register((String)ID, ConvolutionListManager.class, ConvolutionUI.class);
    }

    public boolean isDataTypeSupported(int dataType) {
        return true;
    }

    public Class<?> getFilterClassByID(String id) {
        if (id.compareTo("media") == 0 || id.compareTo("pasobajo") == 0 || id.compareTo("sharpen") == 0 || id.compareTo("gauss") == 0 || id.compareTo("personalizado") == 0) {
            return ConvolutionFilter.class;
        }
        return null;
    }

    public ConvolutionListManager(RasterFilterListManagerImpl filterListManager) {
        super(filterListManager.getFilterList());
    }

    public void addConvolutionFilter(String Name, int ladoVentana, double agudeza, Kernel kernel) throws FilterTypeException {
        ConvolutionByteFilter filter = new ConvolutionByteFilter();
        if (filter != null) {
            filter.addParam("ladoVentana", ladoVentana);
            filter.addParam("Agudeza", agudeza);
            filter.addParam("filterName", String.valueOf(Name));
            filter.addParam("kernel", kernel);
            this.getFilterList().add((RasterFilter)filter);
        }
    }

    public void addFilter(Class<?> classFilter, Params params) throws FilterTypeException {
        if (ConvolutionFilter.class.isAssignableFrom(classFilter)) {
            int i;
            int ladoVentana = 0;
            double agudeza = 0.0;
            Kernel kernel = null;
            String name = "";
            for (i = 0; i < params.getNumParams(); ++i) {
                if (!((ParamImpl)params.getParam(i)).getId().equals("Panel") || !(((ParamImpl)params.getParam(i)).getDefaultValue() instanceof RegistrableFilterListener)) continue;
                params = ((RegistrableFilterListener)((ParamImpl)params.getParam(i)).getDefaultValue()).getParams();
                break;
            }
            for (i = 0; i < params.getNumParams(); ++i) {
                Object obj;
                if (((ParamImpl)params.getParam(i)).getId().equals("LadoVentana") && ((ParamImpl)params.getParam(i)).getDefaultValue() instanceof Integer) {
                    ladoVentana = (Integer)((ParamImpl)params.getParam(i)).getDefaultValue();
                }
                if (((ParamImpl)params.getParam(i)).getId().equals("FilterName") && (obj = ((ParamImpl)params.getParam(i)).getDefaultValue()) != null) {
                    name = new String((String)((ParamImpl)params.getParam(i)).getDefaultValue());
                }
                if (((ParamImpl)params.getParam(i)).getId().equals("Kernel") && ((ParamImpl)params.getParam(i)).getDefaultValue() instanceof Kernel) {
                    kernel = (Kernel)((ParamImpl)params.getParam(i)).getDefaultValue();
                }
                if (!((ParamImpl)params.getParam(i)).getId().equals("Agudeza") || !(((ParamImpl)params.getParam(i)).getDefaultValue() instanceof Double)) continue;
                agudeza = (Double)((ParamImpl)params.getParam(i)).getDefaultValue();
            }
            this.addConvolutionFilter(name, ladoVentana, agudeza, kernel);
        }
    }

    public void addFilter(Params params) throws FilterTypeException {
        this.addFilter(ConvolutionFilter.class, params);
    }

    public RasterFilter createFilter(Params params) {
        Integer ladoVentana = (Integer)params.getParamById("LadoVentana").getDefaultValue();
        String name = (String)params.getParamById("FilterName").getDefaultValue();
        Kernel kernel = (Kernel)params.getParamById("Kernel").getDefaultValue();
        Double agudeza = (Double)params.getParamById("Agudeza").getDefaultValue();
        ConvolutionByteFilter filter = new ConvolutionByteFilter();
        filter.addParam("LadoVentana", ladoVentana);
        filter.addParam("Agudeza", agudeza);
        filter.addParam("filterName", name);
        filter.addParam("kernel", kernel);
        return filter;
    }

    public List<Class<?>> getRasterFilterList() {
        ArrayList filters = new ArrayList();
        filters.add(ConvolutionFilter.class);
        return filters;
    }
}

