/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.grid.filter.correction;

import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.dal.coverage.datastruct.Params;
import org.gvsig.fmap.dal.coverage.exception.FilterTypeException;
import org.gvsig.fmap.dal.coverage.grid.AbstractRasterFilterManager;
import org.gvsig.fmap.dal.coverage.grid.RasterFilter;
import org.gvsig.fmap.dal.coverage.grid.RasterFilterList;
import org.gvsig.raster.impl.grid.filter.RasterFilterListManagerImpl;
import org.gvsig.raster.impl.grid.filter.correction.ModeByteFilter;
import org.gvsig.raster.impl.grid.filter.correction.ModeFilter;
import org.gvsig.raster.impl.store.ParamImpl;

public class ModeManager
extends AbstractRasterFilterManager {
    private static String ID = "Moda";

    public ModeManager(RasterFilterList filterList) {
        super(filterList);
    }

    public String getManagerID() {
        return ID;
    }

    public static void register() {
        AbstractRasterFilterManager.register((String)ID, ModeManager.class);
    }

    public ModeManager(RasterFilterListManagerImpl filterListManager) {
        super(filterListManager.getFilterList());
    }

    public boolean isDataTypeSupported(int dataType) {
        return true;
    }

    public Class<?> getFilterClassByID(String id) {
        if (id.compareTo("moda") == 0) {
            return ModeFilter.class;
        }
        return null;
    }

    public void addModeFilter(int sideLong) throws FilterTypeException {
        ModeByteFilter filter = new ModeByteFilter();
        if (filter != null) {
            filter.addParam("sideLong", new Integer(sideLong));
            this.getFilterList().add((RasterFilter)filter);
        }
    }

    public List<Class<?>> getRasterFilterList() {
        ArrayList filters = new ArrayList();
        filters.add(ModeFilter.class);
        return filters;
    }

    public void addFilter(Class<?> classFilter, Params params) throws FilterTypeException {
        if (ModeFilter.class.isAssignableFrom(classFilter)) {
            int sideLong = 0;
            for (int i = 0; i < params.getNumParams(); ++i) {
                if (!((ParamImpl)params.getParam(i)).getId().equals("sideLong") || !(((ParamImpl)params.getParam(i)).getDefaultValue() instanceof Integer)) continue;
                sideLong = (Integer)((ParamImpl)params.getParam(i)).getDefaultValue();
            }
            this.addModeFilter(sideLong);
        }
    }

    public void addFilter(Params params) throws FilterTypeException {
        this.addFilter(ModeFilter.class, params);
    }

    public RasterFilter createFilter(Params params) {
        if (params.getParamById("sideLong") != null) {
            int sideLong = (Integer)params.getParamById("sideLong").getDefaultValue();
            ModeByteFilter filter = new ModeByteFilter();
            filter.addParam("sideLong", new Integer(sideLong));
            return filter;
        }
        return null;
    }
}

