/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.grid.roi;

import org.gvsig.fmap.dal.coverage.exception.GridException;
import org.gvsig.fmap.dal.coverage.exception.OutOfGridException;
import org.gvsig.fmap.dal.coverage.grid.Grid;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.raster.impl.grid.roi.ROIStatistic;
import org.gvsig.raster.roi.AbstractROI;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;

public class RasterROI
extends AbstractROI {
    private Grid maskGrid = null;

    public RasterROI(RasterDataStore store) {
        super(store);
    }

    public boolean isInsideOfPolygon(int x, int y) {
        try {
            return this.maskGrid.isInGrid(x, y) && !this.maskGrid.isNoDataValue(this.getValue(x, y));
        }
        catch (GridException e) {
            return false;
        }
    }

    public Grid getMaskGrid() {
        return this.maskGrid;
    }

    private double getValue(int x, int y) throws GridException {
        switch (this.getMaskGrid().getDataType()) {
            case 0: {
                return this.getMaskGrid().getCellValueAsByte(x, y);
            }
            case 2: {
                return this.getMaskGrid().getCellValueAsShort(x, y);
            }
            case 3: {
                return this.getMaskGrid().getCellValueAsInt(x, y);
            }
            case 4: {
                return this.getMaskGrid().getCellValueAsFloat(x, y);
            }
            case 5: {
                return this.getMaskGrid().getCellValueAsDouble(x, y);
            }
        }
        return 0.0;
    }

    public void addPoint(int x, int y) {
        try {
            this.maskGrid.setCellValue(x, y, 1);
            this.getStatistic().setCalculated(false);
            ((ROIStatistic)this.getStatistic()).setAdvancedStatisticCalculated(false);
        }
        catch (OutOfGridException e) {
            e.printStackTrace();
        }
    }

    public void removePoint(int x, int y) {
        this.maskGrid.setNoData(x, y);
        this.getStatistic().setCalculated(false);
        ((ROIStatistic)this.getStatistic()).setAdvancedStatisticCalculated(false);
    }

    public void clear() {
        for (int x = 0; x < this.maskGrid.getNX(); ++x) {
            for (int y = 0; y < this.maskGrid.getNY(); ++y) {
                this.maskGrid.setNoData(x, y);
            }
        }
        this.getStatistic().setCalculated(false);
        ((ROIStatistic)this.getStatistic()).setAdvancedStatisticCalculated(false);
    }

    public boolean isInside(double x, double y, double w, double h) {
        return false;
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        super.loadFromState(state);
        this.maskGrid = (Grid)state.get("maskGrid");
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        super.saveToState(state);
        state.set("maskGrid", (Object)this.maskGrid);
    }

    public static void registerPersistence() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        DynStruct definition = manager.getDefinition("AbstractROI_Persistent");
        if (definition == null) {
            definition = manager.addDefinition(RasterROI.class, "AbstractROI_Persistent", "AbstractROI Persistent", null, null);
            definition.addDynFieldObject("maskGrid").setClassOfValue(RasterROI.class).setMandatory(true);
        }
    }
}

