/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.provider.fusion;

import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.gvsig.fmap.dal.coverage.dataset.Buffer;
import org.gvsig.fmap.dal.coverage.datastruct.Extent;
import org.gvsig.raster.impl.provider.fusion.PixelSquareStructure;

public abstract class AbstractFusionMethod {
    protected PixelSquareStructure pxSquare = null;

    public AbstractFusionMethod(PixelSquareStructure pxSquare) {
        this.pxSquare = pxSquare;
    }

    public abstract Byte getByteValue(int var1, int var2, int var3);

    public abstract Float getFloatValue(int var1, int var2, int var3);

    public abstract int getBandCount();

    public class SubSquare {
        private Buffer buffer = null;
        private AffineTransform parentTransform = null;
        private AffineTransform squareTransform = null;
        private Extent squareExtent = null;

        public SubSquare(Extent parentExtent, Rectangle2D parentSize, Extent squareExtent, Rectangle2D squareSize, Buffer buf) {
            this.buffer = buf;
            this.squareExtent = squareExtent;
            this.parentTransform = new AffineTransform(parentExtent.width() / parentSize.getWidth(), 0.0, 0.0, -(parentExtent.height() / parentSize.getHeight()), parentExtent.getULX(), parentExtent.getULY());
            this.squareTransform = new AffineTransform(squareExtent.width() / squareSize.getWidth(), 0.0, 0.0, -(squareExtent.height() / squareSize.getHeight()), squareExtent.getULX(), squareExtent.getULY());
        }

        private Point2D parentRasterToWorld(Point2D pt) {
            return this.parentTransform.transform(pt, pt);
        }

        private Point2D squareWorldToRaster(Point2D pt) {
            try {
                return this.squareTransform.inverseTransform(pt, pt);
            }
            catch (NoninvertibleTransformException e) {
                return pt;
            }
        }

        public Point2D getLocalCoords(int row, int col) {
            Point2D p = this.parentRasterToWorld(new Point2D.Double(col, row));
            if (p.getX() >= this.squareExtent.getULX() && p.getX() <= this.squareExtent.getLRX() && p.getY() <= this.squareExtent.getULY() && p.getY() >= this.squareExtent.getLRY()) {
                return this.squareWorldToRaster(p);
            }
            return null;
        }

        public Buffer getBuffer() {
            return this.buffer;
        }
    }
}

