/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.provider.fusion;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.dal.coverage.dataset.Buffer;
import org.gvsig.raster.impl.datastruct.ExtentImpl;
import org.gvsig.raster.impl.provider.fusion.AbstractFusionMethod;
import org.gvsig.raster.impl.provider.fusion.PixelSquareStructure;

public class FirstFusionMethod
extends AbstractFusionMethod {
    protected SubSquareList subSquareList = null;
    private int bandCount = 0;
    private int[] lastPixelCoords = new int[]{-1, -1};
    private byte[] dataByte = null;
    private short[] dataShort = null;
    private int[] dataInt = null;
    private float[] dataFloat = null;
    private double[] dataDouble = null;

    public FirstFusionMethod(List<Buffer> bufferList, PixelSquareStructure pxSquare) {
        super(pxSquare);
        int i;
        switch (pxSquare.dataType) {
            case 0: {
                this.dataByte = new byte[pxSquare.bandCount];
                break;
            }
            case 2: {
                this.dataShort = new short[pxSquare.bandCount];
                break;
            }
            case 3: {
                this.dataInt = new int[pxSquare.bandCount];
                break;
            }
            case 4: {
                this.dataFloat = new float[pxSquare.bandCount];
                break;
            }
            case 5: {
                this.dataDouble = new double[pxSquare.bandCount];
            }
        }
        for (i = 0; i < bufferList.size(); ++i) {
            this.bandCount = bufferList.get(i).getBandCount() > this.bandCount ? bufferList.get(i).getBandCount() : this.bandCount;
        }
        this.subSquareList = new SubSquareList(this.bandCount);
        for (i = 0; i < bufferList.size(); ++i) {
            AbstractFusionMethod.SubSquare square = new AbstractFusionMethod.SubSquare(pxSquare.bbox, new Rectangle2D.Double(0.0, 0.0, pxSquare.width, pxSquare.height), new ExtentImpl(bufferList.get(i).getDataExtent()), new Rectangle2D.Double(0.0, 0.0, bufferList.get(i).getWidth(), bufferList.get(i).getHeight()), bufferList.get(i));
            this.subSquareList.add(square);
        }
    }

    @Override
    public Byte getByteValue(int row, int col, int band) {
        if (row != this.lastPixelCoords[0] || col != this.lastPixelCoords[1]) {
            this.dataByte = this.subSquareList.getByteValue(row, col);
            this.lastPixelCoords[0] = row;
            this.lastPixelCoords[1] = col;
        }
        if (this.dataByte != null) {
            return this.dataByte[band];
        }
        return null;
    }

    @Override
    public Float getFloatValue(int row, int col, int band) {
        if (row == this.lastPixelCoords[0] && col == this.lastPixelCoords[1]) {
            this.dataFloat = this.subSquareList.getFloatValue(row, col);
            this.lastPixelCoords[0] = row;
            this.lastPixelCoords[1] = col;
        }
        if (this.dataFloat != null) {
            return Float.valueOf(this.dataFloat[band]);
        }
        return null;
    }

    @Override
    public int getBandCount() {
        return this.bandCount;
    }

    public class SubSquareList
    extends ArrayList<AbstractFusionMethod.SubSquare> {
        private static final long serialVersionUID = 1L;
        private int bandCount = 0;

        public SubSquareList(int bandCount) {
            this.bandCount = bandCount;
        }

        public byte[] getByteValue(int row, int col) {
            byte[] value = new byte[this.bandCount];
            for (int i = 0; i < this.size(); ++i) {
                Point2D coord = ((AbstractFusionMethod.SubSquare)this.get(i)).getLocalCoords(row, col);
                if (coord == null) continue;
                ((AbstractFusionMethod.SubSquare)this.get(i)).getBuffer().getElemByte((int)coord.getY(), (int)coord.getX(), value);
                return value;
            }
            return null;
        }

        public float[] getFloatValue(int row, int col) {
            float[] value = new float[this.bandCount];
            for (int i = 0; i < this.size(); ++i) {
                Point2D coord = ((AbstractFusionMethod.SubSquare)this.get(i)).getLocalCoords(row, col);
                if (coord == null) continue;
                ((AbstractFusionMethod.SubSquare)this.get(i)).getBuffer().getElemFloat((int)coord.getY(), (int)coord.getX(), value);
                return value;
            }
            return null;
        }
    }
}

