/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.store.serializer;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.gvsig.fmap.dal.coverage.exception.ParsingException;
import org.gvsig.fmap.dal.coverage.store.props.Statistics;
import org.gvsig.raster.impl.store.properties.AbstractStatistics;
import org.gvsig.raster.impl.store.properties.SimpleProviderStatistics;
import org.gvsig.raster.impl.store.rmf.ClassSerializer;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.extensionpoint.ExtensionPoint;
import org.gvsig.tools.extensionpoint.ExtensionPointManager;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;

public class StatisticsRmfSerializer
extends ClassSerializer {
    public static final String MAIN_TAG = "Statistics";
    public static final String BAND = "Band";
    public static final String MIN = "Min";
    public static final String MAX = "Max";
    public static final String SNDMIN = "SecondMin";
    public static final String SNDMAX = "SecondMax";
    public static final String MINRGB = "MinRGB";
    public static final String MAXRGB = "MaxRGB";
    public static final String SNDMINRGB = "SecondMinRGB";
    public static final String SNDMAXRGB = "SecondMaxRGB";
    public static final String MAXIMUN = "Maximun";
    public static final String MINIMUN = "Minimun";
    public static final String MEAN = "Mean";
    public static final String VARIANCE = "Variance";
    public static final String NVALUES = "NValues";
    public static final String BANDCOUNT = "BandCount";
    public static final String TAILTRIM = "TailTrim";
    public static final String KEY = "Key";
    public static final String VALUE = "Value";
    private AbstractStatistics stat = null;

    public static void register() {
        ExtensionPointManager extensionPoints = ToolsLocator.getExtensionPointManager();
        ExtensionPoint point = extensionPoints.get("Serializer");
        point.append(MAIN_TAG, "", StatisticsRmfSerializer.class);
    }

    public StatisticsRmfSerializer(Statistics stat) {
        this.stat = (AbstractStatistics)stat;
    }

    public StatisticsRmfSerializer(AbstractStatistics stat) {
        this.stat = stat;
    }

    private AbstractStatistics getDatasetStatistics() {
        if (this.stat == null) {
            this.stat = new SimpleProviderStatistics(null);
        }
        return this.stat;
    }

    public StatisticsRmfSerializer() {
    }

    private long[] parserStatBandValues(KXmlParser parser, int band, double[] max, double[] min, double[] sndmax, double[] sndmin, double[] maxRGB, double[] minRGB, double[] sndmaxRGB, double[] sndminRGB, double[] mean, double[] variance, long[] nValues) throws XmlPullParserException, IOException {
        boolean maxOk = false;
        boolean minOk = false;
        boolean sndmaxOk = false;
        boolean sndminOk = false;
        boolean meanOk = false;
        boolean varianceOk = false;
        boolean nvaluesOk = false;
        boolean maxRGBOk = false;
        boolean minRGBOk = false;
        boolean sndmaxRGBOk = false;
        boolean sndminRGBOk = false;
        long[] valueList = null;
        boolean end = false;
        int tag = parser.next();
        while (!end) {
            switch (tag) {
                case 2: {
                    if (parser.getName() == null) break;
                    if (parser.getName().compareTo(MAX) == 0) {
                        maxOk = true;
                    }
                    if (parser.getName().compareTo(MIN) == 0) {
                        minOk = true;
                    }
                    if (parser.getName().compareTo(SNDMAX) == 0) {
                        sndmaxOk = true;
                    }
                    if (parser.getName().compareTo(SNDMIN) == 0) {
                        sndminOk = true;
                    }
                    if (parser.getName().compareTo(MAXRGB) == 0) {
                        maxRGBOk = true;
                    }
                    if (parser.getName().compareTo(MINRGB) == 0) {
                        minRGBOk = true;
                    }
                    if (parser.getName().compareTo(SNDMAXRGB) == 0) {
                        sndmaxRGBOk = true;
                    }
                    if (parser.getName().compareTo(SNDMINRGB) == 0) {
                        sndminRGBOk = true;
                    }
                    if (parser.getName().compareTo(MEAN) == 0) {
                        meanOk = true;
                    }
                    if (parser.getName().compareTo(VARIANCE) == 0) {
                        varianceOk = true;
                    }
                    if (parser.getName().compareTo(NVALUES) != 0) break;
                    nvaluesOk = true;
                    break;
                }
                case 3: {
                    if (parser.getName().compareTo(BAND) != 0) break;
                    end = true;
                    break;
                }
                case 4: {
                    if (maxOk) {
                        max[band] = Double.parseDouble(parser.getText());
                        maxOk = false;
                    }
                    if (minOk) {
                        min[band] = Double.parseDouble(parser.getText());
                        minOk = false;
                    }
                    if (sndmaxOk) {
                        sndmax[band] = Double.parseDouble(parser.getText());
                        sndmaxOk = false;
                    }
                    if (sndminOk) {
                        sndmin[band] = Double.parseDouble(parser.getText());
                        sndminOk = false;
                    }
                    if (maxRGBOk) {
                        maxRGB[band] = Double.parseDouble(parser.getText());
                        maxRGBOk = false;
                    }
                    if (minRGBOk) {
                        minRGB[band] = Double.parseDouble(parser.getText());
                        minRGBOk = false;
                    }
                    if (sndmaxRGBOk) {
                        sndmaxRGB[band] = Double.parseDouble(parser.getText());
                        sndmaxRGBOk = false;
                    }
                    if (sndminRGBOk) {
                        sndminRGB[band] = Double.parseDouble(parser.getText());
                        sndminRGBOk = false;
                    }
                    if (meanOk) {
                        mean[band] = Double.parseDouble(parser.getText());
                        meanOk = false;
                    }
                    if (varianceOk) {
                        variance[band] = Double.parseDouble(parser.getText());
                        varianceOk = false;
                    }
                    if (!nvaluesOk) break;
                    nValues[band] = Long.parseLong(parser.getText());
                    nvaluesOk = false;
                }
            }
            if (end) continue;
            tag = parser.next();
        }
        return valueList;
    }

    @Override
    public void read(String xml) throws ParsingException {
        int bandCount = 0;
        double[] max = null;
        double[] maxRGB = null;
        double[] min = null;
        double[] minRGB = null;
        double[] secondMax = null;
        double[] secondMaxRGB = null;
        double[] secondMin = null;
        double[] secondMinRGB = null;
        double[] mean = null;
        double[] variance = null;
        long[] nValues = null;
        KXmlParser parser = new KXmlParser();
        StringReader reader = new StringReader(xml);
        try {
            parser.setInput((Reader)reader);
        }
        catch (XmlPullParserException e) {
            throw new ParsingException(xml);
        }
        try {
            int tag = parser.nextTag();
            if (parser.getEventType() != 1) {
                parser.require(2, null, MAIN_TAG);
                while (tag != 1) {
                    switch (tag) {
                        case 2: {
                            if (parser.getName() == null || parser.getName().compareTo(MAIN_TAG) != 0) break;
                            bandCount = Integer.parseInt(this.parserString(parser, BANDCOUNT, null));
                            if (max == null) {
                                max = new double[bandCount];
                                min = new double[bandCount];
                                secondMax = new double[bandCount];
                                secondMin = new double[bandCount];
                                maxRGB = new double[bandCount];
                                minRGB = new double[bandCount];
                                secondMaxRGB = new double[bandCount];
                                secondMinRGB = new double[bandCount];
                                mean = new double[bandCount];
                                variance = new double[bandCount];
                                nValues = new long[bandCount];
                            }
                            for (int i = 0; i < bandCount; ++i) {
                                this.parserStatBandValues(parser, i, max, min, secondMax, secondMin, maxRGB, minRGB, secondMaxRGB, secondMinRGB, mean, variance, nValues);
                            }
                            break;
                        }
                        case 3: {
                            break;
                        }
                    }
                    tag = parser.next();
                }
                parser.require(1, null, null);
            }
        }
        catch (XmlPullParserException e) {
            throw new ParsingException(xml);
        }
        catch (IOException e) {
            throw new ParsingException(xml);
        }
        this.getDatasetStatistics().setBandCount(bandCount);
        this.getDatasetStatistics().setMax(max);
        this.getDatasetStatistics().setMin(min);
        this.getDatasetStatistics().setSecondMax(secondMax);
        this.getDatasetStatistics().setSecondMin(secondMin);
        this.getDatasetStatistics().setMaxRGB(maxRGB);
        this.getDatasetStatistics().setMinRGB(minRGB);
        this.getDatasetStatistics().setSecondMaxRGB(secondMaxRGB);
        this.getDatasetStatistics().setSecondMinRGB(secondMinRGB);
        this.getDatasetStatistics().setMean(mean);
        this.getDatasetStatistics().setVariance(variance);
        this.getDatasetStatistics().setNumberOfValues(nValues);
        this.getDatasetStatistics().setCalculated(true);
    }

    @Override
    public String write() {
        if (this.stat == null) {
            return "";
        }
        StringBuffer b = new StringBuffer();
        b.append("<Statistics>\n");
        this.putProperty(b, BANDCOUNT, this.getDatasetStatistics().getBandCount(), 1);
        for (int i = 0; i < this.getDatasetStatistics().getBandCount(); ++i) {
            b.append("\t<Band>\n");
            if (this.getDatasetStatistics().getMax() != null) {
                this.putProperty(b, MAX, this.getDatasetStatistics().getMax()[i], 2);
            }
            if (this.getDatasetStatistics().getMin() != null) {
                this.putProperty(b, MIN, this.getDatasetStatistics().getMin()[i], 2);
            }
            if (this.getDatasetStatistics().getSecondMax() != null) {
                this.putProperty(b, SNDMAX, this.getDatasetStatistics().getSecondMax()[i], 2);
            }
            if (this.getDatasetStatistics().getSecondMin() != null) {
                this.putProperty(b, SNDMIN, this.getDatasetStatistics().getSecondMin()[i], 2);
            }
            if (this.getDatasetStatistics().getMaxByteUnsigned() != null) {
                this.putProperty(b, MAXRGB, this.getDatasetStatistics().getMaxByteUnsigned()[i], 2);
            }
            if (this.getDatasetStatistics().getMinByteUnsigned() != null) {
                this.putProperty(b, MINRGB, this.getDatasetStatistics().getMinByteUnsigned()[i], 2);
            }
            if (this.getDatasetStatistics().getSecondMaxByteUnsigned() != null) {
                this.putProperty(b, SNDMAXRGB, this.getDatasetStatistics().getSecondMaxByteUnsigned()[i], 2);
            }
            if (this.getDatasetStatistics().getSecondMinByteUnsigned() != null) {
                this.putProperty(b, SNDMINRGB, this.getDatasetStatistics().getSecondMinByteUnsigned()[i], 2);
            }
            if (this.getDatasetStatistics().getMean() != null) {
                this.putProperty(b, MEAN, this.getDatasetStatistics().getMean()[i], 2);
            }
            if (this.getDatasetStatistics().getVariance() != null) {
                this.putProperty(b, VARIANCE, this.getDatasetStatistics().getVariance()[i], 2);
            }
            if (this.getDatasetStatistics().getNumberOfValues() != null) {
                this.putProperty(b, NVALUES, new Long(this.getDatasetStatistics().getNumberOfValues()[i]).toString(), 2);
            }
            b.append("\t</Band>\n");
        }
        b.append("</Statistics>\n");
        return b.toString();
    }

    @Override
    public Object getResult() {
        return this.stat;
    }

    @Override
    public String getMainTag() {
        return MAIN_TAG;
    }
}

