/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.symboltable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang3.Range;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.ExpressionEvaluatorLocator;
import org.gvsig.expressionevaluator.ExpressionEvaluatorManager;
import org.gvsig.expressionevaluator.Function;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.MutableSymbolTable;
import org.gvsig.expressionevaluator.SymbolTable;
import org.gvsig.expressionevaluator.spi.AbstractFunction;
import org.gvsig.expressionevaluator.spi.AbstractSymbolTable;
import org.gvsig.fmap.dal.expressionevaluator.FeatureSymbolTable;
import org.gvsig.fmap.dal.expressionevaluator.TableAttributeHandler;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;

public class FeatureSymbolTableImpl
extends AbstractSymbolTable
implements FeatureSymbolTable {
    private static final String DAL_SYMBOL_TABLE_FEATURE = "DALSymbolTableFeature";
    private final Function current_row = new AbstractFunction("Data access", "CURRENT_ROW", Range.is((Comparable)Integer.valueOf(0)), "Return the current row when used in a table filter.\nReturn null if used outer a table filter.", "CURRENT_ROW()", null, "Feature"){

        public Object call(Interpreter interpreter, Object[] args) throws Exception {
            return FeatureSymbolTableImpl.this.feature;
        }
    };
    private Feature feature;
    private FeatureType type;
    private String storeName;
    private final TableAttributeHandler storeAttributeHandler = new TableAttributeHandler(){

        public Object get(String name) {
            if (FeatureSymbolTableImpl.this.feature == null) {
                return null;
            }
            try {
                return FeatureSymbolTableImpl.this.feature.get(name);
            }
            catch (Exception ex) {
                return FeatureSymbolTableImpl.this.feature.getExtraValue(name);
            }
        }

        public String getName() {
            return FeatureSymbolTableImpl.this.storeName;
        }
    };

    public FeatureSymbolTableImpl() {
        this(DAL_SYMBOL_TABLE_FEATURE);
    }

    public FeatureSymbolTableImpl(String name) {
        super(name);
    }

    public Collection<String> localvariables() {
        ArrayList<String> v = new ArrayList<String>();
        v.add("$TABLE");
        v.add("$ROW");
        try {
            if (this.feature != null) {
                for (FeatureAttributeDescriptor attr : this.feature.getType()) {
                    v.add(attr.getName());
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        v.addAll(super.localvariables());
        return Collections.unmodifiableCollection(v);
    }

    public FeatureSymbolTableImpl clone() throws CloneNotSupportedException {
        FeatureSymbolTableImpl other = (FeatureSymbolTableImpl)super.clone();
        return other;
    }

    public Function function(String name) {
        if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)"CURRENT_ROW")) {
            return this.current_row;
        }
        return super.function(name);
    }

    public boolean exists(String name) {
        if (this.feature != null && this.feature.hasValue(name)) {
            return true;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)this.storeName) || StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)"$TABLE") || StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)"$ROW")) {
            return true;
        }
        return super.exists(name);
    }

    public Object value(String name) {
        block4: {
            if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)this.storeName) || StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)"$TABLE")) {
                return this.storeAttributeHandler;
            }
            if (this.feature != null) {
                try {
                    return this.feature.get(name);
                }
                catch (Exception exception) {
                    if (!StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)"$ROW")) break block4;
                    return this.feature;
                }
            }
        }
        return super.value(name);
    }

    public void setVar(String name, Object value) {
        if (this.feature instanceof EditableFeature && this.feature.hasValue(name)) {
            ((EditableFeature)this.feature).set(name, value);
            return;
        }
        super.setVar(name, value);
    }

    public boolean isSQLCompatible(String name) {
        if (this.type == null) {
            return super.isSQLCompatible(name);
        }
        FeatureAttributeDescriptor attrdesc = this.type.getAttributeDescriptor(name);
        if (attrdesc == null) {
            return true;
        }
        return !attrdesc.isComputed();
    }

    public void setFeature(Feature feature) {
        this.feature = feature;
        if (this.type == null && this.feature != null) {
            this.type = feature.getType();
            FeatureStore store = feature.getStore();
            if (store != null) {
                this.storeName = store.getName();
            }
        }
    }

    public MutableSymbolTable createParent() {
        ExpressionEvaluatorManager expManager = ExpressionEvaluatorLocator.getManager();
        MutableSymbolTable symbolTable = expManager.createSymbolTable();
        symbolTable.addSymbolTable((SymbolTable)this);
        return symbolTable;
    }

    public Feature getFeature() {
        return this.feature;
    }
}

