/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.feature.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureIndex;
import org.gvsig.fmap.dal.feature.FeatureIndexes;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.exception.FeatureIndexException;
import org.gvsig.fmap.dal.feature.impl.DefaultFeatureIndex;
import org.gvsig.fmap.dal.feature.impl.DefaultFeatureStore;
import org.gvsig.fmap.dal.feature.impl.IndexFeatureSet;
import org.gvsig.fmap.dal.feature.spi.index.FeatureIndexProviderServices;
import org.gvsig.tools.evaluator.Evaluator;
import org.gvsig.tools.evaluator.EvaluatorFieldValue;
import org.gvsig.tools.evaluator.EvaluatorFieldValueMatch;
import org.gvsig.tools.evaluator.EvaluatorFieldValueNearest;
import org.gvsig.tools.evaluator.EvaluatorFieldValueRange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFeatureIndexes
implements FeatureIndexes {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultFeatureIndexes.class);
    private Map names = new HashMap();
    private DefaultFeatureStore store;

    public DefaultFeatureIndexes(DefaultFeatureStore store) throws DataException {
        this.store = store;
    }

    public FeatureIndex getFeatureIndex(String name) {
        return (FeatureIndex)this.names.get(name);
    }

    public void addIndex(FeatureIndexProviderServices index) {
        this.names.put(index.getName(), index);
    }

    public Iterator iterator() {
        return this.names.values().iterator();
    }

    public FeatureSet getFeatureSet(Evaluator evaluator) throws FeatureIndexException {
        class ApplyIndex {
            DefaultFeatureIndex index;
            EvaluatorFieldValue[] data;

            ApplyIndex(DefaultFeatureIndex index, EvaluatorFieldValue[] data) {
                this.index = index;
                this.data = data;
            }

            boolean isSupported() {
                switch (this.data[0].getType()) {
                    case 1: {
                        return this.index.getFeatureIndexProvider().isMatchSupported();
                    }
                    case 3: {
                        return this.index.getFeatureIndexProvider().isNearestSupported();
                    }
                    case 2: {
                        return this.index.getFeatureIndexProvider().isRangeSupported();
                    }
                }
                return false;
            }

            IndexFeatureSet apply() throws FeatureIndexException {
                switch (this.data[0].getType()) {
                    case 1: {
                        return (IndexFeatureSet)this.index.getMatchFeatureSet(((EvaluatorFieldValueMatch)this.data[0]).getValue());
                    }
                    case 2: {
                        EvaluatorFieldValueRange rangeField = (EvaluatorFieldValueRange)this.data[0];
                        return (IndexFeatureSet)this.index.getRangeFeatureSet(rangeField.getValue1(), rangeField.getValue2());
                    }
                    case 3: {
                        EvaluatorFieldValueNearest nearestField = (EvaluatorFieldValueNearest)this.data[0];
                        if (nearestField.getTolerance() == null || !this.isSupported()) {
                            return (IndexFeatureSet)this.index.getNearestFeatureSet(nearestField.getCount(), nearestField.getValue());
                        }
                        return (IndexFeatureSet)this.index.getNearestFeatureSet(nearestField.getCount(), nearestField.getValue(), nearestField.getTolerance());
                    }
                }
                return null;
            }
        }
        ArrayList<ApplyIndex> applyIndexes = new ArrayList<ApplyIndex>();
        Iterator indexes = this.iterator();
        block0: while (indexes.hasNext()) {
            DefaultFeatureIndex index = (DefaultFeatureIndex)((Object)indexes.next());
            if (!index.isValid()) continue;
            String[] attrs = index.getAttributeNames().toArray(new String[0]);
            for (int i = 0; i < attrs.length; ++i) {
                String attrname = attrs[i];
                EvaluatorFieldValue[] values = null;
                if (evaluator.getFieldsInfo() != null) {
                    values = evaluator.getFieldsInfo().getFieldValues(attrname);
                }
                if (!ArrayUtils.isNotEmpty(values)) continue;
                applyIndexes.add(new ApplyIndex(index, values));
                continue block0;
            }
        }
        if (applyIndexes.size() == 0) {
            return null;
        }
        Iterator it = applyIndexes.iterator();
        ApplyIndex index = (ApplyIndex)it.next();
        while (it.hasNext() && !index.isSupported()) {
            index = (ApplyIndex)it.next();
        }
        if (!index.isSupported()) {
            LOG.info("No index support for the evaluator values. Using default index.");
            index = (ApplyIndex)applyIndexes.get(0);
        }
        return index.apply();
    }

    public boolean areValid() {
        Iterator indexes = this.iterator();
        while (indexes.hasNext()) {
            FeatureIndex index = (FeatureIndex)indexes.next();
            if (index.isValid()) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer text = new StringBuffer(super.toString());
        text.append(": [");
        Iterator indexes = this.iterator();
        while (indexes.hasNext()) {
            FeatureIndex index = (FeatureIndex)indexes.next();
            text.append(index);
            text.append("]");
            if (!indexes.hasNext()) continue;
            text.append(", ");
        }
        return text.toString();
    }
}

