/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.feature.impl;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureReference;
import org.gvsig.fmap.dal.feature.FeatureReferenceSelection;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureStoreNotification;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.impl.DefaultFeatureReferenceSelection;
import org.gvsig.fmap.dal.feature.impl.DefaultFeatureStore;
import org.gvsig.fmap.dal.feature.impl.FeatureSelectionHelper;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dispose.impl.AbstractDisposable;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.observer.Observable;
import org.gvsig.tools.observer.Observer;
import org.gvsig.tools.observer.WeakReferencingObservable;
import org.gvsig.tools.observer.impl.DelegateWeakReferencingObservable;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.util.Size64;
import org.gvsig.tools.visitor.Visitor;

public class LargeFeatureReferenceSelection
extends AbstractDisposable
implements FeatureReferenceSelection {
    public static final String DYNCLASS_PERSISTENT_NAME = "LargeFeatureReferenceSelection";
    private Set<String> selection;
    private DefaultFeatureStore featureStore;
    private Boolean available = null;
    private DelegateWeakReferencingObservable delegateObservable = new DelegateWeakReferencingObservable((WeakReferencingObservable)this);

    public LargeFeatureReferenceSelection(DefaultFeatureStore featureStore) {
        this.featureStore = featureStore;
        DisposeUtils.bind((Disposable)this.featureStore);
        this.selection = featureStore.getManager().createLargeSet();
    }

    LargeFeatureReferenceSelection(FeatureStore featureStore, FeatureSelectionHelper helper) {
        this.featureStore = (DefaultFeatureStore)featureStore;
        DisposeUtils.bind((Disposable)this.featureStore);
        this.selection = this.featureStore.getManager().createLargeSet();
    }

    LargeFeatureReferenceSelection() {
    }

    public FeatureStore getFeatureStore() {
        return this.featureStore;
    }

    public boolean select(FeatureReference reference) {
        return this.selection.add(reference.getCode());
    }

    public boolean deselect(FeatureReference reference) {
        boolean change = this.selection.contains(reference.getCode());
        this.selection.remove(reference.getCode());
        if (change) {
            this.notifyObservers("after_SelectionChange_DataStore");
        }
        return change;
    }

    public void selectAll() throws DataException {
        try {
            this.featureStore.accept(obj -> this.selection.add(((Feature)obj).getReference().getCode()));
        }
        catch (BaseException ex) {
            throw new RuntimeException("Can't select all", ex);
        }
    }

    public void deselectAll() throws DataException {
        this.selection.clear();
    }

    public boolean isSelected(FeatureReference reference) {
        return this.selection.contains(reference.getCode());
    }

    public void reverse() {
        try {
            this.featureStore.accept(obj -> {
                String key = ((Feature)obj).getReference().getCode();
                if (this.selection.contains(key)) {
                    this.selection.remove(key);
                } else {
                    this.selection.add(key);
                }
            });
        }
        catch (BaseException ex) {
            throw new RuntimeException("Can't reverse selection", ex);
        }
    }

    public boolean isEmpty() {
        if (this.selection == null) {
            return true;
        }
        return this.getSelectedCount() == 0L;
    }

    public long getSelectedCount() {
        try {
            return ((Size64)this.selection).size64();
        }
        catch (Exception ex) {
            return this.selection.size();
        }
    }

    public Iterator<FeatureReference> referenceIterator() {
        final Iterator<String> it = this.selection.iterator();
        Iterator<FeatureReference> itFeatureReferences = new Iterator<FeatureReference>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public FeatureReference next() {
                String code = (String)it.next();
                FeatureReference fref = LargeFeatureReferenceSelection.this.featureStore.getFeatureReference(code);
                return fref;
            }
        };
        return itFeatureReferences;
    }

    public Iterable<FeatureReference> referenceIterable() {
        return new Iterable<FeatureReference>(){

            @Override
            public Iterator<FeatureReference> iterator() {
                final Iterator it = LargeFeatureReferenceSelection.this.selection.iterator();
                return new Iterator<FeatureReference>(){

                    @Override
                    public boolean hasNext() {
                        return it.hasNext();
                    }

                    @Override
                    public FeatureReference next() {
                        String code = (String)it.next();
                        FeatureReference fref = LargeFeatureReferenceSelection.this.featureStore.getFeatureReference(code);
                        return fref;
                    }
                };
            }
        };
    }

    public boolean isAvailable() {
        if (this.available == null) {
            this.available = false;
            if (this.featureStore != null) {
                try {
                    FeatureType type = this.featureStore.getDefaultFeatureType();
                    this.available = type.supportReferences();
                }
                catch (DataException ex) {
                    this.available = false;
                }
            }
        }
        return this.available;
    }

    public boolean isFromStore(DataStore store) {
        return ((Object)((Object)this.featureStore)).equals(store);
    }

    public void accept(Visitor visitor) throws BaseException {
        for (String string : this.selection) {
            FeatureReference fref = this.featureStore.getFeatureReference(string);
            visitor.visit((Object)fref);
        }
    }

    protected void doDispose() throws BaseException {
        this.delegateObservable.deleteObservers();
        this.deselectAll();
        DisposeUtils.dispose((Disposable)this.featureStore);
        DisposeUtils.dispose(this.selection);
        this.delegateObservable = null;
        this.featureStore = null;
        this.selection = null;
    }

    public void addObserver(Observer observer) {
        this.delegateObservable.addObserver(observer);
    }

    public void beginComplexNotification() {
        this.delegateObservable.beginComplexNotification();
    }

    public void deleteObserver(Observer observer) {
        this.delegateObservable.deleteObserver(observer);
    }

    public void deleteObservers() {
        this.delegateObservable.deleteObservers();
    }

    public void disableNotifications() {
        this.delegateObservable.disableNotifications();
    }

    public void enableNotifications() {
        this.delegateObservable.enableNotifications();
    }

    public void endComplexNotification() {
        this.delegateObservable.notifyObservers((Object)"after_SelectionChange_DataStore");
        this.delegateObservable.endComplexNotification();
    }

    public boolean inComplex() {
        return this.delegateObservable.inComplex();
    }

    public boolean isEnabledNotifications() {
        return this.delegateObservable.isEnabledNotifications();
    }

    public void notifyObservers() {
        if (!this.delegateObservable.inComplex()) {
            this.delegateObservable.notifyObservers();
        }
    }

    public void notifyObservers(Object arg) {
        if (!this.delegateObservable.inComplex()) {
            this.delegateObservable.notifyObservers(arg);
        }
    }

    public void update(Observable observable, Object notification) {
        FeatureStoreNotification storeNotif;
        if (notification instanceof FeatureStoreNotification && "after_Delete_Feature".equalsIgnoreCase((storeNotif = (FeatureStoreNotification)notification).getType())) {
            this.deselect(storeNotif.getFeature().getReference());
        }
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set("store", (Persistent)this.featureStore);
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        this.featureStore = (DefaultFeatureStore)((Object)state.get("store"));
        if (this.selection != null) {
            this.selection.clear();
        } else {
            this.selection = this.featureStore.getManager().createLargeSet();
        }
        Iterator it = state.getIterator("selected");
        while (it != null && it.hasNext()) {
            FeatureReference ref = (FeatureReference)it.next();
            this.select(ref);
        }
        this.addObserver(this.featureStore);
    }

    protected void clearFeatureReferences() {
        if (this.selection == null) {
            return;
        }
        this.selection.clear();
    }

    public List<FeatureType> getFeatureTypes() {
        try {
            return this.featureStore.getFeatureTypes();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void registerPersistent() {
        DynStruct definition = ToolsLocator.getPersistenceManager().addDefinition(DefaultFeatureReferenceSelection.class, DYNCLASS_PERSISTENT_NAME, "LargeFeatureReferenceSelection Persistent definition", null, null);
        definition.addDynFieldObject("store").setClassOfValue(FeatureStore.class).setMandatory(true);
        definition.addDynFieldList("selected").setClassOfItems(FeatureReference.class).setMandatory(false);
    }
}

