/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.feature.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.DataRuntimeException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureReference;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureStoreNotification;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.impl.DefaultFeatureStore;
import org.gvsig.fmap.dal.feature.impl.FeatureSelectionHelper;
import org.gvsig.fmap.dal.feature.impl.LargeFeatureReferenceSelection;
import org.gvsig.fmap.dal.feature.impl.featureset.AbstractFeatureSet;
import org.gvsig.fmap.dal.feature.impl.featureset.DefaultFeatureSet;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposableIterator;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.observer.Observable;
import org.gvsig.tools.observer.Observer;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.visitor.Visitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LargeFeatureSelection
extends AbstractFeatureSet
implements FeatureSelection {
    private static final String DYNCLASS_PERSISTENT_NAME = "LargeFeatureSelection";
    private final Map<Feature, Iterator> featureIterators = new HashMap<Feature, Iterator>();
    private final LargeFeatureReferenceSelection featureReferenceSelection;

    public LargeFeatureSelection(DefaultFeatureStore featureStore) throws DataException {
        this.featureReferenceSelection = new LargeFeatureReferenceSelection(featureStore);
    }

    public LargeFeatureSelection(FeatureStore featureStore, FeatureSelectionHelper helper) throws DataException {
        this.featureReferenceSelection = new LargeFeatureReferenceSelection(featureStore, helper);
    }

    public LargeFeatureSelection() {
        this.featureReferenceSelection = new LargeFeatureReferenceSelection();
    }

    @Override
    public FeatureStore getFeatureStore() {
        return this.featureReferenceSelection.getFeatureStore();
    }

    private void notifyObservers(String notificationType) {
        this.featureReferenceSelection.notifyObservers(notificationType);
    }

    public void enableNotifications() {
        this.featureReferenceSelection.enableNotifications();
    }

    public void disableNotifications() {
        this.featureReferenceSelection.disableNotifications();
    }

    public long getSelectedCount() {
        return this.featureReferenceSelection.getSelectedCount();
    }

    public boolean select(FeatureReference reference) {
        return this.featureReferenceSelection.select(reference);
    }

    public boolean deselect(FeatureReference reference) {
        return this.featureReferenceSelection.deselect(reference);
    }

    public Iterator<FeatureReference> referenceIterator() {
        return this.featureReferenceSelection.referenceIterator();
    }

    public Iterable<FeatureReference> referenceIterable() {
        return this.featureReferenceSelection.referenceIterable();
    }

    public void selectAll() throws DataException {
        this.featureReferenceSelection.selectAll();
    }

    public void deselectAll() throws DataException {
        this.featureReferenceSelection.deselectAll();
    }

    public boolean isSelected(FeatureReference reference) {
        return this.featureReferenceSelection.isSelected(reference);
    }

    public void reverse() {
        this.featureReferenceSelection.reverse();
    }

    public void dispose() {
        this.featureReferenceSelection.dispose();
    }

    public void update(Observable o, Object o1) {
        this.featureReferenceSelection.update(o, o1);
    }

    public void addObserver(Observer obsrvr) {
        this.featureReferenceSelection.addObserver(obsrvr);
    }

    public void deleteObserver(Observer obsrvr) {
        this.featureReferenceSelection.deleteObserver(obsrvr);
    }

    public void deleteObservers() {
        this.featureReferenceSelection.deleteObservers();
    }

    public void beginComplexNotification() {
        this.featureReferenceSelection.beginComplexNotification();
    }

    public void endComplexNotification() {
        this.featureReferenceSelection.endComplexNotification();
    }

    public void saveToState(PersistentState ps) throws PersistenceException {
        this.featureReferenceSelection.saveToState(ps);
    }

    public boolean select(Feature feature) {
        return this.featureReferenceSelection.select(feature.getReference());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean select(FeatureSet features) throws DataException {
        boolean change = false;
        boolean inComplex = false;
        this.disableNotifications();
        DisposableIterator iter = null;
        try {
            iter = features.fastIterator();
            while (iter.hasNext()) {
                change |= this.featureReferenceSelection.select(((Feature)iter.next()).getReference());
            }
        }
        finally {
            DisposeUtils.disposeQuietly((Disposable)iter);
        }
        this.enableNotifications();
        return change;
    }

    public boolean deselect(Feature feature) {
        return this.featureReferenceSelection.deselect(feature.getReference());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deselect(FeatureSet features) throws DataException {
        boolean change = false;
        this.disableNotifications();
        DisposableIterator iter = null;
        try {
            iter = features.fastIterator();
            while (iter.hasNext()) {
                change |= this.deselect((Feature)iter.next());
            }
        }
        finally {
            DisposeUtils.disposeQuietly((Disposable)iter);
        }
        this.enableNotifications();
        return change;
    }

    public boolean isSelected(Feature feature) {
        if (feature == null) {
            return false;
        }
        if (this.featureReferenceSelection.isEmpty()) {
            return false;
        }
        return this.featureReferenceSelection.isSelected(feature.getReference());
    }

    public FeatureType getDefaultFeatureType() {
        try {
            return this.getFeatureStore().getDefaultFeatureType();
        }
        catch (DataException ex) {
            LOG.error("Error getting the default feature type of the FeatureStore: " + this.getFeatureStore(), (Throwable)ex);
            return null;
        }
    }

    public List getFeatureTypes() {
        return this.featureReferenceSelection.getFeatureTypes();
    }

    public long getSize() throws DataException {
        return this.getSelectedCount();
    }

    public DisposableIterator iterator(long index) {
        return this.iterator(index, 0L, false);
    }

    public DisposableIterator iterator(long index, long elements) {
        return this.iterator(index, elements, false);
    }

    public DisposableIterator fastIterator(long index) {
        return this.fastIterator(index, 0L);
    }

    public DisposableIterator fastIterator(long index, long elements) {
        return this.iterator(index, elements, true);
    }

    protected void clearFeatureReferences() {
        this.featureReferenceSelection.clearFeatureReferences();
    }

    private DisposableIterator iterator(long index, long elements, boolean fastIterator) {
        Iterator<FeatureReference> iter = this.featureReferenceSelection.referenceIterator();
        for (long l = 0L; l < index && iter.hasNext(); ++l) {
            iter.next();
        }
        return new FeatureIteratorFacade(iter, this.getFeatureStore());
    }

    public void delete(Feature feature) throws DataException {
        Iterator it = this.featureIterators.get(feature);
        if (it != null) {
            it.remove();
            return;
        }
        feature.getStore().delete(feature);
    }

    public void insert(EditableFeature feature) throws DataException {
        feature.getStore().insert(feature);
    }

    public void update(EditableFeature feature) throws DataException {
        feature.getStore().update(feature);
    }

    public void commitChanges() throws DataException {
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        this.featureReferenceSelection.loadFromState(state);
    }

    protected void doDispose() throws BaseException {
        this.featureReferenceSelection.doDispose();
    }

    public static void registerPersistent() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        DynStruct definition = manager.addDefinition(LargeFeatureSelection.class, DYNCLASS_PERSISTENT_NAME, "LargeFeatureSelection Persistent definition", null, null);
        definition.extend(manager.getDefinition("LargeFeatureReferenceSelection"));
    }

    public Object clone() throws CloneNotSupportedException {
        LargeFeatureSelection clone = (LargeFeatureSelection)((Object)super.clone());
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doAccept(Visitor visitor, long firstValueIndex, long elements) throws BaseException {
        if (this.featureReferenceSelection.isEmpty()) {
            return;
        }
        DisposableIterator iterator = this.fastIterator(firstValueIndex, elements);
        if (iterator != null) {
            try {
                while (iterator.hasNext()) {
                    Feature feature = (Feature)iterator.next();
                    visitor.visit((Object)feature);
                }
            }
            finally {
                iterator.dispose();
            }
        }
    }

    public boolean isAvailable() {
        return this.featureReferenceSelection.isAvailable();
    }

    private static class IgnoreInsertAndUpdateFeatureSet
    extends DefaultFeatureSet {
        public IgnoreInsertAndUpdateFeatureSet(DefaultFeatureStore store, FeatureQuery query) throws DataException {
            super(store, query);
        }

        @Override
        public void update(Observable obsevable, Object notification) {
            String type = ((FeatureStoreNotification)notification).getType();
            if (type.equalsIgnoreCase("after_Insert_Feature") || type.equalsIgnoreCase("after_Update_Feature")) {
                return;
            }
            super.update(obsevable, notification);
        }
    }

    private class FeatureIteratorFacade
    implements DisposableIterator {
        private final Logger LOGGER = LoggerFactory.getLogger(FeatureIteratorFacade.class);
        private Iterator refIterator;
        private FeatureStore featureStore;
        private Feature currentFeature = null;

        public FeatureIteratorFacade(Iterator iter, FeatureStore featureStore) {
            this.refIterator = iter;
            this.featureStore = featureStore;
        }

        public boolean hasNext() {
            return this.refIterator.hasNext();
        }

        public Object next() {
            FeatureReference ref = this.nextFeatureReference();
            try {
                this.currentFeature = this.featureStore.getFeatureByReference(ref);
                return this.currentFeature;
            }
            catch (DataException ex) {
                this.LOGGER.error("Error loading the Feature with FeatureReference: " + ref, (Throwable)ex);
                return null;
            }
        }

        public FeatureReference nextFeatureReference() {
            return (FeatureReference)this.refIterator.next();
        }

        public void remove() {
            try {
                this.featureStore.delete(this.currentFeature);
                this.refIterator.remove();
            }
            catch (DataException e) {
                throw new RemoveFromFeatureSelectionException(e);
            }
        }

        public void dispose() {
            if (this.refIterator instanceof DisposableIterator) {
                ((DisposableIterator)this.refIterator).dispose();
            }
            this.refIterator = null;
            this.featureStore = null;
        }

        public class RemoveFromFeatureSelectionException
        extends DataRuntimeException {
            private static final long serialVersionUID = 2636692469445838928L;
            private static final String MESSAGE_FORMAT = "Can't remove feature from selection.";
            private static final String MESSAGE_KEY = "_RemoveFromFeatureSelectionException";

            public RemoveFromFeatureSelectionException(Throwable cause) {
                super(MESSAGE_FORMAT, cause, MESSAGE_KEY, 2636692469445838928L);
            }
        }
    }

    public class RemoveFromFeatureSelectionException
    extends DataRuntimeException {
        private static final long serialVersionUID = 2636692469445838928L;
        private static final String MESSAGE_FORMAT = "Can't remove feature from reversed selection.";
        private static final String MESSAGE_KEY = "_RemoveFromFeatureSelectionException";

        public RemoveFromFeatureSelectionException(Throwable cause) {
            super(MESSAGE_FORMAT, cause, MESSAGE_KEY, 2636692469445838928L);
        }
    }
}

