/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.feature.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.queue.CircularFifoQueue;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;

public class RecentUsedsAttributesImpl {
    private final Map<String, CircularFifoQueue<String>> recentsForStore = new HashMap<String, CircularFifoQueue<String>>();

    public Collection<String> getNames(FeatureType featureType) {
        FeatureStore store = featureType.getStore();
        if (store == null) {
            return Collections.EMPTY_LIST;
        }
        CircularFifoQueue<String> recents = this.recentsForStore.get(store.getFullName());
        if (recents == null) {
            return Collections.EMPTY_LIST;
        }
        return recents;
    }

    public List<FeatureAttributeDescriptor> getAttributes(FeatureType featureType) {
        ArrayList<FeatureAttributeDescriptor> r = new ArrayList<FeatureAttributeDescriptor>();
        for (String name : this.getNames(featureType)) {
            FeatureAttributeDescriptor attrRecendUsed = featureType.getAttributeDescriptor(name);
            if (attrRecendUsed == null) continue;
            r.add(attrRecendUsed);
        }
        return r;
    }

    public void add(FeatureAttributeDescriptor attribute) {
        this.add(attribute.getFeatureType(), attribute.getName());
    }

    public void add(FeatureType featureType, FeatureAttributeDescriptor attribute) {
        this.add(featureType, attribute.getName());
    }

    public void add(FeatureType featureType, String name) {
        String storeFullName = featureType.getStore().getFullName();
        CircularFifoQueue recents = this.recentsForStore.get(storeFullName);
        if (recents == null) {
            recents = new CircularFifoQueue(this.getMaxSize());
            this.recentsForStore.put(storeFullName, (CircularFifoQueue<String>)recents);
        }
        recents.remove((Object)name);
        recents.add((Object)name);
    }

    public int getMaxSize() {
        return 6;
    }
}

