/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.feature.impl.editing.memory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureReference;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.impl.DefaultFeature;
import org.gvsig.fmap.dal.feature.impl.DefaultFeatureRules;
import org.gvsig.fmap.dal.feature.impl.editing.memory.ExpansionAdapter;
import org.gvsig.fmap.dal.feature.impl.editing.memory.MemoryExpansionAdapter;
import org.gvsig.fmap.dal.feature.impl.featurereference.FeatureReferenceFactory;
import org.gvsig.fmap.dal.feature.spi.FeatureProvider;
import org.gvsig.tools.util.Rewind;
import org.gvsig.tools.util.Size;

public class FeatureManager {
    private int deltaSize = 0;
    private final ExpansionAdapter expansionAdapter = new MemoryExpansionAdapter();
    private final Collection<FeatureReference> deleted = new LinkedHashSet<FeatureReference>();
    private final Map<FeatureReference, Integer> added = new LinkedHashMap<FeatureReference, Integer>();
    private final Map<FeatureReference, Integer> addedAndDeleted = new LinkedHashMap<FeatureReference, Integer>();
    private final Map<FeatureReference, Integer> modifiedFromOriginal = new HashMap<FeatureReference, Integer>();
    private final Map<FeatureReference, Integer> original = new HashMap<FeatureReference, Integer>();
    private final FeatureStore store;

    public FeatureManager(FeatureStore store) {
        this.store = store;
    }

    public Feature delete(Feature feature) {
        FeatureReference id = feature.getReference();
        if (!this.original.containsKey(id)) {
            int n = this.expansionAdapter.addObject(this.getCopy(feature));
            this.original.put(id, n);
        }
        this.deleted.add(id);
        Integer num = this.added.remove(id);
        Feature previousFeature = null;
        if (num == null || num == -1) {
            num = this.modifiedFromOriginal.remove(id);
            if (num != null) {
                previousFeature = (Feature)this.expansionAdapter.getObject(num);
            }
        } else {
            previousFeature = (Feature)this.expansionAdapter.getObject(num);
            this.addedAndDeleted.put(id, num);
        }
        --this.deltaSize;
        return previousFeature;
    }

    public void add(EditableFeature feature) {
        FeatureReference id = feature.getReference();
        if (!this.original.containsKey(id)) {
            this.original.put(id, null);
        }
        int pos = this.expansionAdapter.addObject(this.getCopy((Feature)feature));
        this.added.put(feature.getReference(), pos);
        this.deleted.remove(feature.getReference());
        ++this.deltaSize;
    }

    public void undoAdd(EditableFeature feature) {
        FeatureReference id = feature.getReference();
        if (this.added.remove(id) != null) {
            --this.deltaSize;
        }
    }

    public Feature deleteLastFeature() {
        this.expansionAdapter.deleteLastObject();
        Feature feature = (Feature)this.expansionAdapter.getObject(this.expansionAdapter.getSize() - 1);
        this.added.remove(feature.getReference());
        this.modifiedFromOriginal.remove(feature.getReference());
        --this.deltaSize;
        return feature;
    }

    public DefaultFeature get(FeatureProvider data) {
        FeatureReference ref = FeatureReferenceFactory.createFromFeatureProvider(this.store, data);
        try {
            return this.get(ref, this.store);
        }
        catch (DataException ex) {
            return null;
        }
    }

    public DefaultFeature get(FeatureReference id, FeatureStore store) throws DataException {
        return this.get(id, store, null);
    }

    public DefaultFeature get(FeatureReference id, FeatureStore store, FeatureType featureType) throws DataException {
        int num;
        boolean isNewFeature = false;
        Integer intNum = this.added.get(id);
        if (intNum == null) {
            intNum = this.modifiedFromOriginal.get(id);
            if (intNum == null && (intNum = this.addedAndDeleted.get(id)) == null) {
                return null;
            }
        } else {
            isNewFeature = true;
        }
        if ((num = intNum.intValue()) == -1) {
            return null;
        }
        Feature feature = (Feature)this.expansionAdapter.getObject(num);
        if (featureType == null) {
            featureType = store.getDefaultFeatureType();
        }
        DefaultFeature feat = new DefaultFeature(featureType, feature);
        feat.getData().setNew(isNewFeature);
        return feat;
    }

    private Feature getCopy(Feature f) {
        if (f == null) {
            return null;
        }
        return f.getCopy();
    }

    public int update(EditableFeature feature, Feature oldFeature) {
        FeatureReference id = feature.getReference();
        if (id == null) {
            throw new IllegalArgumentException("Can't update feature without references support.");
        }
        if (!this.original.containsKey(id)) {
            int n = this.expansionAdapter.addObject(this.getCopy(oldFeature));
            this.original.put(id, n);
        }
        int oldNum = -1;
        int num = this.expansionAdapter.addObject(this.getCopy((Feature)feature));
        if (this.added.containsKey(id)) {
            oldNum = this.added.get(id);
            this.added.put(id, num);
        } else {
            if (this.modifiedFromOriginal.get(id) != null) {
                oldNum = this.modifiedFromOriginal.get(id);
            }
            this.modifiedFromOriginal.put(id, num);
        }
        return oldNum;
    }

    public void restore(FeatureReference id) {
        this.deleted.remove(id);
        ++this.deltaSize;
    }

    public void restore(FeatureReference id, int num) {
        if (this.added.containsKey(id)) {
            this.added.put(id, num);
        } else {
            this.modifiedFromOriginal.put(id, num);
        }
    }

    public boolean isDeleted(Feature feature) {
        return this.deleted.contains(feature.getReference());
    }

    public boolean isDeleted(FeatureProvider data) {
        FeatureReference ref = FeatureReferenceFactory.createFromFeatureProvider(this.store, data);
        return this.deleted.contains(ref);
    }

    public boolean isDeleted(FeatureReference featureID) {
        return this.deleted.contains(featureID);
    }

    public void clear() {
        this.added.clear();
        this.modifiedFromOriginal.clear();
        this.expansionAdapter.close();
        this.deleted.clear();
        this.addedAndDeleted.clear();
        this.deltaSize = 0;
    }

    public boolean hasChanges() {
        return this.added.size() > 0 || this.modifiedFromOriginal.size() > 0 || this.deleted.size() > 0;
    }

    public boolean hasDeleteds() {
        return this.deleted.size() > 0;
    }

    public int getDeletedCount() {
        return this.deleted.size();
    }

    public long getPendingChangesCount() {
        long count = 0L;
        if (this.added != null) {
            count += (long)this.added.size();
        }
        if (this.deleted != null) {
            count += (long)this.deleted.size();
        }
        if (this.modifiedFromOriginal != null) {
            count += (long)this.modifiedFromOriginal.size();
        }
        return count;
    }

    public Iterator<FeatureReference> getDeleted() {
        return new DeletedsFeatureReferencesIterator();
    }

    public Iterator<FeatureProvider> getInserted() {
        final InsertedFeaturesIterator it = new InsertedFeaturesIterator();
        return new Iterator<FeatureProvider>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public FeatureProvider next() {
                return ((DefaultFeature)it.next()).getData();
            }
        };
    }

    public Iterator<EditableFeature> getInsertedFeatures() {
        return new InsertedFeaturesIterator();
    }

    public List<FeatureReference> getAddedAndUpdatedFeatures() {
        ArrayList<FeatureReference> references = new ArrayList<FeatureReference>();
        references.addAll(this.modifiedFromOriginal.keySet());
        references.addAll(this.added.keySet());
        return references;
    }

    public List<FeatureReference> getAddedAndUpdatedFeaturesNotValidated(DefaultFeatureRules rules, int checks) {
        EditableFeature feature;
        Integer index;
        ArrayList<FeatureReference> references = new ArrayList<FeatureReference>();
        for (FeatureReference ref : this.modifiedFromOriginal.keySet()) {
            index = this.modifiedFromOriginal.get(ref);
            if (index == null) continue;
            feature = (EditableFeature)this.expansionAdapter.getObject(index);
            try {
                rules.validate(feature, checks);
            }
            catch (DataException ex) {
                references.add(ref);
            }
        }
        for (FeatureReference ref : this.added.keySet()) {
            index = this.added.get(ref);
            if (index == null) continue;
            feature = (EditableFeature)this.expansionAdapter.getObject(index);
            try {
                rules.validate(feature, checks);
            }
            catch (Exception ex) {
                references.add(ref);
            }
        }
        return references;
    }

    public Iterator<EditableFeature> getUpdatedFeatures() {
        return new UpdatedFeaturesIterator();
    }

    public Iterator<FeatureProvider> getUpdated() {
        final UpdatedFeaturesIterator it = new UpdatedFeaturesIterator();
        return new Iterator<FeatureProvider>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public FeatureProvider next() {
                return ((DefaultFeature)it.next()).getData();
            }
        };
    }

    public boolean hasNews() {
        return !this.added.isEmpty();
    }

    public long getDeltaSize() {
        return this.deltaSize;
    }

    public boolean isSelectionCompromised() {
        return !this.deleted.isEmpty() || !this.added.isEmpty();
    }

    public Feature getOriginal(FeatureReference id) {
        Integer n = this.original.get(id);
        if (n == null) {
            return null;
        }
        return (Feature)this.expansionAdapter.getObject(n);
    }

    public boolean isFeatureModified(FeatureReference id) {
        return this.original.containsKey(id);
    }

    private class UpdatedFeaturesIterator
    implements Iterator<EditableFeature>,
    Size,
    Rewind {
        private Boolean hasnext = null;
        private Iterator iter;
        private EditableFeature feature;
        private int pos;

        public UpdatedFeaturesIterator() {
            this.iter = FeatureManager.this.expansionAdapter.iterator();
            this.pos = -1;
        }

        @Override
        public boolean hasNext() {
            if (this.hasnext != null) {
                return this.hasnext;
            }
            this.hasnext = false;
            while (this.iter.hasNext()) {
                ++this.pos;
                Feature f = (Feature)this.iter.next();
                if (f == null || FeatureManager.this.deleted.contains(f.getReference()) || !FeatureManager.this.modifiedFromOriginal.containsValue(this.pos)) continue;
                this.hasnext = true;
                this.feature = (EditableFeature)f;
                break;
            }
            return this.hasnext;
        }

        @Override
        public EditableFeature next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.hasnext = null;
            return this.feature;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public int size() {
            return FeatureManager.this.expansionAdapter.getSize();
        }

        public void rewind() {
            this.iter = FeatureManager.this.expansionAdapter.iterator();
            this.pos = -1;
            this.hasnext = null;
        }
    }

    private class InsertedFeaturesIterator
    implements Iterator<EditableFeature>,
    Size,
    Rewind {
        private Iterator addedIter;
        private EditableFeature feature;
        private Boolean hasnext = null;

        public InsertedFeaturesIterator() {
            this.addedIter = FeatureManager.this.added.values().iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.hasnext != null) {
                return this.hasnext;
            }
            this.hasnext = false;
            while (this.addedIter.hasNext()) {
                int pos = (Integer)this.addedIter.next();
                this.feature = (EditableFeature)FeatureManager.this.expansionAdapter.getObject(pos);
                if (FeatureManager.this.deleted.contains(this.feature.getReference())) continue;
                this.hasnext = true;
                break;
            }
            return this.hasnext;
        }

        @Override
        public EditableFeature next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.hasnext = null;
            return this.feature;
        }

        @Override
        public void remove() {
            this.addedIter.remove();
        }

        public int size() {
            return FeatureManager.this.added.size();
        }

        public void rewind() {
            this.addedIter = FeatureManager.this.added.values().iterator();
            this.hasnext = null;
        }
    }

    private class DeletedsFeatureReferencesIterator
    implements Iterator<FeatureReference> {
        private Boolean hasnext = null;
        private final Iterator iter;
        private FeatureReference reference;

        public DeletedsFeatureReferencesIterator() {
            this.iter = FeatureManager.this.deleted.iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.hasnext != null) {
                return this.hasnext;
            }
            this.hasnext = false;
            while (this.iter.hasNext()) {
                this.reference = (FeatureReference)this.iter.next();
                if (this.reference.isNewFeature()) continue;
                this.hasnext = true;
                break;
            }
            return this.hasnext;
        }

        @Override
        public FeatureReference next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.hasnext = null;
            return this.reference;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

