/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.feature.impl.featurereference;

import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureReference;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.impl.DefaultFeature;
import org.gvsig.fmap.dal.feature.impl.DefaultFeatureStore;
import org.gvsig.fmap.dal.feature.spi.FeatureProvider;
import org.gvsig.fmap.dal.feature.spi.FeatureReferenceProviderServices;
import org.gvsig.json.JsonObjectBuilder;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.json.JSONArray;
import org.json.JSONObject;

@Deprecated
public class DefaultFeatureReference
implements FeatureReferenceProviderServices,
Persistent {
    private Object oid;
    private Integer myHashCode = null;
    private Object[] pk;
    private String[] pkNames;
    private WeakReference storeRef;
    private boolean isNewFeature;
    private String featureTypeId;
    private static final int OID_INDEX = 0;
    private static final int MYHASHCODE_INDEX = 1;
    private static final int ISNEWFEATURE_INDEX = 2;
    private static final int FEATURETYPEID_INDEX = 3;
    private static final int PKNAMES_SIZE_INDEX = 4;
    private static final int PKNAMES_INDEX = 5;
    private static final int PK_INDEX = 6;

    public DefaultFeatureReference() {
    }

    public DefaultFeatureReference(DefaultFeature feature) {
        this(feature.getStore(), feature.getData());
    }

    public DefaultFeatureReference(FeatureStore store, FeatureProvider fdata) {
        this.isNewFeature = fdata.isNew();
        this.oid = null;
        this.pk = null;
        this.storeRef = new WeakReference<FeatureStore>(store);
        this.featureTypeId = fdata.getType().getId();
        if (fdata.getType().hasOID() || this.isNewFeature) {
            this.oid = fdata.getOID();
            if (this.oid == null) {
                throw new RuntimeException("Missing OID");
            }
        } else {
            this.calculatePK(fdata);
            if (this.pk == null) {
                throw new RuntimeException("Missing pk attributes");
            }
        }
    }

    public DefaultFeatureReference(FeatureStore store, Object oid) {
        this.isNewFeature = false;
        this.oid = oid;
        this.pk = null;
        this.storeRef = new WeakReference<FeatureStore>(store);
    }

    public DefaultFeatureReference(FeatureStore store, String code) {
        this.storeRef = new WeakReference<FeatureStore>(store);
        String json = new String(Base64.getDecoder().decode(code.getBytes()));
        JSONArray x = new JSONArray(json);
        this.oid = x.get(0);
        this.myHashCode = x.get(1) == JSONObject.NULL ? null : Integer.valueOf(x.getInt(1));
        this.isNewFeature = x.getBoolean(2);
        this.featureTypeId = x.getString(3);
        int pkNames_size = x.getInt(4);
        if (pkNames_size < 0) {
            this.pk = null;
            this.pkNames = null;
        } else {
            int i;
            this.pk = new Object[pkNames_size];
            this.pkNames = new String[pkNames_size];
            JSONArray xx = x.getJSONArray(5);
            for (i = 0; i < xx.length(); ++i) {
                this.pkNames[i] = xx.getString(i);
            }
            xx = x.getJSONArray(5);
            for (i = 0; i < xx.length(); ++i) {
                this.pk[i] = xx.get(i);
            }
        }
    }

    private DefaultFeatureStore getStore() {
        return (DefaultFeatureStore)((Object)this.storeRef.get());
    }

    public void calculatePK(FeatureProvider fdata) {
        Object[] pkattrs = fdata.getType().getPrimaryKey();
        if (ArrayUtils.isEmpty((Object[])pkattrs)) {
            this.pk = null;
            this.pkNames = null;
            return;
        }
        this.pk = new Object[pkattrs.length];
        this.pkNames = new String[pkattrs.length];
        int n = 0;
        for (Object pkattr : pkattrs) {
            this.pk[n] = fdata.get(pkattr.getIndex());
            this.pkNames[n] = pkattr.getName();
            ++n;
        }
    }

    public Feature getFeature() throws DataException {
        return this.getStore().getFeatureByReference((FeatureReference)this);
    }

    public Feature getFeatureQuietly() {
        try {
            return this.getFeature();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public Feature getFeature(FeatureType featureType) throws DataException {
        return this.getStore().getFeatureByReference((FeatureReference)this, featureType);
    }

    public Object getOID() {
        return this.oid;
    }

    public boolean isNewFeature() {
        return this.isNewFeature;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DefaultFeatureReference)) {
            return false;
        }
        DefaultFeatureReference other = (DefaultFeatureReference)obj;
        FeatureStore otherStore = (FeatureStore)other.storeRef.get();
        FeatureStore myrStore = (FeatureStore)this.storeRef.get();
        if (otherStore == null || myrStore == null) {
            return false;
        }
        if (!myrStore.equals(otherStore)) {
            return false;
        }
        if (this.myHashCode != null && other.myHashCode != null) {
            return this.myHashCode.equals(other.myHashCode);
        }
        if (this.oid != null) {
            return this.oid.equals(other.oid);
        }
        if (this.pk != null) {
            if (other.pk == null) {
                return false;
            }
            for (int i = 0; i < this.pk.length; ++i) {
                if (this.pk[i].equals(other.pk[i])) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        if (this.oid != null) {
            return this.oid.hashCode();
        }
        if (this.myHashCode == null) {
            StringBuilder buff = new StringBuilder();
            for (int i = 0; i < this.pk.length; ++i) {
                buff.append(Objects.hashCode(this.pk[i]));
                buff.append("##");
            }
            this.myHashCode = buff.toString().hashCode();
        }
        return this.myHashCode;
    }

    public String[] getKeyNames() {
        return this.pkNames;
    }

    public Object getKeyValue(String name) {
        for (int i = 0; i < this.pkNames.length; ++i) {
            if (!this.pkNames[i].equalsIgnoreCase(name)) continue;
            return this.pk[i];
        }
        return null;
    }

    public String getFeatureTypeId() {
        return this.featureTypeId;
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        this.oid = state.get("oid");
        this.myHashCode = (Integer)state.get("myHashCode");
        this.storeRef = new WeakReference<Object>(state.get("store"));
        this.isNewFeature = state.getBoolean("isNewFeature");
        this.featureTypeId = state.getString("featureTypeId");
        List pkList = (List)state.get("pk");
        if (pkList != null) {
            List pkNamesList = (List)state.get("pkNames");
            if (pkNamesList == null || pkList.size() != pkNamesList.size()) {
                throw new PersistenceException("bad pkNames value");
            }
            this.pk = pkList.toArray();
            this.pkNames = pkNamesList.toArray(new String[pkList.size()]);
        } else {
            this.pk = null;
            this.pkNames = null;
        }
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set("oid", this.oid);
        state.set("myHashCode", this.myHashCode);
        state.set("isNewFeature", this.isNewFeature);
        state.set("store", (Persistent)this.storeRef.get());
        state.set("featureTypeId", this.featureTypeId);
        if (this.pk == null) {
            state.setNull("pk");
            state.setNull("pkNames");
        } else {
            state.set("pk", this.pk);
            state.set("pkNames", this.pkNames);
        }
    }

    public String getCode() {
        Object[] data = new Object[7];
        data[0] = this.oid;
        data[1] = this.myHashCode;
        data[2] = this.isNewFeature;
        data[3] = this.featureTypeId;
        if (this.pk == null) {
            data[4] = -1;
            data[5] = JSONObject.NULL;
            data[6] = JSONObject.NULL;
        } else {
            data[4] = this.pkNames.length;
            data[5] = new JSONArray((Object)this.pkNames);
            data[6] = new JSONArray((Object)this.pk);
        }
        String s = new JSONArray((Object)data).toString();
        String r = Base64.getEncoder().encodeToString(s.getBytes());
        return r;
    }

    public static void registerPersistent() {
        DynStruct definition = ToolsLocator.getPersistenceManager().addDefinition(DefaultFeatureReference.class, "Reference", "DefaultFeatureReference Persistent definition", null, null);
        definition.addDynFieldObject("oid").setClassOfValue(Object.class).setMandatory(false).setPersistent(true);
        definition.addDynFieldBoolean("isNewFeature").setMandatory(true).setPersistent(true);
        definition.addDynFieldObject("store").setClassOfValue(FeatureStore.class).setMandatory(true).setPersistent(true);
        definition.addDynFieldInt("myHashCode").setMandatory(false).setPersistent(true);
        definition.addDynFieldString("featureTypeId").setMandatory(true).setPersistent(true);
        definition.addDynFieldArray("pk").setClassOfItems(Object.class).setMandatory(false).setPersistent(true);
        definition.addDynFieldArray("pkNames").setClassOfItems(String.class).setMandatory(false).setPersistent(true);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("FeatureReference: oid = ");
        builder.append(this.oid);
        if (this.myHashCode != null) {
            builder.append(", myHashCode = ");
            builder.append(this.myHashCode);
        }
        if (this.pk != null) {
            builder.append(", pks = ");
            builder.append(Arrays.asList(this.pk));
        }
        if (this.pkNames != null) {
            builder.append(", pkNames = ");
            builder.append(Arrays.asList(this.pkNames));
        }
        if (this.isNewFeature) {
            builder.append(", isNew = ");
            builder.append(this.isNewFeature);
        }
        if (this.featureTypeId != null) {
            builder.append(", featureTypeId = ");
            builder.append(this.featureTypeId);
        }
        return builder.toString();
    }

    public JsonObjectBuilder toJsonBuilder() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

