/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.feature.impl.featurereference;

import org.gvsig.fmap.dal.feature.FeatureReference;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.impl.featurereference.FeatureReferenceCounter;
import org.gvsig.fmap.dal.feature.impl.featurereference.FeatureReferenceOID;
import org.gvsig.fmap.dal.feature.impl.featurereference.FeatureReferencePK;
import org.gvsig.fmap.dal.feature.impl.featurereference.FeatureReferenceUID;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.AbstractSinglePersistenceFactory;
import org.gvsig.tools.persistence.PersistenceFactory;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;

public class FeatureReferencePersistenceFactory
extends AbstractSinglePersistenceFactory {
    private static final String DYNCLASS_NAME = "Reference";
    private static final String DYNCLASS_DESCRIPTION = "DefaultFeatureReference Persistent definition";

    public FeatureReferencePersistenceFactory() {
        super(FeatureReference.class, DYNCLASS_NAME, DYNCLASS_DESCRIPTION, null, null);
        DynStruct definition = this.getDefinition();
        definition.addDynFieldObject("oid").setClassOfValue(Object.class).setMandatory(false).setPersistent(true);
        definition.addDynFieldString("type").setPersistent(true);
        definition.addDynFieldBoolean("isNewFeature").setMandatory(true).setPersistent(true);
        definition.addDynFieldObject("store").setClassOfValue(FeatureStore.class).setMandatory(true).setPersistent(true);
        definition.addDynFieldInt("myHashCode").setMandatory(false).setPersistent(true);
        definition.addDynFieldString("featureTypeId").setMandatory(true).setPersistent(true);
        definition.addDynFieldArray("pk").setClassOfItems(Object.class).setMandatory(false).setPersistent(true);
        definition.addDynFieldArray("pkNames").setClassOfItems(String.class).setMandatory(false).setPersistent(true);
    }

    public Object createFromState(PersistentState state) throws PersistenceException {
        Object ref;
        String type;
        switch (type = state.getString("type")) {
            case "oid": {
                ref = new FeatureReferenceOID();
                break;
            }
            case "counter": {
                ref = new FeatureReferenceCounter();
                break;
            }
            case "uid": {
                ref = new FeatureReferenceUID();
                break;
            }
            case "pk": {
                ref = new FeatureReferencePK();
                break;
            }
            default: {
                Object pk = state.get("pk");
                ref = pk == null ? new FeatureReferenceOID() : new FeatureReferencePK();
            }
        }
        ref.loadFromState(state);
        return ref;
    }

    public void saveToState(PersistentState state, Object obj) throws PersistenceException {
        ((Persistent)obj).saveToState(state);
    }

    public static void selfRegister() {
        PersistenceManager persistenceManager = ToolsLocator.getPersistenceManager();
        persistenceManager.registerFactory((PersistenceFactory)new FeatureReferencePersistenceFactory());
    }

    public Class getManagedClass(Object object) {
        return super.getManagedClass(object);
    }
}

