/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.feature.impl.featureset;

import java.util.Iterator;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonValue;
import org.apache.commons.lang3.mutable.MutableInt;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.DisposableFeatureSetIterable;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.impl.DefaultFeature;
import org.gvsig.fmap.dal.feature.impl.dynobjectutils.DynObjectSetFeatureSetFacade;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposableIterator;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dynobject.DynObjectSet;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.visitor.VisitCanceledException;
import org.gvsig.tools.visitor.Visitor;
import org.gvsig.tools.visitor.impl.AbstractIndexedVisitable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFeatureSet
extends AbstractIndexedVisitable
implements FeatureSet {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractFeatureSet.class);
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractFeatureSet.class);

    public abstract FeatureStore getFeatureStore();

    public final void accept(Visitor visitor, long firstValueIndex, long elements) throws BaseException {
        try {
            this.doAccept(visitor, firstValueIndex, elements);
        }
        catch (VisitCanceledException ex) {
            LOG.debug("The visit, beggining on position {}, has been cancelled by the visitor: {}", (Object)firstValueIndex, (Object)visitor);
        }
    }

    protected void doAccept(Visitor visitor, long firstValueIndex) throws VisitCanceledException, BaseException {
        this.doAccept(visitor, firstValueIndex, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doAccept(Visitor visitor, long firstValueIndex, long elements) throws VisitCanceledException, BaseException {
        DisposableIterator iterator = this.fastIterator(firstValueIndex, elements);
        try {
            while (iterator.hasNext()) {
                Feature feature = (Feature)iterator.next();
                visitor.visit((Object)feature);
            }
        }
        finally {
            iterator.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Feature first() {
        DisposableIterator it = null;
        try {
            it = this.iterator();
            if (it == null) {
                Feature feature = null;
                return feature;
            }
            if (it.hasNext()) {
                Feature f;
                Feature feature = f = (Feature)it.next();
                return feature;
            }
            Feature feature = null;
            return feature;
        }
        finally {
            DisposeUtils.disposeQuietly((Disposable)it);
        }
    }

    public boolean isEmpty() {
        return this.size64() == 0L;
    }

    public DisposableIterator fastIterator() throws DataException {
        return this.fastIterator(0L);
    }

    public DisposableIterator iterator() {
        try {
            return this.fastIterator(0L);
        }
        catch (DataException ex) {
            throw new RuntimeException("Can't obtain iterator.", ex);
        }
    }

    public DisposableFeatureSetIterable iterable() {
        return this.iterable(true);
    }

    public DisposableFeatureSetIterable iterable(boolean disposeFeatureSet) {
        if (!disposeFeatureSet) {
            DisposeUtils.bind((Disposable)this);
        }
        return new DisposableFeatureSetIterableImpl(this, this.iterator());
    }

    public DynObjectSet getDynObjectSet() {
        return this.getDynObjectSet(true);
    }

    public DynObjectSet getDynObjectSet(boolean fast) {
        return new DynObjectSetFeatureSetFacade(this, this.getFeatureStore(), fast);
    }

    public boolean isFromStore(DataStore store) {
        return this.getFeatureStore().equals(store);
    }

    public long size64() {
        try {
            return this.getSize();
        }
        catch (DataException ex) {
            throw new RuntimeException("Can't get size", ex);
        }
    }

    public int size() {
        try {
            long sz = this.getSize();
            if (sz > Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            return (int)sz;
        }
        catch (DataException ex) {
            throw new RuntimeException("Can't get size", ex);
        }
    }

    public JsonArray toJson() {
        JsonArrayBuilder builder = this.toJsonBuilder();
        return builder.build();
    }

    public JsonArrayBuilder toJsonBuilder() {
        try {
            JsonArrayBuilder builder = Json.createArrayBuilder();
            this.accept(obj -> {
                DefaultFeature f = (DefaultFeature)obj;
                JsonObject fjson = f.toJson();
                builder.add((JsonValue)fjson);
            });
            return builder;
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't create JSON array.", ex);
        }
    }

    @Deprecated
    public JsonArray toJSON() {
        return this.toJson();
    }

    public Expression makeFilter(int maxfeatures) {
        try {
            FeatureType ftype = this.getDefaultFeatureType();
            if (!ftype.hasPrimaryKey()) {
                return null;
            }
            ExpressionBuilder builder = ExpressionUtils.createExpressionBuilder();
            MutableInt counter = new MutableInt(0);
            this.accept(obj -> {
                if (counter.getAndIncrement() >= maxfeatures) {
                    throw new VisitCanceledException();
                }
                Feature feature = (Feature)obj;
                for (FeatureAttributeDescriptor attrdesc : ftype.getPrimaryKey()) {
                    builder.or((ExpressionBuilder.Value)builder.eq((ExpressionBuilder.Value)builder.column(attrdesc.getName()), (ExpressionBuilder.Value)builder.constant(feature.get(attrdesc.getName()))));
                }
            });
            Expression filter = ExpressionUtils.createExpression((String)builder.toString());
            return filter;
        }
        catch (Exception ex) {
            LOGGER.warn("Can't build filter expression.", (Throwable)ex);
            return null;
        }
    }

    private static class DisposableFeatureSetIterableImpl
    implements DisposableFeatureSetIterable {
        private final FeatureSet fset;
        private final DisposableIterator it;

        public DisposableFeatureSetIterableImpl(FeatureSet fset, DisposableIterator it) {
            this.fset = fset;
            this.it = it;
        }

        public boolean hasNext() {
            return this.it.hasNext();
        }

        public Feature next() {
            return (Feature)this.it.next();
        }

        public Iterator<Feature> iterator() {
            return this.it;
        }

        public void dispose() {
            DisposeUtils.disposeQuietly((Disposable)this.it);
            DisposeUtils.disposeQuietly((Disposable)this.fset);
        }

        public boolean isEmpty() {
            return this.fset.isEmpty();
        }

        public long size64() {
            return this.fset.size64();
        }

        public FeatureSet getFeatureSet() {
            return this.fset;
        }
    }
}

