/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.feature.impl.featureset;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureIndexes;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureQueryOrder;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureStoreNotification;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.exception.ConcurrentDataModificationException;
import org.gvsig.fmap.dal.feature.exception.FeatureSetInitializeException;
import org.gvsig.fmap.dal.feature.impl.DefaultFeatureStore;
import org.gvsig.fmap.dal.feature.impl.DefaultFeatureStoreTransforms;
import org.gvsig.fmap.dal.feature.impl.DefaultFeatureType;
import org.gvsig.fmap.dal.feature.impl.featureset.AbstractFeatureSet;
import org.gvsig.fmap.dal.feature.impl.featureset.DefaultIterator;
import org.gvsig.fmap.dal.feature.impl.featureset.EditedFilteredIterator;
import org.gvsig.fmap.dal.feature.impl.featureset.EditedIterator;
import org.gvsig.fmap.dal.feature.impl.featureset.FastDefaultIterator;
import org.gvsig.fmap.dal.feature.impl.featureset.FastEditedFilteredIterator;
import org.gvsig.fmap.dal.feature.impl.featureset.FastEditedIterator;
import org.gvsig.fmap.dal.feature.impl.featureset.FastFilteredIterator;
import org.gvsig.fmap.dal.feature.impl.featureset.FastOrderedIterator;
import org.gvsig.fmap.dal.feature.impl.featureset.FilteredIterator;
import org.gvsig.fmap.dal.feature.impl.featureset.OrderedIterator;
import org.gvsig.fmap.dal.feature.spi.FeatureSetProvider;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposableIterator;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.evaluator.Evaluator;
import org.gvsig.tools.observer.Observable;
import org.gvsig.tools.observer.Observer;

public class DefaultFeatureSet
extends AbstractFeatureSet
implements FeatureSet,
Observer {
    protected static final int NO_CHECKED = -1;
    protected static final int DEFAULT = 0;
    protected static final int FILTERED = 1;
    protected static final int ORDERED = 2;
    protected static final int ORDERED_FILTERED = 3;
    protected static final int EDITED = 4;
    protected static final int EDITED_FILTERED = 5;
    protected static final int ORDERD_EDITED = 6;
    protected static final int ORDERED_EDITED_FILTER = 7;
    protected Throwable sourceStoreModifiedCause;
    protected boolean sourceStoreModified;
    protected boolean ownFeaturesModified;
    protected DefaultFeatureStore store;
    protected List featureTypes;
    protected FeatureQuery query;
    protected FeatureSetProvider provider;
    protected long size;
    protected int iteratorMode;
    protected List orderedData;
    protected Feature featureToIgnoreNotification;
    protected DefaultFeatureStoreTransforms transform;
    protected FeatureQuery queryForProvider;
    protected FeatureType defaultFeatureType;
    protected FeatureType defatulFeatureTypeForProvider;
    protected boolean ignoreChanges;
    private boolean disposed = false;
    private boolean ignoreConcurrentChanges;

    public DefaultFeatureSet(DefaultFeatureStore store, FeatureQuery query) throws DataException {
        DisposeUtils.bind((Disposable)this);
        this.featureToIgnoreNotification = null;
        this.iteratorMode = -1;
        this.sourceStoreModified = false;
        this.ownFeaturesModified = false;
        this.size = -1L;
        this.orderedData = null;
        this.store = store;
        this.ignoreConcurrentChanges = false;
        DisposeUtils.bind((Disposable)this.store);
        this.transform = this.store.isEditing() ? this.store.getFeatureTypeManager().getTransforms() : (DefaultFeatureStoreTransforms)store.getTransforms();
        this.query = query;
        try {
            this.queryForProvider = (FeatureQuery)query.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new FeatureSetInitializeException((Throwable)e);
        }
        this.featureTypes = new ArrayList();
        if (this.query.getFeatureTypeId() == null && this.query.getAttributeNames() == null) {
            this.defaultFeatureType = this.store.getDefaultFeatureType();
            this.featureTypes.addAll(this.store.getFeatureTypes());
        } else {
            this.defaultFeatureType = this.store.getFeatureType(this.query);
            List cols = this.query.getExtraColumn().getColumns();
            if (this.query != null && cols != null && !cols.isEmpty()) {
                DefaultFeatureType featureTypeExtraCols = (DefaultFeatureType)this.defaultFeatureType.getCopy();
                featureTypeExtraCols.setExtraColumn(this.query.getExtraColumn());
                this.defaultFeatureType = featureTypeExtraCols;
            }
            this.featureTypes.add(this.defaultFeatureType);
        }
        if (this.transform != null && !this.transform.isEmpty()) {
            this.fixQueryForProvider(this.queryForProvider, this.transform);
        } else {
            this.defatulFeatureTypeForProvider = this.defaultFeatureType;
        }
        FeatureIndexes indexes = store.getIndexes();
        if (this.queryForProvider.hasFilter() && indexes != null && indexes.areValid()) {
            this.provider = (FeatureSetProvider)indexes.getFeatureSet(this.queryForProvider.getFilter());
        }
        if (this.provider == null) {
            this.provider = this.store.getProvider().createSet(this.queryForProvider, this.defatulFeatureTypeForProvider, this.defaultFeatureType);
        }
        this.store.addObserver(this);
    }

    private void fixQueryForProvider(FeatureQuery theQueryForProvider, DefaultFeatureStoreTransforms transformsToUse) throws DataException {
        boolean canUseFilter;
        theQueryForProvider.clearAttributeNames();
        FeatureType ftype = transformsToUse.getSourceFeatureTypeFrom(this.defaultFeatureType);
        theQueryForProvider.setFeatureTypeId(ftype.getId());
        this.defatulFeatureTypeForProvider = ftype;
        if (transformsToUse.isTransformsOriginalValues()) {
            theQueryForProvider.clearFilter();
            FeatureQueryOrder fqo = theQueryForProvider.getOrder();
            if (fqo != null) {
                fqo.clear();
            }
            return;
        }
        Evaluator filter = theQueryForProvider.getFilter();
        if (filter != null && !(canUseFilter = filter.getFieldsInfo() == null ? false : this.areEvaluatorFieldsInAttributes(filter, ftype))) {
            theQueryForProvider.clearFilter();
        }
        if (theQueryForProvider.hasOrder()) {
            boolean canUseOrder = true;
            for (FeatureQueryOrder.FeatureQueryOrderMember item : theQueryForProvider.getOrder()) {
                if (item.hasEvaluator()) {
                    if (this.areEvaluatorFieldsInAttributes(item.getEvaluator(), ftype)) continue;
                    canUseOrder = false;
                    break;
                }
                if (ftype.get(item.getAttributeName()) != null) continue;
                canUseOrder = false;
                break;
            }
            if (!canUseOrder) {
                theQueryForProvider.getOrder().clear();
            }
        }
    }

    private boolean areEvaluatorFieldsInAttributes(Evaluator evaluator, FeatureType fType) {
        if (evaluator.getFieldsInfo() == null) {
            return false;
        }
        String[] fieldNames = evaluator.getFieldsInfo().getFieldNames();
        if (fieldNames.length == 0) {
            return false;
        }
        for (String fieldName : fieldNames) {
            if (fType.get(fieldName) != null) continue;
            return false;
        }
        return true;
    }

    public FeatureType getDefaultFeatureType() {
        return this.defaultFeatureType;
    }

    public List getFeatureTypes() {
        return Collections.unmodifiableList(this.featureTypes);
    }

    public long getSize() throws DataException {
        this.checkSourceStoreModified();
        if (this.size < 0L) {
            this.size = this.calculateSize();
        }
        return this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long calculateSize() throws DataException {
        boolean hasLimit = this.query.hasLimit();
        long limit = this.query.getLimit();
        if (hasLimit && limit == 0L) {
            return 0L;
        }
        int mode = this.getIteratorMode();
        DisposableIterator iter = null;
        switch (mode) {
            case 0: 
            case 2: {
                if (this.provider.isEmpty()) {
                    return 0L;
                }
                long mySize = this.provider.getSize();
                return hasLimit && mySize > limit ? limit : mySize;
            }
            case 1: 
            case 3: {
                long mySize;
                try {
                    iter = this.fastIterator();
                    for (mySize = 0L; hasLimit && mySize < limit || !hasLimit; ++mySize) {
                        iter.next();
                    }
                }
                catch (NoSuchElementException noSuchElementException) {
                }
                finally {
                    DisposeUtils.disposeQuietly((Disposable)iter);
                }
                return limit >= 0L && mySize > limit ? limit : mySize;
            }
            case 4: 
            case 6: {
                long mySize = this.provider.getSize() + this.store.getFeatureManager().getDeltaSize();
                return hasLimit && mySize > limit ? limit : mySize;
            }
            case 5: 
            case 7: {
                long mySize;
                try {
                    iter = this.fastIterator();
                    while (hasLimit && mySize < limit || !hasLimit) {
                        iter.next();
                        ++mySize;
                    }
                }
                catch (NoSuchElementException noSuchElementException) {
                }
                finally {
                    DisposeUtils.disposeQuietly((Disposable)iter);
                }
                return hasLimit && mySize > limit ? limit : mySize;
            }
        }
        throw new IllegalArgumentException();
    }

    public final synchronized void dispose() {
        if (!this.disposed && DisposeUtils.release((Disposable)this)) {
            try {
                this.doDispose();
            }
            catch (Exception ex) {
                LOG.error("Error performing dispose", (Throwable)ex);
            }
            finally {
                this.disposed = true;
            }
        }
    }

    public void doDispose() {
        if (this.store != null) {
            this.store.deleteObserver(this);
            DisposeUtils.dispose((Disposable)this.store);
            this.store = null;
        }
        if (this.provider != null) {
            this.provider.dispose();
            this.provider = null;
        }
        if (this.orderedData != null) {
            this.orderedData.clear();
            this.orderedData = null;
        }
        this.featureToIgnoreNotification = null;
        this.transform = null;
        this.query = null;
        this.queryForProvider = null;
        this.featureTypes = null;
        this.defaultFeatureType = null;
        this.defatulFeatureTypeForProvider = null;
    }

    public void update(Observable obsevable, Object notification) {
        if (this.ignoreConcurrentChanges) {
            return;
        }
        if (this.sourceStoreModified) {
            return;
        }
        String type = ((FeatureStoreNotification)notification).getType();
        if (type.equalsIgnoreCase("after_Insert_Feature") || type.equalsIgnoreCase("after_Delete_Feature") || type.equalsIgnoreCase("after_Update_Feature")) {
            if (this.featureToIgnoreNotification == ((FeatureStoreNotification)notification).getFeature()) {
                return;
            }
            this.sourceStoreModified = true;
            this.sourceStoreModifiedCause = new SetConcurrentModificationException(this.store, this.query);
            return;
        }
        if (type.equalsIgnoreCase("after_Update_Type") || type.equalsIgnoreCase("after_Redo_DataStore") || type.equalsIgnoreCase("after_Undo_DataStore") || type.equalsIgnoreCase("after_refresh") || type.equalsIgnoreCase("complex_notification") || type.equalsIgnoreCase("Transform_Change")) {
            this.sourceStoreModified = true;
            this.sourceStoreModifiedCause = new SetConcurrentModificationException(this.store, this.query);
            return;
        }
        if (type.equalsIgnoreCase("resourceChange_DataStore") && !this.ignoreChanges) {
            this.sourceStoreModified = true;
            this.sourceStoreModifiedCause = new SetConcurrentModificationException(this.store, this.query);
            return;
        }
        if (type.equalsIgnoreCase("after_CancelEditing_DataStore") && this.ownFeaturesModified) {
            this.sourceStoreModified = true;
            this.sourceStoreModifiedCause = new SetConcurrentModificationException(this.store, this.query);
            return;
        }
    }

    protected void checkSourceStoreModified() {
        if (this.ignoreConcurrentChanges) {
            return;
        }
        if (this.sourceStoreModified) {
            LOG.debug("ConcurrentDataModification in featureSet " + ((Object)((Object)this)).hashCode() + " of store '" + (this.store == null ? "" : this.store.getName()) + "'");
            ConcurrentDataModificationException ex = new ConcurrentDataModificationException(this.store == null ? "" : this.store.getName());
            ex.initCause(this.sourceStoreModifiedCause);
            throw ex;
        }
    }

    public DisposableIterator fastIterator(long index) throws DataException {
        return this.fastIterator(index, 0L);
    }

    public DisposableIterator fastIterator(long index, long elements) throws DataException {
        DisposableIterator it;
        if (index < 0L) {
            throw new IndexOutOfBoundsException("The index (" + index + ") is less than 0");
        }
        int mode = this.getIteratorMode();
        switch (mode) {
            case 0: {
                it = new FastDefaultIterator(this, index, elements);
                break;
            }
            case 1: {
                it = new FastFilteredIterator(this, index, elements);
                break;
            }
            case 2: {
                if (this.provider.canOrder() && this.provider.canIterateFromIndex()) {
                    it = new FastDefaultIterator(this, index, elements);
                    break;
                }
                if (this.orderedData != null) {
                    it = new FastOrderedIterator(this, index);
                    break;
                }
                it = new FastOrderedIterator(this, (Iterator)((Object)new FastDefaultIterator(this, 0L, -1L)), index);
                break;
            }
            case 3: {
                if (this.provider.canOrder() && this.provider.canFilter() && this.provider.canIterateFromIndex()) {
                    it = new FastFilteredIterator(this, index, elements);
                    break;
                }
                if (this.orderedData != null) {
                    it = new FastOrderedIterator(this, index);
                    break;
                }
                it = new FastOrderedIterator(this, (Iterator)((Object)new FastFilteredIterator(this, 0L, -1L)), index);
                break;
            }
            case 4: {
                it = new FastEditedIterator(this, index, elements);
                break;
            }
            case 5: {
                it = new FastEditedFilteredIterator(this, index, elements);
                break;
            }
            case 6: {
                if (this.provider.canOrder() && this.provider.canIterateFromIndex() && !this.store.getFeatureManager().hasDeleteds()) {
                    it = new FastEditedIterator(this, index, elements);
                    break;
                }
                if (this.orderedData != null) {
                    it = new FastOrderedIterator(this, index);
                    break;
                }
                it = new FastOrderedIterator(this, (Iterator)((Object)new FastEditedIterator(this, 0L, -1L)), index);
                break;
            }
            case 7: {
                if (this.provider.canOrder() && this.provider.canFilter() && this.provider.canIterateFromIndex() && !this.store.getFeatureManager().hasDeleteds()) {
                    it = new FastEditedFilteredIterator(this, index, elements);
                    break;
                }
                if (this.orderedData != null) {
                    it = new FastOrderedIterator(this, index);
                    break;
                }
                it = new FastOrderedIterator(this, (Iterator)((Object)new FastEditedFilteredIterator(this, 0L, -1L)), index);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        if (this.query != null && this.query.getLimit() > 0L) {
            it = new LimitIterator(it, this.query.getLimit());
        }
        return it;
    }

    public void setIgnoreConcurrentChanges(boolean b) {
        this.ignoreConcurrentChanges = b;
    }

    public DisposableIterator iterator(long index) throws DataException {
        return this.iterator(index, 0L);
    }

    public DisposableIterator iterator(long index, long elements) throws DataException {
        DisposableIterator it;
        if (index < 0L) {
            throw new IndexOutOfBoundsException("The index (" + index + ") is less than 0");
        }
        int mode = this.getIteratorMode();
        switch (mode) {
            case 0: {
                it = new DefaultIterator(this, index, elements);
                break;
            }
            case 1: {
                it = new FilteredIterator(this, index, elements);
                break;
            }
            case 2: {
                if (this.provider.canOrder() && this.provider.canIterateFromIndex()) {
                    it = new DefaultIterator(this, index, elements);
                    break;
                }
                if (this.orderedData != null) {
                    it = new OrderedIterator(this, index);
                    break;
                }
                it = new OrderedIterator(this, (Iterator)((Object)new DefaultIterator(this, 0L, elements)), index);
                break;
            }
            case 3: {
                if (this.provider.canOrder() && this.provider.canFilter() && this.provider.canIterateFromIndex()) {
                    it = new FilteredIterator(this, index, elements);
                    break;
                }
                if (this.orderedData != null) {
                    it = new OrderedIterator(this, index);
                    break;
                }
                it = new OrderedIterator(this, (Iterator)((Object)new FilteredIterator(this, 0L, -1L)), index);
                break;
            }
            case 4: {
                it = new EditedIterator(this, index, elements);
                break;
            }
            case 5: {
                it = new EditedFilteredIterator(this, index, elements);
                break;
            }
            case 6: {
                if (this.provider.canOrder() && this.provider.canIterateFromIndex() && !this.store.getFeatureManager().hasDeleteds()) {
                    it = new EditedIterator(this, index, elements);
                    break;
                }
                if (this.orderedData != null) {
                    it = new OrderedIterator(this, index);
                    break;
                }
                it = new OrderedIterator(this, (Iterator)((Object)new EditedIterator(this, 0L, -1L)), index);
                break;
            }
            case 7: {
                if (this.provider.canOrder() && this.providerCanFilter() && this.provider.canIterateFromIndex() && !this.store.getFeatureManager().hasDeleteds()) {
                    it = new EditedFilteredIterator(this, index, elements);
                    break;
                }
                if (this.orderedData != null) {
                    it = new OrderedIterator(this, index);
                    break;
                }
                it = new OrderedIterator(this, (Iterator)((Object)new EditedFilteredIterator(this, 0L, -1L)), index);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        if (this.query != null && this.query.getLimit() > 0L) {
            it = new LimitIterator(it, this.query.getLimit());
        }
        return it;
    }

    private boolean providerCanOrder() {
        return this.provider.canOrder();
    }

    private boolean providerCanFilter() {
        return this.provider.canFilter();
    }

    private int getIteratorMode() {
        if (this.iteratorMode != -1) {
            return this.iteratorMode;
        }
        if (this.store.isEditing() && (this.store.getFeatureTypeManager().hasChanges() || this.store.getFeatureManager().hasChanges())) {
            if (this.query.hasOrder()) {
                if (this.query.hasFilter()) {
                    return 7;
                }
                return 6;
            }
            if (this.query.hasFilter()) {
                return 5;
            }
            return 4;
        }
        boolean useMyFilter = this.query.hasFilter();
        boolean useMyOrder = this.query.hasOrder();
        if (this.providerCanOrder() && this.transform.isEmpty()) {
            useMyOrder = false;
        }
        if (this.providerCanFilter() && this.transform.isEmpty()) {
            useMyFilter = false;
        }
        if (useMyOrder) {
            if (useMyFilter) {
                return 3;
            }
            return 2;
        }
        if (useMyFilter) {
            return 1;
        }
        return 0;
    }

    public void delete(Feature feature) throws DataException {
        this.featureToIgnoreNotification = feature;
        this.store.delete(feature);
        if (this.size > 0L) {
            --this.size;
        }
        this.featureToIgnoreNotification = null;
        this.ownFeaturesModified = true;
    }

    public void insert(EditableFeature feature) throws DataException {
        this.featureToIgnoreNotification = feature;
        this.store.insert(feature);
        if (this.size >= 0L) {
            ++this.size;
        }
        this.featureToIgnoreNotification = null;
        this.ownFeaturesModified = true;
    }

    public void update(EditableFeature feature) throws DataException {
        this.featureToIgnoreNotification = feature;
        this.store.update(feature);
        this.featureToIgnoreNotification = null;
        this.ownFeaturesModified = true;
    }

    public void commitChanges() throws DataException {
        this.ignoreChanges = true;
        this.store.commitChanges();
        this.ignoreChanges = false;
    }

    @Override
    public FeatureStore getFeatureStore() {
        return this.store;
    }

    public static class SetConcurrentModificationException
    extends Exception {
        public SetConcurrentModificationException(FeatureStore store, FeatureQuery query) {
            super("Some of the features in this set based on the store '" + SetConcurrentModificationException.getStoreName(store) + "' have been modified by others. This set is no longer valid. Query description:" + SetConcurrentModificationException.getQueryDescription(query));
        }

        private static String getStoreName(FeatureStore store) {
            try {
                return store.getName();
            }
            catch (Throwable th) {
                return "unknown";
            }
        }

        private static String getQueryDescription(FeatureQuery query) {
            try {
                return query.toJson().toString();
            }
            catch (Throwable th) {
                return "unknown";
            }
        }
    }

    private class LimitIterator
    implements DisposableIterator {
        private final DisposableIterator it;
        private final long limit;
        private int count;

        private LimitIterator(DisposableIterator it, long limit) {
            this.it = it;
            this.limit = limit;
            this.count = 0;
        }

        public void dispose() {
            this.it.dispose();
        }

        public boolean hasNext() {
            if ((long)this.count >= this.limit) {
                return false;
            }
            return this.it.hasNext();
        }

        public Object next() {
            if ((long)this.count >= this.limit) {
                return null;
            }
            ++this.count;
            return this.it.next();
        }

        public void remove() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

