/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.feature.impl.featureset;

import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.impl.DefaultFeature;
import org.gvsig.fmap.dal.feature.impl.featureset.DefaultFeatureSet;
import org.gvsig.fmap.dal.feature.impl.featureset.FilteredIterator;
import org.gvsig.fmap.dal.feature.spi.FeatureProvider;
import org.gvsig.tools.exception.BaseException;

public class FastFilteredIterator
extends FilteredIterator {
    DefaultFeature myFeature;

    FastFilteredIterator(DefaultFeatureSet featureSet, long index, long elements) throws DataException {
        super(featureSet);
        this.initializeFeature();
        if (featureSet.provider.canFilter() && featureSet.provider.canIterateFromIndex()) {
            this.iterator = featureSet.provider.iterator(index, elements);
        } else {
            this.iterator = featureSet.provider.iterator();
            if (index > 0L) {
                this.skypto(index);
            }
        }
    }

    @Override
    protected DefaultFeature createFeature(FeatureProvider fData) throws DataException {
        fData.setNew(false);
        this.myFeature.setData(fData);
        if (this.fset.transform.isEmpty()) {
            return this.myFeature;
        }
        return (DefaultFeature)this.fset.transform.applyTransform(this.myFeature, this.fset.getDefaultFeatureType());
    }

    protected void initializeFeature() {
        this.myFeature = new DefaultFeature(this.fset.store);
    }

    @Override
    public void remove() {
        super.remove();
        this.initializeFeature();
    }

    @Override
    protected void doDispose() throws BaseException {
        super.doDispose();
        this.myFeature = null;
    }
}

