/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.feature.impl.featureset;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.gvsig.fmap.dal.exception.DataEvaluatorException;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureReference;
import org.gvsig.fmap.dal.feature.impl.DefaultFeature;
import org.gvsig.fmap.dal.feature.impl.featureset.DefaultFeatureSet;
import org.gvsig.fmap.dal.feature.impl.featureset.DefaultIterator;
import org.gvsig.fmap.dal.feature.spi.FeatureProvider;
import org.gvsig.tools.evaluator.Evaluator;
import org.gvsig.tools.evaluator.EvaluatorData;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.task.UserCancelTaskException;

public class FilteredIterator
extends DefaultIterator {
    protected boolean nextChecked = false;
    protected DefaultFeature current = null;
    protected Evaluator filter;

    protected FilteredIterator(DefaultFeatureSet featureSet) {
        super(featureSet);
        this.filter = featureSet.query.getFilter();
    }

    FilteredIterator(DefaultFeatureSet featureSet, long index, long elements) throws DataException {
        this(featureSet);
        if (featureSet.provider.canFilter() && featureSet.provider.canIterateFromIndex()) {
            this.iterator = featureSet.provider.iterator(index, elements);
        } else {
            this.iterator = featureSet.provider.iterator();
            if (index > 0L) {
                this.skypto(index);
            }
        }
    }

    @Override
    protected void skypto(long index) {
        for (long n = 0L; n < index && this.hasNext(); ++n) {
            this.next();
        }
    }

    @Override
    protected void doNext() throws DataException {
        this.nextChecked = true;
        while (this.getIterator().hasNext()) {
            DefaultFeature feature;
            Object obj = this.getIterator().next();
            if (obj == null) continue;
            if (obj instanceof FeatureProvider) {
                FeatureProvider data = (FeatureProvider)obj;
                feature = this.createFeature(data);
            } else {
                feature = (DefaultFeature)obj;
            }
            if (!this.match(feature)) continue;
            this.current = feature;
            return;
        }
        this.current = null;
    }

    @Override
    protected Iterator getIterator() {
        return this.iterator;
    }

    @Override
    public boolean hasNext() {
        if (this.fset == null) {
            return false;
        }
        this.fset.checkSourceStoreModified();
        if (this.nextChecked) {
            return this.current != null;
        }
        try {
            this.doNext();
        }
        catch (DataException e) {
            NullPointerException ex = new NullPointerException();
            ex.initCause(e);
            throw ex;
        }
        return this.current != null;
    }

    protected boolean toBooleanMatch(Object x) {
        if (x == null) {
            return false;
        }
        if (x instanceof Boolean) {
            return (Boolean)x;
        }
        return true;
    }

    protected boolean match(DefaultFeature feature) throws DataException {
        try {
            if (this.filter == null) {
                return true;
            }
            Object x = this.filter.evaluate((EvaluatorData)feature);
            return this.toBooleanMatch(x);
        }
        catch (UserCancelTaskException e) {
            throw e;
        }
        catch (Exception e) {
            FeatureReference ref = null;
            try {
                ref = feature.getReference();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw new DataEvaluatorException((Throwable)e, Objects.toString(ref));
        }
    }

    @Override
    public Object next() {
        this.fset.checkSourceStoreModified();
        if (!this.nextChecked) {
            this.hasNext();
        }
        if (this.current == null) {
            throw new NoSuchElementException();
        }
        this.lastFeature = null;
        this.nextChecked = false;
        DefaultFeature feature = this.current;
        this.current = null;
        this.lastFeature = feature;
        return feature;
    }

    @Override
    protected void doDispose() throws BaseException {
        super.doDispose();
        this.current = null;
        this.filter = null;
    }
}

