/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.feature.impl.featureset;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.impl.DefaultFeature;
import org.gvsig.fmap.dal.feature.impl.featureset.DefaultFeatureSet;
import org.gvsig.fmap.dal.feature.impl.featureset.DefaultIterator;
import org.gvsig.fmap.dal.feature.impl.featureset.FeatureProviderComparator;
import org.gvsig.fmap.dal.feature.spi.FeatureProvider;
import org.gvsig.tools.dispose.DisposableIterator;
import org.gvsig.tools.exception.BaseException;

public class OrderedIterator
extends DefaultIterator {
    protected Feature lastFeature = null;

    OrderedIterator(DefaultFeatureSet featureSet, Iterator iterator, long index) {
        super(featureSet);
        if (featureSet.orderedData == null) {
            ArrayList<Object> data = new ArrayList<Object>();
            while (iterator.hasNext()) {
                Object item = iterator.next();
                if (item instanceof DefaultFeature) {
                    data.add(((DefaultFeature)item).getData());
                    continue;
                }
                data.add(item);
            }
            Collections.sort(data, new FeatureProviderComparator(featureSet.store, featureSet.query.getOrder()));
            featureSet.orderedData = data;
        }
        if (iterator instanceof DisposableIterator) {
            ((DisposableIterator)iterator).dispose();
        }
        iterator = null;
        if (index < Integer.MAX_VALUE) {
            this.iterator = featureSet.orderedData.listIterator((int)index);
        } else {
            this.iterator = featureSet.orderedData.iterator();
            this.skypto(index);
        }
    }

    public OrderedIterator(DefaultFeatureSet featureSet, long index) {
        super(featureSet);
        if (index < Integer.MAX_VALUE) {
            this.iterator = featureSet.orderedData.listIterator((int)index);
        } else {
            this.iterator = featureSet.orderedData.iterator();
            this.skypto(index);
        }
    }

    @Override
    public void remove() {
        super.remove();
        this.iterator.remove();
    }

    @Override
    protected DefaultFeature createFeature(FeatureProvider fData) throws DataException {
        fData.setNew(false);
        return new DefaultFeature(this.fset.store, fData);
    }

    @Override
    protected void doDispose() throws BaseException {
        super.doDispose();
        this.lastFeature = null;
    }
}

