/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.impl;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.json.JsonObject;
import javax.json.JsonValue;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.expressionevaluator.SymbolTable;
import org.gvsig.fmap.dal.AbstractStoresRepository;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataParameters;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.DatabaseStoresRepository;
import org.gvsig.fmap.dal.DatabaseWorkspaceManager;
import org.gvsig.fmap.dal.exception.ValidateDataParametersException;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.impl.DefaultDatabaseWorkspaceManager;
import org.gvsig.json.Json;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dynobject.DynClass;
import org.gvsig.tools.dynobject.DynField;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.util.Bitmask;
import org.gvsig.tools.util.HasAFile;
import org.gvsig.tools.util.UnmodifiableBasicSet;
import org.gvsig.tools.util.UnmodifiableBasicSetAdapter;
import org.gvsig.tools.visitor.VisitCanceledException;
import org.gvsig.tools.visitor.Visitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseWorkspaceStoresRepository
extends AbstractStoresRepository
implements DatabaseStoresRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultDatabaseWorkspaceManager.class);
    private final DefaultDatabaseWorkspaceManager workspace;
    private Map<String, DataStoreParameters> repository;
    public static final int BIT_CHANGE_PORT_HOST = 0;
    public static final int BIT_CHANGE_USER = 1;
    public static final int BIT_CHANGE_DBNAME_CATALOG_SCHEMA = 2;
    private static final String HOST_PARAMTER_NAME = "host";
    private static final String PORT_PARAMTER_NAME = "port";
    private static final String DBNAME_PARAMTER_NAME = "dbname";
    private static final String USER_PARAMTER_NAME = "dbuser";
    private static final String PASSWORD_PARAMTER_NAME = "password";
    private static final String URL_PARAMTER_NAME = "url";
    private static final String CATALOG_PARAMTER_NAME = "catalog";
    private static final String SCHEMA_PARAMTER_NAME = "schema";

    public DatabaseWorkspaceStoresRepository(String name, String label, DatabaseWorkspaceManager workspace) {
        super(name, label);
        this.workspace = (DefaultDatabaseWorkspaceManager)workspace;
        this.repository = null;
        this.setServerParameters(this.workspace.getServerExplorerParameters());
    }

    private void evaluateExpressionsInFiles(DataStoreParameters parameters) {
        DynClass dynClass = parameters.getDynClass();
        if (dynClass == null) {
            return;
        }
        File theBaseFolder = this.workspace.getBaseFolder();
        File theWorkspaceFile = this.workspace.getWorkspaceFile();
        if (theBaseFolder == null && theWorkspaceFile == null) {
            return;
        }
        block5: for (DynField dynField : dynClass.getDynFields()) {
            switch (dynField.getType()) {
                case 13: 
                case 14: {
                    File f = (File)parameters.getDynValue(dynField.getName());
                    if (!ExpressionUtils.isDynamicFilename((File)f)) continue block5;
                    parameters.setDynValue(dynField.getName(), (Object)ExpressionUtils.evaluateFilename((SymbolTable)this.workspace, (File)f));
                }
            }
        }
        try {
            if (parameters instanceof HasAFile) {
                HasAFile params = (HasAFile)parameters;
                params.setFile(ExpressionUtils.evaluateFilename((File)params.getFile()));
            }
            parameters.validate();
        }
        catch (ValidateDataParametersException ex) {
            LOGGER.warn("Not been able to validate parameters", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        FeatureStore store = null;
        try {
            this.repository = new HashMap<String, DataStoreParameters>();
            final DataManager dataManager = DALLocator.getDataManager();
            File repositoryFolder = new File(dataManager.getLocalResourcesFolder(this.workspace.getServerExplorerParameters()), "repository");
            if (repositoryFolder.exists()) {
                this.loadLocalWorkspaceRepository();
                return;
            }
            store = this.workspace.getTable(1);
            if (store == null) {
                DisposeUtils.disposeQuietly((Disposable)store);
                return;
            }
            final DataStoreParameters storeParameters = store.getParameters();
            final FeatureType ftype = store.getDefaultFeatureTypeQuietly();
            store.accept(new Visitor(){

                public void visit(Object obj) throws VisitCanceledException, BaseException {
                    DataStoreParameters params;
                    Feature f = (Feature)obj;
                    String name = f.getString("name");
                    byte[] data = f.getByteArray("parameters");
                    int flags = 0;
                    if (f.getType().getAttributeDescriptor("flags") != null) {
                        flags = f.getInt("flags");
                    }
                    if ((params = dataManager.createStoreParameters(data)) == null) {
                        LOGGER.warn("Can't restore parameters from repository entry '" + name + "'.");
                        return;
                    }
                    DatabaseWorkspaceStoresRepository.this.processParameters(params, (DataParameters)storeParameters, Bitmask.createBitmask((int)flags));
                    DatabaseWorkspaceStoresRepository.this.evaluateExpressionsInFiles(params);
                    DatabaseWorkspaceStoresRepository.this.repository.put(name, params);
                    if (ftype != null && ftype.get("extra") != null) {
                        String extra_s = f.getString("extra");
                        DatabaseWorkspaceStoresRepository.this.loadExtraProperties(name, extra_s);
                    }
                }
            });
            DisposeUtils.disposeQuietly((Disposable)store);
        }
        catch (Exception ex) {
            if (store == null) {
                LOGGER.warn("Can't open repository information");
                LOGGER.debug("Can't open repository information", (Throwable)ex);
            } else {
                LOGGER.warn("Can't load repository information", (Throwable)ex);
            }
        }
        finally {
            DisposeUtils.disposeQuietly(store);
        }
    }

    private void processParameters(DataStoreParameters params, DataParameters storeParameters, Bitmask mask) {
        if (mask.isEmpty()) {
            return;
        }
        if (mask.isSetBit(0)) {
            try {
                Object host = storeParameters.getDynValue(HOST_PARAMTER_NAME);
                Object port = storeParameters.getDynValue(PORT_PARAMTER_NAME);
                params.setDynValue(HOST_PARAMTER_NAME, host);
                params.setDynValue(PORT_PARAMTER_NAME, port);
                params.setDynValue(URL_PARAMTER_NAME, null);
            }
            catch (Exception ex) {
                throw new RuntimeException("Unable to set host and port from actual connection", ex);
            }
        }
        if (mask.isSetBit(1)) {
            try {
                Object dbuser = storeParameters.getDynValue(USER_PARAMTER_NAME);
                Object password = storeParameters.getDynValue(PASSWORD_PARAMTER_NAME);
                params.setDynValue(USER_PARAMTER_NAME, dbuser);
                params.setDynValue(PASSWORD_PARAMTER_NAME, password);
            }
            catch (Exception ex) {
                throw new RuntimeException("Unable to set user and passwrod from actual connection", ex);
            }
        }
        if (mask.isSetBit(2)) {
            try {
                Object dbname = storeParameters.getDynValue(DBNAME_PARAMTER_NAME);
                Object catalog = storeParameters.getDynValue(CATALOG_PARAMTER_NAME);
                Object schema = storeParameters.getDynValue(SCHEMA_PARAMTER_NAME);
                params.setDynValue(DBNAME_PARAMTER_NAME, dbname);
                params.setDynValue(CATALOG_PARAMTER_NAME, catalog);
                params.setDynValue(SCHEMA_PARAMTER_NAME, schema);
                params.setDynValue(URL_PARAMTER_NAME, null);
            }
            catch (Exception ex) {
                throw new RuntimeException("Unable to set dbname and catalog, schema from actual connection", ex);
            }
        }
    }

    protected DataStoreParameters getMyParameters(String name) {
        DataStoreParameters params;
        if (this.repository == null) {
            this.load();
        }
        if ((params = this.repository.get(name)) != null) {
            return params;
        }
        for (String key : this.repository.keySet()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)name)) continue;
            return this.repository.get(key);
        }
        return null;
    }

    protected boolean isEmptyMyRepository() {
        if (this.repository == null) {
            this.load();
        }
        return this.repository.isEmpty();
    }

    protected int getMySize() {
        if (this.repository == null) {
            this.load();
        }
        return this.repository.size();
    }

    protected UnmodifiableBasicSet<String> getMyKeySet() {
        if (this.repository == null) {
            this.load();
        }
        return new UnmodifiableBasicSetAdapter(this.repository.keySet());
    }

    private void loadExtraProperties(String storename, String properties) {
        if (StringUtils.isNotBlank((CharSequence)properties)) {
            JsonObject extra = Json.createObject((String)properties);
            for (Map.Entry entry : extra.entrySet()) {
                String propname = (String)entry.getKey();
                String propvalue = Json.toString((JsonValue)((JsonValue)entry.getValue()));
                this.setProperty(storename + "." + propname, propvalue);
            }
        }
    }

    private void loadLocalWorkspaceRepository() {
        DataManager dataManager = DALLocator.getDataManager();
        File repositoryFolder = new File(dataManager.getLocalResourcesFolder(this.workspace.getServerExplorerParameters()), "repository");
        if (!repositoryFolder.exists()) {
            return;
        }
        for (String fname : repositoryFolder.list()) {
            File f = new File(repositoryFolder, fname);
            try {
                String extension = FilenameUtils.getExtension((String)fname);
                String storename = FilenameUtils.getBaseName((String)fname);
                if (StringUtils.isBlank((CharSequence)extension) || StringUtils.equalsIgnoreCase((CharSequence)"table", (CharSequence)extension)) {
                    byte[] data = FileUtils.readFileToByteArray((File)f);
                    int flags = 0;
                    DataStoreParameters params = dataManager.createStoreParameters(data);
                    if (params == null) {
                        LOGGER.warn("Can't load Local Workspace Repository '" + f.getAbsolutePath() + "'.");
                        return;
                    }
                    this.processParameters(params, (DataParameters)this.workspace.getServerExplorerParameters(), Bitmask.createBitmask((int)flags));
                    this.evaluateExpressionsInFiles(params);
                    this.repository.put(storename, params);
                    continue;
                }
                if (!StringUtils.equalsIgnoreCase((CharSequence)"props", (CharSequence)extension)) continue;
                String props = FileUtils.readFileToString((File)f, (Charset)StandardCharsets.UTF_8);
                this.loadExtraProperties(storename, props);
            }
            catch (Exception ex) {
                LOGGER.warn("Can't load Local Workspace Repository '" + f.getAbsolutePath() + "'.");
            }
        }
    }
}

