/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.raster.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gvsig.fmap.dal.raster.BandQuery;
import org.gvsig.fmap.dal.raster.RasterQuery;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;

public class DefaultRasterQuery
implements RasterQuery {
    private static final String PERSISTENCE_NAME = "RasterQuery";
    private static final String PERSISTENCE_DESCRIPTION = "";
    private static final String SCALE_FIELD_NAME = "scale";
    private static final String PARAMETERS_FIELD_NAME = "queryParameters";
    private static final String BAND_QUERIES_FIELD_NAME = "bandQueries";
    private static final String CLIP_FIELD_NAME = "clip";
    private static final String PIXEL_SIZE_NAME = "pixelSize";
    private double scale;
    private Map<String, Object> queryParameters = new HashMap<String, Object>();
    private List<BandQuery> bandQueries = new ArrayList<BandQuery>();
    private Envelope clip;
    private double pixelSize;

    public List<BandQuery> getBands() {
        return Collections.unmodifiableList(this.bandQueries);
    }

    public void addBand(BandQuery query) {
        this.bandQueries.add(query);
    }

    public void clearBands() {
        this.bandQueries.clear();
    }

    public void setScale(double scale) {
        this.scale = scale;
    }

    public double getScale() {
        return this.scale;
    }

    public Object getQueryParameter(String name) {
        return this.queryParameters.get(name);
    }

    public void setQueryParameter(String name, Object value) {
        this.queryParameters.put(name, value);
    }

    public Envelope getClip() {
        return this.clip;
    }

    public RasterQuery setClip(Envelope clip) {
        this.clip = clip;
        return this;
    }

    public double getPixelSize() {
        return this.pixelSize;
    }

    public RasterQuery setPixelSize(double pixelSize) {
        this.pixelSize = pixelSize;
        return this;
    }

    public static void registerPersistenceDefinition() {
        PersistenceManager persistenceManager = ToolsLocator.getPersistenceManager();
        DynStruct definition = persistenceManager.getDefinition(PERSISTENCE_NAME);
        if (definition == null) {
            definition = persistenceManager.addDefinition(RasterQuery.class, PERSISTENCE_NAME, PERSISTENCE_DESCRIPTION, null, null);
            definition.addDynFieldDouble(SCALE_FIELD_NAME);
            definition.addDynFieldMap(PARAMETERS_FIELD_NAME);
            definition.addDynFieldList(BAND_QUERIES_FIELD_NAME).setClassOfItems(BandQuery.class);
            definition.addDynFieldObject(CLIP_FIELD_NAME).setClassOfValue(Envelope.class);
            definition.addDynFieldDouble(PIXEL_SIZE_NAME);
        }
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set(SCALE_FIELD_NAME, this.scale);
        state.set(PARAMETERS_FIELD_NAME, this.queryParameters);
        state.set("bands", this.bandQueries);
        state.set(CLIP_FIELD_NAME, (Persistent)this.clip);
        state.set(PIXEL_SIZE_NAME, this.pixelSize);
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        this.queryParameters = new HashMap<String, Object>((Map)state.get(PARAMETERS_FIELD_NAME));
        this.scale = state.getDouble(SCALE_FIELD_NAME);
        this.bandQueries = new ArrayList<BandQuery>((List)state.get("bands"));
        this.clip = (Envelope)state.get(CLIP_FIELD_NAME);
        this.pixelSize = state.getDouble(PIXEL_SIZE_NAME);
    }

    public RasterQuery clone() throws CloneNotSupportedException {
        DefaultRasterQuery rq = new DefaultRasterQuery();
        for (BandQuery bandQuery : this.getBands()) {
            rq.addBand((BandQuery)bandQuery.clone());
        }
        if (this.getClip() != null) {
            rq.setClip((Envelope)this.getClip().clone());
        }
        Set<Map.Entry<String, Object>> entries = this.queryParameters.entrySet();
        for (Map.Entry<String, Object> entry : entries) {
            rq.setQueryParameter(entry.getKey(), entry.getValue());
        }
        rq.setScale(this.scale);
        rq.setPixelSize(this.pixelSize);
        return rq;
    }
}

