/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.cache.tile.impl;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.gvsig.raster.cache.tile.Tile;
import org.gvsig.raster.cache.tile.TileCache;
import org.gvsig.raster.cache.tile.TileCacheLibrary;
import org.gvsig.raster.cache.tile.TileCacheManager;
import org.gvsig.raster.cache.tile.disk.ITileFileSystemStrategy;
import org.gvsig.raster.cache.tile.impl.TileCacheImpl;
import org.gvsig.raster.cache.tile.impl.TileImpl;
import org.gvsig.raster.cache.tile.impl.disk.FlatXFileSystemStrategy;
import org.gvsig.raster.cache.tile.impl.pool.ThreadPoolImpl;
import org.gvsig.raster.cache.tile.impl.provider.DefaultCacheStruct;
import org.gvsig.raster.cache.tile.pool.ThreadPool;
import org.gvsig.raster.cache.tile.provider.CacheStruct;

public class DefaultTileCacheManager
implements TileCacheManager {
    private static DefaultTileCacheManager internalInstance = new DefaultTileCacheManager();
    private TileCache tileCacheInstance = null;
    public static int TILE_TIME_OUT = 20000;

    public static DefaultTileCacheManager getInstance() {
        return internalInstance;
    }

    public TileCache getTileCache(String baseDir) {
        if (this.tileCacheInstance == null) {
            this.tileCacheInstance = new TileCacheImpl(baseDir);
        }
        return this.tileCacheInstance;
    }

    public Tile createTile(int level, int col, int row) {
        return new TileImpl(level, col, row);
    }

    public Tile createTile(int wPx, int hPx, int row, int col, Point2D ul, Point2D lr) {
        return new TileImpl(wPx, hPx, row, col, ul, lr);
    }

    public CacheStruct createCacheStructure(int typeOfCoords, int levels, Rectangle2D layerExtent, double pixelSize, int tilePxWidth, int tilePxHeight, String uri, String layerName, String strategy, String baseDir, String fileSuffix, String epsg, long size) {
        return new DefaultCacheStruct(typeOfCoords, levels, layerExtent, pixelSize, tilePxWidth, tilePxHeight, uri, layerName, this.createStrategy(strategy), baseDir, fileSuffix, epsg, size);
    }

    public CacheStruct createCacheStructure(int typeOfCoords, int levels, Rectangle2D layerExtent, double pixelSize, int tilePxWidth, int tilePxHeight, String layerName, String strategy, String baseDir, String fileSuffix, String epsg, long size) {
        return new DefaultCacheStruct(typeOfCoords, levels, layerExtent, pixelSize, tilePxWidth, tilePxHeight, layerName, layerName, this.createStrategy(strategy), baseDir, fileSuffix, epsg, size);
    }

    public ITileFileSystemStrategy createStrategy(String strategy) {
        FlatXFileSystemStrategy strat = null;
        if (strategy == null || strategy.compareTo(TileCacheLibrary.FLATX_STRUCT) == 0) {
            strat = new FlatXFileSystemStrategy();
        }
        return strat;
    }

    public ThreadPool createThreadPool(boolean priorityActive) {
        return new ThreadPoolImpl(priorityActive);
    }

    public ThreadPool createThreadPool(boolean priorityActive, int nThreads) {
        return new ThreadPoolImpl(priorityActive, nThreads);
    }

    public void setTileTimeOut(int ms) {
        TILE_TIME_OUT = ms;
    }

    public int getTileTimeOut() {
        return TILE_TIME_OUT;
    }
}

