/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.geoprocess.algorithm.buffer;

import com.vividsolutions.jts.geom.Geometry;
import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.geoprocess.algorithm.base.core.GeometryOperation;
import org.gvsig.geoprocess.algorithm.base.util.GeometryUtil;
import org.gvsig.geoprocess.algorithm.base.util.JTSFacade;
import org.gvsig.geoprocess.lib.sextante.AbstractSextanteGeoProcess;
import org.gvsig.tools.dispose.DisposableIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FuseOperation
extends GeometryOperation {
    private static Logger logger = LoggerFactory.getLogger((String)FuseOperation.class.getName());
    private List<Element> featureList = new ArrayList<Element>();
    private String nameIdField = "FID";
    private int iFeat = 0;

    public FuseOperation(AbstractSextanteGeoProcess process) {
        super(process);
    }

    public EditableFeature invoke(org.gvsig.fmap.geom.Geometry g, Feature featureInput) {
        return null;
    }

    public void invoke(org.gvsig.fmap.geom.Geometry g, EditableFeature featureInput) {
    }

    public void computesGeometryOperation(FeatureStore inFeatStore, FeatureStore outFeatStore, String[] attrNames, boolean first) throws DataException {
        Element elem1;
        if (this.featureList != null) {
            this.featureList.clear();
        }
        this.inFeatureStore = inFeatStore;
        FeatureSet featuresSet = inFeatStore.getFeatureSet();
        if (first) {
            this.setFeatureStore(outFeatStore, attrNames);
        }
        DisposableIterator it = featuresSet.fastIterator();
        this.numberOfFeatures = (int)featuresSet.getSize();
        if (this.status != null) {
            this.status.setRangeOfValues(0L, (long)this.numberOfFeatures);
        }
        if (this.process != null) {
            this.process.setProgress(0, this.numberOfFeatures);
        }
        int iCount = 0;
        while (it.hasNext() && !this.process.getTaskMonitor().isCanceled()) {
            Feature feat = ((Feature)it.next()).getCopy();
            Element el = new Element();
            el.feat = feat;
            el.id = iCount;
            this.featureList.add(el);
            if (this.status != null && this.process != null) {
                this.status.setCurValue((long)iCount);
            }
            if (this.process != null) {
                this.process.setProgress(iCount, this.numberOfFeatures);
            }
            ++iCount;
        }
        for (iCount = 0; iCount < this.featureList.size() && !this.process.getTaskMonitor().isCanceled(); ++iCount) {
            elem1 = this.featureList.get(iCount);
            org.gvsig.fmap.geom.Geometry geom1 = elem1.feat.getDefaultGeometry();
            if (this.status != null) {
                this.status.setCurValue((long)iCount);
            }
            if (this.process != null) {
                this.process.setProgress(iCount, this.numberOfFeatures);
            }
            for (int i = iCount + 1; i < this.featureList.size(); ++i) {
                Element elem2 = this.featureList.get(i);
                org.gvsig.fmap.geom.Geometry geom2 = elem2.feat.getDefaultGeometry();
                if (!this.areBBoxesOverlaping(geom1, geom2)) continue;
                if (elem1.jtsGeom == null) {
                    elem1.jtsGeom = GeometryUtil.geomToJTS((org.gvsig.fmap.geom.Geometry)geom1);
                }
                elem2.jtsGeom = GeometryUtil.geomToJTS((org.gvsig.fmap.geom.Geometry)geom2);
                if (!elem1.jtsGeom.intersects(elem2.jtsGeom)) continue;
                elem1.overlapList.add(elem2);
                elem2.overlapList.add(elem1);
            }
        }
        for (iCount = 0; iCount < this.featureList.size() && !this.process.getTaskMonitor().isCanceled(); ++iCount) {
            elem1 = this.featureList.get(iCount);
            if (this.status != null) {
                this.status.setCurValue((long)iCount);
            }
            if (this.process != null) {
                this.process.setProgress(iCount, this.numberOfFeatures);
            }
            if (elem1.insertedToJoin) continue;
            this.buildListToJoin(elem1);
        }
    }

    public void end() {
        if (this.persister != null) {
            this.persister.end();
        }
    }

    private boolean areBBoxesOverlaping(org.gvsig.fmap.geom.Geometry g1, org.gvsig.fmap.geom.Geometry g2) {
        if (g1.getEnvelope().getMaximum(0) < g2.getEnvelope().getMinimum(0)) {
            return false;
        }
        if (g1.getEnvelope().getMinimum(0) > g2.getEnvelope().getMaximum(0)) {
            return false;
        }
        if (g1.getEnvelope().getMaximum(1) < g2.getEnvelope().getMinimum(1)) {
            return false;
        }
        return !(g1.getEnvelope().getMinimum(1) > g2.getEnvelope().getMaximum(1));
    }

    private Geometry computesUnion(List<Geometry> listResult) {
        Geometry newGeom = null;
        int iCount = 0;
        int max = listResult.size();
        if (this.process != null) {
            this.process.setName("Generating union");
        }
        while (listResult.size() > 1) {
            ArrayList<Geometry> list = new ArrayList<Geometry>();
            if (this.status != null) {
                this.status.setCurValue((long)iCount);
            }
            if (this.process != null) {
                this.process.setProgress(iCount, max);
            }
            for (int i = 0; i < listResult.size(); i += 2) {
                if (i == listResult.size() - 1) {
                    list.add(listResult.get(i));
                    continue;
                }
                newGeom = JTSFacade.union((Geometry)listResult.get(i), (Geometry)listResult.get(i + 1));
                list.add(newGeom);
            }
            listResult = list;
        }
        return newGeom;
    }

    private void buildListToJoin(Element elem) {
        Geometry newGeom = null;
        if (elem.overlapList.size() == 0) {
            if (!elem.insertedToJoin) {
                elem.insertedToJoin = true;
            }
            try {
                this.addFeatureToOutput(elem.feat.getDefaultGeometry(), elem.feat);
            }
            catch (DataException e) {
                logger.info("Imposible insertar en la tabla", (Throwable)e);
            }
            catch (CreateGeometryException e) {
                logger.info("Error a\u00f1adiendo geometr\u00eda", (Throwable)e);
            }
        } else {
            ArrayList<Geometry> listResult = new ArrayList<Geometry>();
            NodeTree subtree = new NodeTree(elem, null);
            while (subtree != null) {
                if (!subtree.element.insertedToJoin) {
                    listResult.add(subtree.element.jtsGeom);
                    subtree.element.insertedToJoin = true;
                }
                boolean back = false;
                Element l = subtree.getNext();
                if (l == null) {
                    back = true;
                }
                while (!back && l.insertedToJoin) {
                    l = subtree.getNext();
                    if (l != null) continue;
                    back = true;
                }
                if (back) {
                    subtree = subtree.parent;
                    continue;
                }
                subtree = new NodeTree(l, subtree);
            }
            newGeom = this.computesUnion(listResult);
            try {
                this.addFeatureToOutput(newGeom, elem.feat);
            }
            catch (DataException e) {
                logger.info("Imposible insertar en la tabla", (Throwable)e);
            }
            catch (CreateGeometryException e) {
                logger.info("Error a\u00f1adiendo geometr\u00eda", (Throwable)e);
            }
        }
    }

    private void addFeatureToOutput(org.gvsig.fmap.geom.Geometry newGeom, Feature feat) throws DataException, CreateGeometryException {
        String[] fieldNames = this.persister.getFieldNamesWithoutGeom();
        ArrayList<String> fields = new ArrayList<String>();
        ArrayList<Object> values = new ArrayList<Object>();
        fields.add(this.nameIdField);
        values.add(this.iFeat);
        for (int j = 0; j < fieldNames.length; ++j) {
            Object obj = feat.get(fieldNames[j]);
            if (obj == null || fieldNames[j].compareTo(this.nameIdField) == 0) continue;
            fields.add(fieldNames[j]);
            values.add(obj);
        }
        this.lastEditFeature = this.persister.addFeature(newGeom, fields, values);
        ++this.iFeat;
    }

    private void addFeatureToOutput(Geometry newGeom, Feature feat) throws DataException, CreateGeometryException {
        String[] fieldNames = this.persister.getFieldNamesWithoutGeom();
        ArrayList<String> fields = new ArrayList<String>();
        ArrayList<Object> values = new ArrayList<Object>();
        fields.add(this.nameIdField);
        values.add(this.iFeat);
        for (int j = 0; j < fieldNames.length; ++j) {
            Object obj = feat.get(fieldNames[j]);
            if (obj == null || fieldNames[j].compareTo(this.nameIdField) == 0) continue;
            fields.add(fieldNames[j]);
            values.add(obj);
        }
        this.lastEditFeature = this.persister.addFeature(newGeom, fields, values);
        ++this.iFeat;
    }

    class NodeTree {
        public Element element = null;
        public int pos = 0;
        public NodeTree parent = null;

        public NodeTree(Element node, NodeTree parent) {
            this.element = node;
            this.parent = parent;
        }

        public Element getNext() {
            if (this.pos < this.element.overlapList.size()) {
                return this.element.overlapList.get(this.pos++);
            }
            return null;
        }
    }

    class Element {
        public int id = -1;
        public Feature feat = null;
        public List<Element> overlapList = new ArrayList<Element>();
        public boolean insertedToJoin = false;
        public Geometry jtsGeom = null;

        Element() {
        }

        public void finalize() throws Throwable {
            super.finalize();
            this.overlapList.clear();
        }
    }
}

