/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.json;

import java.io.IOException;
import java.io.Reader;
import org.gvsig.fmap.dal.FileHelper;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.resource.spi.ResourceConsumer;
import org.gvsig.fmap.dal.spi.DataStoreProviderServices;
import org.gvsig.fmap.dal.store.json.JsonFeatureTypeLoader;
import org.gvsig.fmap.dal.store.json.JsonStoreParameters;
import org.gvsig.fmap.dal.store.json.simplereaders.JsonReader;
import org.gvsig.fmap.dal.store.simplereader.SimpleReaderFeatureTypeLoader;
import org.gvsig.fmap.dal.store.simplereader.SimpleReaderStoreParameters;
import org.gvsig.fmap.dal.store.simplereader.SimpleReaderStoreProvider;
import org.gvsig.fmap.dal.store.simplereader.simplereaders.SimpleReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonStoreProvider
extends SimpleReaderStoreProvider
implements ResourceConsumer {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonStoreProvider.class);
    public static final String NAME = "Json";
    public static final String DESCRIPTION = "Json file";
    public static final String METADATA_DEFINITION_NAME = "Json";

    public JsonStoreProvider(JsonStoreParameters parameters, DataStoreProviderServices storeServices) throws InitializeException {
        super((SimpleReaderStoreParameters)parameters, storeServices, FileHelper.newMetadataContainer((String)"Json"));
    }

    private JsonStoreParameters getJsonParameters() {
        return (JsonStoreParameters)this.getParameters();
    }

    public String getProviderName() {
        return "Json";
    }

    protected SimpleReader getSimpleReader(SimpleReaderStoreParameters parameters, Reader in) throws IOException {
        JsonReader reader = new JsonReader(in, (JsonStoreParameters)parameters);
        return reader;
    }

    protected SimpleReaderFeatureTypeLoader getFeatureTypeLoader() {
        return new JsonFeatureTypeLoader(this.getJsonParameters());
    }
}

