/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.wmts.ogc.impl.base;

import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.compat.net.ICancellable;
import org.gvsig.downloader.DownloaderLocator;
import org.gvsig.downloader.DownloaderManager;
import org.gvsig.raster.wmts.ogc.WMTSClient;
import org.gvsig.raster.wmts.ogc.WMTSStatus;
import org.gvsig.raster.wmts.ogc.exception.DownloadException;
import org.gvsig.raster.wmts.ogc.exception.ServerErrorException;
import org.gvsig.raster.wmts.ogc.exception.WMTSException;
import org.gvsig.raster.wmts.ogc.impl.base.WMTSProtocolHandler;
import org.gvsig.raster.wmts.ogc.impl.base.WMTSProtocolHandlerFactory;
import org.gvsig.raster.wmts.ogc.impl.base.WMTSServerDescription;
import org.gvsig.raster.wmts.ogc.impl.base.WMTSStatusImpl;
import org.gvsig.raster.wmts.ogc.impl.struct.WMTSLayerImpl;
import org.gvsig.raster.wmts.ogc.impl.struct.WMTSServiceProviderImpl;
import org.gvsig.raster.wmts.ogc.struct.WMTSLayer;
import org.gvsig.raster.wmts.ogc.struct.WMTSServiceIdentification;
import org.gvsig.raster.wmts.ogc.struct.WMTSStyle;
import org.gvsig.raster.wmts.ogc.struct.WMTSThemes;
import org.gvsig.raster.wmts.ogc.struct.WMTSTileMatrixSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WMTSClientImpl
implements WMTSClient {
    protected String hostName;
    protected int port;
    protected String serviceName;
    private String type;
    private String subtype;
    private WMTSProtocolHandler handler = null;
    private WMTSServerDescription serverDescription = null;
    protected boolean forceChangeAxisOrder = false;
    private Logger logger = LoggerFactory.getLogger((String)WMTSClientImpl.class.toString());

    public WMTSClientImpl(String host) throws ConnectException, IOException {
        this.setHost(host);
        this.getHandler();
    }

    private WMTSProtocolHandler getHandler() throws ConnectException, IOException {
        if (this.handler == null && this.getHost().trim().length() > 0) {
            this.handler = WMTSProtocolHandlerFactory.negotiate(this.getHost());
            this.handler.setHost(this.getHost());
        }
        return this.handler;
    }

    public void setForceChangeAxisOrder(boolean force) {
        this.forceChangeAxisOrder = force;
        if (this.handler != null) {
            this.handler.setForceChangeAxisOrder(force);
        }
    }

    public String getVersion() {
        return this.handler.getVersion();
    }

    public List<WMTSLayer> getLayers() {
        if (this.serverDescription != null) {
            return this.serverDescription.getLayerList();
        }
        return null;
    }

    public int getNumberOfLayers() {
        if (this.serverDescription != null) {
            return this.serverDescription.getLayerList().size();
        }
        return 0;
    }

    public void close() {
        this.serverDescription = null;
        this.handler = null;
    }

    public File getTile(String url, ICancellable cancel, File file) throws WMTSException, ServerErrorException {
        return this.handler.getTile(url, cancel, file);
    }

    public synchronized File getTile(WMTSStatus status, ICancellable cancel, File file) throws WMTSException, ServerErrorException {
        return this.handler.getTile((WMTSStatusImpl)status, cancel, file);
    }

    public synchronized File getTile(WMTSStatus status, ICancellable cancel) throws WMTSException, ServerErrorException {
        return this.handler.getTile((WMTSStatusImpl)status, cancel);
    }

    public synchronized URL getTileURL(WMTSStatus status) throws MalformedURLException {
        return this.handler.getTileURL((WMTSStatusImpl)status);
    }

    public synchronized File downloadFile(URL url, ICancellable cancel) throws DownloadException {
        return this.handler.downloadFile(url, cancel, null);
    }

    public void getCapabilities(WMTSServerDescription serverDescription, boolean override, ICancellable cancel) {
        this.handler.getCapabilities(serverDescription, override, cancel);
    }

    public String getFeatureInfo(WMTSStatus status, int x, int y, ICancellable cancel) {
        return this.handler.getFeatureInfo((WMTSStatusImpl)status, x, y, cancel);
    }

    public File getLegendGraphic(WMTSLayer layer, WMTSStyle style, ICancellable cancel) throws WMTSException {
        try {
            return this.handler.getLegendGraphic(layer, style, cancel);
        }
        catch (ServerErrorException e) {
            throw new WMTSException("Error getting the legend", (Throwable)e);
        }
        catch (DownloadException e) {
            throw new WMTSException("Error downloading the legend", (Throwable)e);
        }
    }

    public boolean connect(boolean override, ICancellable cancel) {
        try {
            if (this.getHandler() == null) {
                return false;
            }
            this.serverDescription = this.getHandler().getServerDescription();
            this.getCapabilities(this.serverDescription, override, cancel);
            this.propageCredentials();
            return true;
        }
        catch (Exception e) {
            this.logger.debug("Error connecting to the server", (Throwable)e);
            return false;
        }
    }

    private void propageCredentials() throws IOException {
        DownloaderManager downloader = DownloaderLocator.getDownloaderManager();
        String url = this.getHost();
        WMTSServerDescription theServerDescription = this.getHandler().getServerDescription();
        Hashtable<String, String> operations = theServerDescription.getOperationsMetadata().getSupportedOperationsByName();
        HashSet<String> servicesUrls = new HashSet<String>(operations.values());
        for (WMTSLayer layer : theServerDescription.getLayerList()) {
            for (WMTSStyle style : layer.getStyle()) {
                String serviceUrl = style.getLegendURL().getHref();
                if (!StringUtils.isNotBlank((CharSequence)serviceUrl)) continue;
                servicesUrls.add(serviceUrl);
            }
        }
        downloader.propagateCredentials(url, servicesUrls);
    }

    public boolean connect(ICancellable cancel) {
        return this.connect(false, cancel);
    }

    public List<String> getFormats(String layerTitle) {
        if (this.serverDescription != null) {
            return this.serverDescription.getLayerByTitle(layerTitle).getFormat();
        }
        return null;
    }

    public WMTSServiceIdentification getServiceIdentification() {
        if (this.serverDescription != null) {
            return this.serverDescription.getServiceIdentification();
        }
        return null;
    }

    public WMTSServiceProviderImpl getServiceProvider() {
        if (this.serverDescription != null) {
            return this.serverDescription.getServiceProvider();
        }
        return null;
    }

    public WMTSThemes getThemes() {
        if (this.serverDescription != null) {
            return this.serverDescription.getThemes();
        }
        return null;
    }

    public WMTSThemes getLayerListAsThemes() {
        if (this.serverDescription != null) {
            return this.serverDescription.getLayerListAsThemes();
        }
        return null;
    }

    public List<WMTSTileMatrixSet> getTileMatrixSet() {
        if (this.serverDescription != null) {
            return this.serverDescription.getTileMatrixSet();
        }
        return null;
    }

    public WMTSLayer getLayer(String layerName) {
        if (this.serverDescription != null) {
            List<WMTSLayer> list = this.serverDescription.getLayerList();
            for (int i = 0; i < list.size(); ++i) {
                WMTSLayerImpl layer = (WMTSLayerImpl)list.get(i);
                if (layer.getTitle().compareTo(layerName) != 0) continue;
                return layer;
            }
        }
        return null;
    }

    public String getHost() {
        return this.hostName;
    }

    public void setHost(String _hostName) {
        this.hostName = _hostName;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int _port) {
        this.port = _port;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String _serviceName) {
        this.serviceName = _serviceName;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String _type) {
        this.type = _type;
    }

    public String getSubtype() {
        return this.subtype;
    }

    public void setSubtype(String _subtype) {
        this.subtype = _subtype;
    }

    public WMTSStatus createStatus() {
        return new WMTSStatusImpl();
    }
}

