/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.wmts.ogc.impl.struct;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.crs.CRSFactory;
import org.gvsig.raster.wmts.ogc.impl.struct.WMTSBaseStruct;
import org.gvsig.raster.wmts.ogc.impl.struct.WMTSTileImpl;
import org.gvsig.raster.wmts.ogc.struct.WMTSTile;
import org.gvsig.raster.wmts.ogc.struct.WMTSTileMatrix;
import org.gvsig.raster.wmts.ogc.struct.WMTSTileMatrixLimits;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;

public abstract class WMTSTileMatrixImpl
extends WMTSBaseStruct
implements WMTSTileMatrix {
    private double scaleDenominator = 0.0;
    private Rectangle2D bboxTileMatrixSet = null;
    private double[] topLeftCorner = null;
    private int tileWidth = 0;
    private int tileHeight = 0;
    private long matrixWidth = 0L;
    private long matrixHeight = 0L;
    private static final double MTS_X_GRADO = 111319.490793274;
    protected boolean forceChangeAxisOrder = false;
    private double epsilon = 1.0E-6;
    private String tileMatrixSetSupportedCRS = null;

    public void setForceChangeAxisOrder(boolean force) {
        this.forceChangeAxisOrder = force;
    }

    public void setSupportedCRS(String parentSupportedCRS) {
        this.tileMatrixSetSupportedCRS = parentSupportedCRS;
    }

    public String getSupportedCRS() {
        return this.tileMatrixSetSupportedCRS;
    }

    public void checkChangeAxis() {
        if (this.forceChangeAxisOrder) {
            double aux = this.topLeftCorner[0];
            this.topLeftCorner[0] = this.topLeftCorner[1];
            this.topLeftCorner[1] = aux;
            return;
        }
        if (this.tileMatrixSetSupportedCRS.contains("CRS:84") || this.tileMatrixSetSupportedCRS.contains("CRS84")) {
            return;
        }
        String epsgNumber = this.tileMatrixSetSupportedCRS.substring(this.tileMatrixSetSupportedCRS.lastIndexOf(":") + 1);
        try {
            Integer.parseInt(epsgNumber);
            IProjection projSrc = CRSFactory.getCRS((String)("EPSG:" + epsgNumber));
            if (projSrc != null && !projSrc.isProjected()) {
                double aux = this.topLeftCorner[0];
                this.topLeftCorner[0] = this.topLeftCorner[1];
                this.topLeftCorner[1] = aux;
            }
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setBBoxTileMatrixSet(Rectangle2D bbox) {
        if (this.bboxTileMatrixSet == null) {
            this.bboxTileMatrixSet = bbox;
        }
    }

    public Rectangle2D getBBoxTileMatrixSet() {
        return this.bboxTileMatrixSet;
    }

    public abstract void parse(KXmlParser var1, List<WMTSTileMatrix> var2) throws IOException, XmlPullParserException;

    public double getScaleDenominator() {
        return this.scaleDenominator;
    }

    public void setScaleDenominator(double scaleDenominator) {
        this.scaleDenominator = scaleDenominator;
    }

    public int getTileWidth() {
        return this.tileWidth;
    }

    public void setTileWidth(int tileWidth) {
        this.tileWidth = tileWidth;
    }

    public int getTileHeight() {
        return this.tileHeight;
    }

    public void setTileHeight(int tileHeight) {
        this.tileHeight = tileHeight;
    }

    public long getMatrixWidth() {
        return this.matrixWidth;
    }

    public void setMatrixWidth(long matrixWidth) {
        this.matrixWidth = matrixWidth;
    }

    public long getMatrixHeight() {
        return this.matrixHeight;
    }

    public void setMatrixHeight(long matrixHeight) {
        this.matrixHeight = matrixHeight;
    }

    public double[] getTopLeftCorner() {
        if (this.topLeftCorner == null) {
            this.topLeftCorner = new double[2];
        }
        return this.topLeftCorner;
    }

    @Override
    public void parse(KXmlParser parser) throws IOException, XmlPullParserException {
    }

    public double getWidthWCTile(boolean projected) {
        double pixelSpan = 0.0;
        pixelSpan = !projected ? this.scaleDenominator * 2.8E-4 / 111319.490793274 : this.scaleDenominator * 2.8E-4;
        double w = pixelSpan * (double)this.tileWidth;
        if (w - (double)((int)w) > 1.0 - this.epsilon || w - (double)((int)w) < this.epsilon) {
            return Math.round(w);
        }
        return w;
    }

    public double getHeightWCTile(boolean projected) {
        double pixelSpan = 0.0;
        pixelSpan = !projected ? this.scaleDenominator * 2.8E-4 / 111319.490793274 : this.scaleDenominator * 2.8E-4;
        double h = pixelSpan * (double)this.tileHeight;
        if (h - (double)((int)h) > 1.0 - this.epsilon || h - (double)((int)h) < this.epsilon) {
            return Math.round(h);
        }
        return h;
    }

    public List<WMTSTile> intersects(boolean projected, WMTSTileMatrixLimits tileMatrixLimits, Rectangle2D request, Rectangle2D extentLayer) {
        double widthMtsTile = this.getWidthWCTile(projected);
        double heightMtsTile = this.getHeightWCTile(projected);
        ArrayList<WMTSTile> list = new ArrayList<WMTSTile>();
        Rectangle2D.Double r = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
        int i = 0;
        int j = 0;
        double initX = this.topLeftCorner[1] + widthMtsTile * (double)tileMatrixLimits.getMinTileCol();
        double initY = this.topLeftCorner[0] - heightMtsTile * (double)tileMatrixLimits.getMinTileRow();
        for (int row = tileMatrixLimits.getMinTileRow(); row <= tileMatrixLimits.getMaxTileRow(); ++row) {
            double uly = initY - heightMtsTile * (double)i;
            double lry = uly - heightMtsTile;
            j = 0;
            for (int col = tileMatrixLimits.getMinTileCol(); col <= tileMatrixLimits.getMaxTileCol(); ++col) {
                double ulx = initX + widthMtsTile * (double)j;
                double lrx = ulx + widthMtsTile;
                ((Rectangle2D)r).setRect(Math.min(ulx, lrx), Math.min(uly, lry), Math.abs(ulx - lrx), Math.abs(uly - lry));
                if (request.intersects(r) && r.intersects(extentLayer)) {
                    list.add(new WMTSTileImpl(this.tileWidth, this.tileHeight, row, col, ulx, uly, lrx, lry));
                }
                ++j;
            }
            ++i;
        }
        return list;
    }

    public List<WMTSTile> intersects(boolean projected, Rectangle2D request, Rectangle2D extentLayer) {
        double widthWorldCoordTile = this.getWidthWCTile(projected);
        double heightWorldCoordTile = this.getHeightWCTile(projected);
        ArrayList<WMTSTile> list = new ArrayList<WMTSTile>();
        Rectangle2D.Double r = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
        double initX = this.topLeftCorner[0];
        double initY = this.topLeftCorner[1];
        int tileInitX = 0;
        int tileInitY = 0;
        int tileEndX = (int)(this.matrixWidth - 1L);
        int tileEndY = (int)(this.matrixHeight - 1L);
        if (request.getMinX() >= initX) {
            tileInitX = (int)((request.getMinX() - initX) / widthWorldCoordTile);
        }
        if (request.getMaxY() <= initY) {
            tileInitY = (int)(Math.abs(request.getMaxY() - initY) / heightWorldCoordTile);
        }
        if (request.getMaxX() <= widthWorldCoordTile * (double)this.matrixWidth) {
            tileEndX = (int)((request.getMaxX() - initX) / widthWorldCoordTile);
        }
        if (request.getMinY() >= heightWorldCoordTile * (double)this.matrixHeight) {
            tileEndY = (int)(Math.abs(request.getMinY() - initY) / heightWorldCoordTile);
        }
        for (int row = tileInitY; row <= tileEndY; ++row) {
            double uly = initY - heightWorldCoordTile * (double)row;
            double lry = uly - heightWorldCoordTile;
            for (int col = tileInitX; col <= tileEndX; ++col) {
                double ulx = initX + widthWorldCoordTile * (double)col;
                double lrx = ulx + widthWorldCoordTile;
                ((Rectangle2D)r).setRect(Math.min(ulx, lrx), Math.min(uly, lry), Math.abs(ulx - lrx), Math.abs(uly - lry));
                if ((long)row >= this.matrixHeight || (long)col >= this.matrixWidth || !request.intersects(r) || !r.intersects(extentLayer)) continue;
                list.add(new WMTSTileImpl(this.tileWidth, this.tileHeight, row, col, ulx, uly, lrx, lry));
            }
        }
        return list;
    }

    public List<WMTSTile> contains(boolean projected, Point2D point, Rectangle2D extentLayer) {
        double widthMtsTile = this.getWidthWCTile(projected);
        double heightMtsTile = this.getHeightWCTile(projected);
        ArrayList<WMTSTile> list = new ArrayList<WMTSTile>();
        Rectangle2D.Double r = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
        int i = 0;
        int j = 0;
        double initX = this.topLeftCorner[1];
        double initY = this.topLeftCorner[0];
        int row = 0;
        while ((long)row < this.matrixHeight) {
            double uly = initY - heightMtsTile * (double)i;
            double lry = uly - heightMtsTile;
            j = 0;
            int col = 0;
            while ((long)col < this.matrixWidth) {
                double ulx = initX + widthMtsTile * (double)j;
                double lrx = ulx + widthMtsTile;
                ((Rectangle2D)r).setRect(Math.min(ulx, lrx), Math.min(uly, lry), Math.abs(ulx - lrx), Math.abs(uly - lry));
                if (r.contains(point)) {
                    list.add(new WMTSTileImpl(this.tileWidth, this.tileHeight, row, col, ulx, uly, lrx, lry));
                }
                ++j;
                ++col;
            }
            ++i;
            ++row;
        }
        return list;
    }

    public List<WMTSTile> contains(boolean projected, WMTSTileMatrixLimits tileMatrixLimits, Point2D point, Rectangle2D extentLayer) {
        double widthMtsTile = this.getWidthWCTile(projected);
        double heightMtsTile = this.getHeightWCTile(projected);
        ArrayList<WMTSTile> list = new ArrayList<WMTSTile>();
        Rectangle2D.Double r = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
        int i = 0;
        int j = 0;
        double initX = this.topLeftCorner[1] + widthMtsTile * (double)tileMatrixLimits.getMinTileCol();
        double initY = this.topLeftCorner[0] - heightMtsTile * (double)tileMatrixLimits.getMinTileRow();
        for (int row = tileMatrixLimits.getMinTileRow(); row <= tileMatrixLimits.getMaxTileRow(); ++row) {
            double uly = initY - heightMtsTile * (double)i;
            double lry = uly - heightMtsTile;
            j = 0;
            for (int col = tileMatrixLimits.getMinTileCol(); col <= tileMatrixLimits.getMaxTileCol(); ++col) {
                double ulx = initX + widthMtsTile * (double)j;
                double lrx = ulx + widthMtsTile;
                ((Rectangle2D)r).setRect(Math.min(ulx, lrx), Math.min(uly, lry), Math.abs(ulx - lrx), Math.abs(uly - lry));
                if (r.contains(point)) {
                    list.add(new WMTSTileImpl(this.tileWidth, this.tileHeight, row, col, ulx, uly, lrx, lry));
                }
                ++j;
            }
            ++i;
        }
        return list;
    }

    public void print() {
        System.out.println("   *****WMTSTileMatrix******");
        System.out.println("   scaleDenominator:" + this.getScaleDenominator());
        if (this.topLeftCorner != null) {
            System.out.println("   topLeftCorner:" + this.topLeftCorner[0] + ", " + this.topLeftCorner[1]);
        }
        System.out.println("   tileWidth:" + this.getTileWidth());
        System.out.println("   tileHeight:" + this.getTileHeight());
        System.out.println("   matrixWidth:" + this.getMatrixWidth());
        System.out.println("   matrixHeight:" + this.getMatrixHeight());
    }
}

