/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tilecache.provider;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.dal.DALFileLocator;
import org.gvsig.fmap.dal.DataServerExplorer;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.DataStoreProviderFactory;
import org.gvsig.fmap.dal.NewDataStoreParameters;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.ValidateDataParametersException;
import org.gvsig.fmap.dal.raster.NewRasterStoreParameters;
import org.gvsig.fmap.dal.raster.RasterQuery;
import org.gvsig.fmap.dal.raster.RasterSet;
import org.gvsig.fmap.dal.raster.RasterStore;
import org.gvsig.fmap.dal.raster.spi.RasterStoreProvider;
import org.gvsig.fmap.dal.serverexplorer.filesystem.spi.FilesystemServerExplorerManager;
import org.gvsig.fmap.dal.serverexplorer.filesystem.spi.FilesystemServerExplorerProviderFactory;
import org.gvsig.fmap.dal.spi.DALSPILocator;
import org.gvsig.fmap.dal.spi.DataManagerProviderServices;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateEnvelopeException;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.raster.lib.buffer.api.Band;
import org.gvsig.raster.lib.buffer.api.Buffer;
import org.gvsig.raster.lib.buffer.api.BufferLocator;
import org.gvsig.raster.lib.buffer.api.BufferManager;
import org.gvsig.raster.lib.buffer.api.TileStruct;
import org.gvsig.raster.lib.buffer.api.exceptions.BufferException;
import org.gvsig.raster.lib.buffer.spi.DefaultTileStruct;
import org.gvsig.raster.tilecache.provider.AbstractTileCacheStructImage;
import org.gvsig.raster.tilecache.provider.TileCacheLibrary;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.extensionpoint.ExtensionPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FileTileCacheStructImage
extends AbstractTileCacheStructImage {
    private static final Logger logger = LoggerFactory.getLogger(FileTileCacheStructImage.class);
    private static final int MAX_RECENT_ACCEDED_TILES_NUMBER = 50;
    private FilesystemServerExplorerProviderFactory factory;
    private String extension;
    private File tilesFolder;
    private IProjection crs;

    public FileTileCacheStructImage(File folder, IProjection crs, RasterStoreProvider innerProvider, RasterQuery query) {
        super(innerProvider, query);
        this.crs = crs;
        GeometryManager geoManager = GeometryLocator.getGeometryManager();
        this.getTileStruct();
        File tilePropertiesFile = new File(folder, "tileCacheStruct.xml");
        if (!tilePropertiesFile.exists()) {
            this.createTileCacheStructXMLFile(folder);
        }
        TreeMap<Integer, Double> pixelSizePerZoomLevel = new TreeMap<Integer, Double>();
        this.recentAccededTiles = new HashMap();
        this.tilesFolder = new File(folder, "V" + File.separatorChar + "Z" + File.separatorChar + "T");
        if (!this.tilesFolder.exists()) {
            this.tilesFolder.mkdirs();
        }
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(tilePropertiesFile);
            doc.getDocumentElement().normalize();
            NodeList nList = doc.getElementsByTagName("TileCacheStruct");
            for (int temp = 0; temp < nList.getLength(); ++temp) {
                Element structExtentNode;
                Node nNode = nList.item(temp);
                if (nNode.getNodeType() != 1) continue;
                Element eElement = (Element)nNode;
                NamedNodeMap tileSizeAttributes = eElement.getElementsByTagName("tileSize").item(0).getAttributes();
                this.tileStruct.setRowsPerTile(Integer.valueOf(tileSizeAttributes.getNamedItem("rows").getNodeValue()).intValue());
                this.tileStruct.setColumnsPerTile(Integer.valueOf(tileSizeAttributes.getNamedItem("columns").getNodeValue()).intValue());
                NodeList elementsByTagName = eElement.getElementsByTagName("format");
                this.tileStruct.setProviderName(elementsByTagName.item(0).getTextContent());
                NodeList structExtentList = eElement.getElementsByTagName("structExtent");
                if (structExtentList.getLength() > 0 && (structExtentNode = (Element)structExtentList.item(0)) != null) {
                    Double minX = Double.valueOf(structExtentNode.getElementsByTagName("minX").item(0).getTextContent());
                    Double minY = Double.valueOf(structExtentNode.getElementsByTagName("minY").item(0).getTextContent());
                    Double maxX = Double.valueOf(structExtentNode.getElementsByTagName("maxX").item(0).getTextContent());
                    Double maxY = Double.valueOf(structExtentNode.getElementsByTagName("maxY").item(0).getTextContent());
                    this.tileStruct.setEnvelope(geoManager.createEnvelope(minX.doubleValue(), minY.doubleValue(), maxX.doubleValue(), maxY.doubleValue(), 0));
                }
                FilesystemServerExplorerManager explorerManager = DALFileLocator.getFilesystemServerExplorerManager();
                Iterator it = explorerManager.getRegisteredProviders();
                while (it.hasNext()) {
                    ExtensionPoint.Extension ext = (ExtensionPoint.Extension)it.next();
                    try {
                        FilesystemServerExplorerProviderFactory providerFactory = (FilesystemServerExplorerProviderFactory)ext.create();
                        if (!providerFactory.getName().equalsIgnoreCase(this.tileStruct.getProviderName())) continue;
                        this.factory = providerFactory;
                        break;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                NodeList levelsTag = eElement.getElementsByTagName("levels");
                Element levels = (Element)levelsTag.item(0);
                NodeList levelList = levels.getElementsByTagName("level");
                for (int i = 0; i < levelList.getLength(); ++i) {
                    Element level = (Element)levelList.item(i);
                    NamedNodeMap levelAttributes = level.getAttributes();
                    int zoomLevel = Integer.valueOf(levelAttributes.getNamedItem("index").getNodeValue());
                    double pixelSize = Double.valueOf(levelAttributes.getNamedItem("pixelSize").getNodeValue());
                    pixelSizePerZoomLevel.put(zoomLevel, pixelSize);
                }
                this.tileStruct.setPixelSizePerZoomLevel(pixelSizePerZoomLevel);
            }
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Band fetchTile(int bandNumber, int zoomLevel, int structRow, int structCol) {
        Band band;
        BufferManager bufferManager = BufferLocator.getBufferManager();
        String keyTile = this.composeKeyForRecentTiles(zoomLevel, structRow, structCol);
        AbstractTileCacheStructImage.Tile tile = (AbstractTileCacheStructImage.Tile)((Object)this.recentAccededTiles.get(keyTile));
        if (tile != null) {
            return tile.getBuffer().getBand(bandNumber);
        }
        Buffer rasterSet = null;
        RasterStore tileStore = null;
        RasterSet tileStoreRasterSet = null;
        Band band2 = null;
        try {
            tileStore = this.createTileStore(zoomLevel, structRow, structCol);
            tileStoreRasterSet = tileStore.getRasterSet();
            rasterSet = bufferManager.createBuffer((Buffer)tileStoreRasterSet, false);
            if (this.recentAccededTiles.size() >= 50) {
                this.removeOlderTile();
            }
            this.recentAccededTiles.put(keyTile, new AbstractTileCacheStructImage.Tile(rasterSet, keyTile));
            band = band2 = rasterSet.getBand(bandNumber);
        }
        catch (CloneNotSupportedException | DataException | ValidateDataParametersException | CreateEnvelopeException | BufferException e) {
            Band band3;
            try {
                logger.warn("Can't fetch tile: zoomLevel = " + zoomLevel + ", tileRow = " + structRow + ", tileColumn = " + structCol + ", band = " + bandNumber + ".", e);
                band3 = null;
            }
            catch (Throwable throwable) {
                DisposeUtils.dispose(tileStore);
                tileStore = null;
                DisposeUtils.dispose(tileStoreRasterSet);
                tileStoreRasterSet = null;
                DisposeUtils.dispose(rasterSet);
                rasterSet = null;
                throw throwable;
            }
            DisposeUtils.dispose((Disposable)tileStore);
            tileStore = null;
            DisposeUtils.dispose((Disposable)tileStoreRasterSet);
            tileStoreRasterSet = null;
            DisposeUtils.dispose((Disposable)rasterSet);
            rasterSet = null;
            return band3;
        }
        DisposeUtils.dispose((Disposable)tileStore);
        tileStore = null;
        DisposeUtils.dispose((Disposable)tileStoreRasterSet);
        tileStoreRasterSet = null;
        DisposeUtils.dispose((Disposable)rasterSet);
        rasterSet = null;
        return band;
    }

    private RasterStore createTileStore(int zoomLevel, int structRow, int structCol) throws ValidateDataParametersException, CreateEnvelopeException, BufferException, DataException, CloneNotSupportedException {
        File firstColumnFolder;
        File tileFile = null;
        File zoomFolder = new File(this.tilesFolder, String.valueOf(zoomLevel));
        if (!zoomFolder.exists()) {
            zoomFolder.mkdirs();
        }
        if (!(firstColumnFolder = new File(zoomFolder, String.valueOf(structCol))).exists()) {
            tileFile = this.requestTileFile(zoomLevel, structRow, structCol);
            this.extension = FilenameUtils.getExtension((String)tileFile.getAbsolutePath());
        }
        String rowBaseName = String.valueOf(structRow);
        if (this.extension == null) {
            File[] providerAcceptedFiles = firstColumnFolder.listFiles((FileFilter)this.factory);
            for (int i = 0; i < providerAcceptedFiles.length; ++i) {
                File providerAcceptedFile = providerAcceptedFiles[i];
                if (!FilenameUtils.getBaseName((String)providerAcceptedFile.getAbsolutePath()).equalsIgnoreCase(rowBaseName)) continue;
                tileFile = providerAcceptedFile;
            }
            if (tileFile == null || !tileFile.exists()) {
                tileFile = this.requestTileFile(zoomLevel, structRow, structCol);
            }
            this.extension = FilenameUtils.getExtension((String)tileFile.getAbsolutePath());
        } else if (tileFile == null) {
            tileFile = new File(firstColumnFolder.getAbsolutePath() + File.separatorChar + rowBaseName + "." + this.extension);
        }
        if (!tileFile.exists()) {
            tileFile = this.requestTileFile(zoomLevel, structRow, structCol);
        }
        RasterStore tileStore = null;
        DataManagerProviderServices manager = DALSPILocator.getDataManagerProviderServices();
        DataStoreProviderFactory providerFactory = manager.getStoreProviderFactory(this.tileStruct.getProviderName());
        DynObject params = providerFactory.createParameters();
        if (params.getDynClass().getDynField("file") != null) {
            params.setDynValue("file", (Object)tileFile);
        }
        if (params.getDynClass().getDynField("crs") != null) {
            params.setDynValue("crs", (Object)this.crs);
        }
        tileStore = (RasterStore)manager.openStore(this.tileStruct.getProviderName(), params);
        return tileStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File requestTileFile(int zoomLevel, int structRow, int structCol) throws CreateEnvelopeException, CloneNotSupportedException, BufferException, ValidateDataParametersException, DataException {
        RasterQuery rasterQuery = this.query.clone();
        Double pixelSize = (Double)this.tileStruct.getPixelSizePerZoomLevel().get(zoomLevel);
        rasterQuery.setPixelSize(pixelSize.doubleValue());
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        Envelope structExtent = this.tileStruct.getEnvelope();
        int rowsPerTile = this.tileStruct.getRowsPerTile();
        int columnsPerTile = this.tileStruct.getColumnsPerTile();
        double minX = structExtent.getMinimum(0) + (double)structCol * (pixelSize * (double)columnsPerTile);
        double minY = structExtent.getMaximum(1) - (double)(structRow + 1) * (pixelSize * (double)rowsPerTile);
        double maxX = minX + pixelSize * (double)columnsPerTile;
        double maxY = minY + pixelSize * (double)rowsPerTile;
        Envelope envelope = geomManager.createEnvelope(minX, minY, maxX, maxY, 0);
        rasterQuery.setClip(envelope);
        Buffer buffer = null;
        Buffer clippedBuffer = null;
        Buffer interpolatedBuffer = null;
        File destFile = null;
        DataServerExplorer serverExplorer = null;
        try {
            buffer = this.innerProvider.createBuffer(rasterQuery);
            clippedBuffer = buffer.clip(envelope);
            interpolatedBuffer = clippedBuffer.createInterpolated((int)Math.round(clippedBuffer.getDimensions().getPixelSizeY() * (double)clippedBuffer.getRows() / pixelSize), (int)Math.round(clippedBuffer.getDimensions().getPixelSizeX() * (double)clippedBuffer.getColumns() / pixelSize), 2, null);
            String providerName = "GTiff";
            String extension = "tif";
            DataManagerProviderServices manager = DALSPILocator.getDataManagerProviderServices();
            DataServerExplorerParameters eparams = manager.createServerExplorerParameters("FilesystemExplorer");
            destFile = FileUtils.getFile((File)this.tilesFolder, (String[])new String[]{Integer.toString(zoomLevel), Integer.toString(structCol), Integer.toString(structRow) + "." + extension});
            File parent = destFile.getParentFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
            eparams.setDynValue("initialpath", (Object)destFile);
            serverExplorer = manager.openServerExplorer(eparams.getExplorerName(), eparams);
            NewRasterStoreParameters params = (NewRasterStoreParameters)serverExplorer.getAddParameters(providerName);
            params.setDynValue("file", (Object)destFile);
            params.setDynValue("compress", (Object)"NONE");
            params.setDynValue("tfw", (Object)false);
            int bands = this.innerProvider.getBands();
            switch (bands) {
                case 3: {
                    params.setDynValue("photometric", (Object)"RGB");
                    break;
                }
                case 4: {
                    params.setDynValue("photometric", (Object)"RGB");
                    params.setDynValue("alpha", (Object)"NON-PREMULTIPLIED");
                    break;
                }
                default: {
                    params.setDynValue("photometric", (Object)"MINISBLACK");
                }
            }
            params.setBuffer(interpolatedBuffer);
            serverExplorer.add(providerName, (NewDataStoreParameters)params, true);
        }
        catch (Throwable throwable) {
            DisposeUtils.dispose(buffer);
            DisposeUtils.dispose(clippedBuffer);
            DisposeUtils.dispose(interpolatedBuffer);
            DisposeUtils.dispose(serverExplorer);
            throw throwable;
        }
        DisposeUtils.dispose((Disposable)buffer);
        DisposeUtils.dispose((Disposable)clippedBuffer);
        DisposeUtils.dispose((Disposable)interpolatedBuffer);
        DisposeUtils.dispose((Disposable)serverExplorer);
        return destFile;
    }

    @Override
    protected void doDispose() throws BaseException {
        super.doDispose();
        this.factory = null;
        this.crs = null;
        this.tilesFolder = null;
        this.extension = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTileCacheStructXMLFile(File folder) {
        block19: {
            TileStruct tileStructProvider = null;
            try {
                File file;
                if (this.innerProvider != null) {
                    tileStructProvider = this.innerProvider.getTileStruct();
                    DisposeUtils.bind((Disposable)((Disposable)tileStructProvider));
                }
                int tileSizeX = TileCacheLibrary.DEFAULT_TILEWIDTH;
                if (tileStructProvider != null && tileStructProvider.getColumnsPerTile() != 0) {
                    tileSizeX = tileStructProvider.getColumnsPerTile();
                }
                int tileSizeY = TileCacheLibrary.DEFAULT_TILEHEIGHT;
                if (tileStructProvider != null && tileStructProvider.getRowsPerTile() != 0) {
                    tileSizeY = tileStructProvider.getRowsPerTile();
                }
                if ((file = new File(folder, "tileCacheStruct.xml")).exists()) break block19;
                Buffer auxBuffer = null;
                try {
                    DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
                    Document doc = docBuilder.newDocument();
                    Element rootElement = doc.createElement("TileCacheStruct");
                    doc.appendChild(rootElement);
                    Element tileSize = doc.createElement("tileSize");
                    rootElement.appendChild(tileSize);
                    Attr rows = doc.createAttribute("rows");
                    rows.setValue(String.valueOf(tileSizeY));
                    tileSize.setAttributeNode(rows);
                    Attr columns = doc.createAttribute("columns");
                    columns.setValue(String.valueOf(tileSizeX));
                    tileSize.setAttributeNode(columns);
                    Element format = doc.createElement("format");
                    if (tileStructProvider == null || StringUtils.isEmpty((CharSequence)tileStructProvider.getProviderName())) {
                        format.setTextContent("GTiff");
                    }
                    rootElement.appendChild(format);
                    Element structExtent = doc.createElement("structExtent");
                    rootElement.appendChild(structExtent);
                    Envelope envelope = (Envelope)this.innerProvider.getDynValue("Envelope");
                    Element minX = doc.createElement("minX");
                    minX.setTextContent(String.valueOf(envelope.getMinimum(0)));
                    structExtent.appendChild(minX);
                    Element minY = doc.createElement("minY");
                    minY.setTextContent(String.valueOf(envelope.getMinimum(1)));
                    structExtent.appendChild(minY);
                    Element maxX = doc.createElement("maxX");
                    maxX.setTextContent(String.valueOf(envelope.getMaximum(0)));
                    structExtent.appendChild(maxX);
                    Element maxY = doc.createElement("maxY");
                    maxY.setTextContent(String.valueOf(envelope.getMaximum(1)));
                    structExtent.appendChild(maxY);
                    Element levels = doc.createElement("levels");
                    rootElement.appendChild(levels);
                    ArrayList<Double> pixelSizes = new ArrayList<Double>();
                    Map zoomLevels = new HashMap();
                    if (tileStructProvider == null || tileStructProvider.getPixelSizePerZoomLevel() == null) {
                        auxBuffer = this.innerProvider.createBuffer(null);
                        int completeRows = auxBuffer.getRows();
                        int completeColumns = auxBuffer.getColumns();
                        double completePixelSizeX = auxBuffer.getDimensions().getPixelSizeX();
                        double completePixelSizeY = auxBuffer.getDimensions().getPixelSizeY();
                        int maximumLength = completeColumns;
                        int tileMaximumLength = tileSizeX;
                        double maximumPixelSize = completePixelSizeX;
                        if (completeRows * tileSizeY > completeColumns * tileSizeX) {
                            maximumLength = completeRows;
                            tileMaximumLength = tileSizeY;
                            maximumPixelSize = completePixelSizeY;
                        }
                        double pixelSize = maximumPixelSize;
                        while ((double)maximumLength * maximumPixelSize / pixelSize > (double)tileMaximumLength) {
                            pixelSizes.add(pixelSize);
                            pixelSize *= 2.0;
                        }
                        pixelSizes.add(pixelSize);
                        int i = 0;
                        for (int zoomLevel = pixelSizes.size() - 1; zoomLevel >= 0; --zoomLevel) {
                            zoomLevels.put(i, pixelSizes.get(zoomLevel));
                            this.appendZoomLevel(doc, levels, i, (Double)pixelSizes.get(zoomLevel));
                            ++i;
                        }
                    } else {
                        zoomLevels = tileStructProvider.getPixelSizePerZoomLevel();
                    }
                    for (Map.Entry entry : zoomLevels.entrySet()) {
                        this.appendZoomLevel(doc, levels, (Integer)entry.getKey(), (Double)entry.getValue());
                    }
                    DOMSource source = new DOMSource(doc);
                    File parent = file.getParentFile();
                    if (!parent.exists()) {
                        parent.mkdirs();
                    }
                    file.createNewFile();
                    StreamResult result = new StreamResult(file.toURI().getPath());
                    TransformerFactory transformerFactory = TransformerFactory.newInstance();
                    Transformer transformer = transformerFactory.newTransformer();
                    transformer.setOutputProperty("indent", "yes");
                    transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
                    transformer.transform(source, result);
                    DisposeUtils.dispose((Disposable)auxBuffer);
                    auxBuffer = null;
                }
                catch (IOException | ParserConfigurationException | TransformerException | BufferException e) {
                    logger.warn("Can't create tileCacheStruct.xml file", e);
                }
                finally {
                    DisposeUtils.dispose(auxBuffer);
                    auxBuffer = null;
                }
            }
            finally {
                DisposeUtils.disposeQuietly((Disposable)((Disposable)tileStructProvider));
                tileStructProvider = null;
            }
        }
    }

    private void appendZoomLevel(Document doc, Element levels, int zoomLevel, double pixelSize) {
        Element level = doc.createElement("level");
        levels.appendChild(level);
        Attr index = doc.createAttribute("index");
        index.setValue(String.valueOf(zoomLevel));
        level.setAttributeNode(index);
        Attr pxSize = doc.createAttribute("pixelSize");
        pxSize.setValue(String.valueOf(pixelSize));
        level.setAttributeNode(pxSize);
    }

    @Override
    public TileStruct getTileStruct() {
        if (this.tileStruct == null) {
            this.tileStruct = new DefaultTileStruct();
        }
        return this.tileStruct;
    }

    @Override
    public void forgetCache() {
        super.forgetCache();
        if (this.tilesFolder.exists() && this.tilesFolder.isDirectory()) {
            File[] files = this.tilesFolder.listFiles();
            for (int i = 0; i < files.length; ++i) {
                try {
                    FileUtils.forceDelete((File)files[i]);
                    continue;
                }
                catch (IOException e) {
                    logger.warn("Can't delete the file " + files[i].getAbsolutePath(), (Throwable)e);
                }
            }
        }
    }
}

