/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.algorithm.swing.impl.layerdatatype;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.util.EventListener;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.algorithm.BasicAPISwingPanel;
import org.gvsig.raster.algorithm.process.DataProcess;
import org.gvsig.raster.algorithm.process.ProcessException;
import org.gvsig.raster.swing.RasterSwingLocator;
import org.gvsig.raster.swing.newlayer.CreateNewLayerPanel;
import org.gvsig.raster.tools.algorithm.layerdatatype.LayerDatatypeProcess;

public class LayerDatatypePanelImpl
extends JPanel
implements BasicAPISwingPanel {
    private static final long serialVersionUID = 1L;
    private JComboBox comboOutput = null;
    private JComboBox comboDec2Int = null;
    private JComboBox comboBig2Small = null;
    private String inputDatatype = null;
    private String layerName = null;
    private CreateNewLayerPanel newLayerPanel = null;
    private Object inputStore = null;

    public LayerDatatypePanelImpl(Object inputStore, String inputDatatype, String layerName) {
        this.inputStore = inputStore;
        this.layerName = layerName;
        this.inputDatatype = inputDatatype;
        this.init();
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.insets = new Insets(0, 0, 2, 0);
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 0;
        this.add((Component)this.getLayerPanel(), gridBagConstraints1);
        gridBagConstraints1.gridy = 1;
        this.add((Component)this.getInputsPanel(), gridBagConstraints1);
        gridBagConstraints1.insets = new Insets(0, 2, 0, 2);
        gridBagConstraints1.gridy = 2;
        this.add((Component)((JComponent)this.getCreateNewLayerPanel()), gridBagConstraints1);
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.weighty = 1.0;
        gridBagConstraints1.gridy = 3;
        this.add((Component)new JPanel(), gridBagConstraints1);
    }

    private JPanel getLayerPanel() {
        JPanel p = new JPanel();
        p.setBorder(BorderFactory.createTitledBorder(Messages.getText((String)"layer")));
        p.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.insets = new Insets(0, 0, 2, 0);
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 0;
        p.add((Component)new JLabel(this.layerName), gridBagConstraints1);
        return p;
    }

    private JPanel getInputsPanel() {
        JPanel p = new JPanel();
        p.setBorder(BorderFactory.createTitledBorder(Messages.getText((String)"datatype")));
        p.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.insets = new Insets(0, 0, 2, 0);
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 0;
        p.add((Component)new JLabel(Messages.getText((String)"entrada")), gridBagConstraints1);
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 0;
        p.add((Component)new JLabel(this.inputDatatype), gridBagConstraints1);
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 1;
        p.add((Component)new JLabel(Messages.getText((String)"salida")), gridBagConstraints1);
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 1;
        p.add((Component)this.getComboOutput(), gridBagConstraints1);
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 2;
        p.add((Component)new JLabel(Messages.getText((String)"adjust_dec2int")), gridBagConstraints1);
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 2;
        p.add((Component)this.getComboDec2Int(), gridBagConstraints1);
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 3;
        p.add((Component)new JLabel(Messages.getText((String)"adjust_big2small")), gridBagConstraints1);
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 3;
        p.add((Component)this.getComboBig2Small(), gridBagConstraints1);
        return p;
    }

    public JComponent getComponent() {
        return this;
    }

    public DataProcess getResult() throws ProcessException {
        LayerDatatypeProcess task = new LayerDatatypeProcess();
        task.addParam(LayerDatatypeProcess.RASTER_STORE1, this.inputStore);
        String filename = this.newLayerPanel.getDirectorySelected() + File.separator + this.newLayerPanel.getFileSelected();
        if (!filename.endsWith(".tif")) {
            filename = filename + ".tif";
        }
        task.addParam(LayerDatatypeProcess.PATH, (Object)filename);
        task.addParam(LayerDatatypeProcess.DATATYPE, (Object)this.getDatatypeFromCombo());
        task.addParam(LayerDatatypeProcess.ADJUST_DEC2INT, (Object)this.getComboDec2Int().getSelectedIndex());
        task.addParam(LayerDatatypeProcess.ADJUST_BIG2SMALL, (Object)this.getComboBig2Small().getSelectedIndex());
        return task;
    }

    public JComboBox getComboOutput() {
        if (this.comboOutput == null) {
            this.comboOutput = new JComboBox();
            this.comboOutput.addItem("BYTE");
            this.comboOutput.addItem("SHORT");
            this.comboOutput.addItem("INT");
            this.comboOutput.addItem("FLOAT");
            this.comboOutput.addItem("DOUBLE");
        }
        return this.comboOutput;
    }

    private int getDatatypeFromCombo() {
        String item = (String)this.getComboOutput().getSelectedItem();
        if (item.equals("BYTE")) {
            return 0;
        }
        if (item.equals("SHORT")) {
            return 2;
        }
        if (item.equals("INT")) {
            return 3;
        }
        if (item.equals("FLOAT")) {
            return 4;
        }
        if (item.equals("DOUBLE")) {
            return 5;
        }
        return -1;
    }

    public JComboBox getComboDec2Int() {
        if (this.comboDec2Int == null) {
            this.comboDec2Int = new JComboBox();
            for (int i = 0; i < LayerDatatypeProcess.DEC2INT_OPTIONS.length; ++i) {
                this.comboDec2Int.addItem(LayerDatatypeProcess.DEC2INT_OPTIONS[i]);
            }
        }
        return this.comboDec2Int;
    }

    public JComboBox getComboBig2Small() {
        if (this.comboBig2Small == null) {
            this.comboBig2Small = new JComboBox();
            for (int i = 0; i < LayerDatatypeProcess.BIG2SMALL_OPTIONS.length; ++i) {
                this.comboBig2Small.addItem(LayerDatatypeProcess.BIG2SMALL_OPTIONS[i]);
            }
        }
        return this.comboBig2Small;
    }

    public CreateNewLayerPanel getCreateNewLayerPanel() {
        if (this.newLayerPanel == null) {
            this.newLayerPanel = RasterSwingLocator.getSwingManager().createNewLayerPanel();
        }
        return this.newLayerPanel;
    }

    public void initialize() {
    }

    public int getComponentIDByObject(Object obj) {
        return -1;
    }

    public void addListener(EventListener listener) {
    }
}

