/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.daltransform.swing.impl;

import java.util.List;
import jwizardcomponent.FinishAction;
import jwizardcomponent.JWizardComponents;
import jwizardcomponent.JWizardPanel;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.andami.ui.wizard.WizardAndami;
import org.gvsig.daltransform.swing.DataTransformGui;
import org.gvsig.daltransform.swing.DataTransformWizard;
import org.gvsig.daltransform.swing.DataTransformWizardPanel;
import org.gvsig.daltransform.swing.impl.DataTransformSelectionAction;
import org.gvsig.daltransform.swing.impl.DataTransformWizardContainer;
import org.gvsig.daltransform.swing.impl.LoadLayerWizardPanel;
import org.gvsig.daltransform.swing.impl.SelectDataStoreWizardPanel;
import org.gvsig.daltransform.swing.impl.SelectTransformWizardPanel;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.mapcontext.MapContext;

public class DefaultDataTransformWizard
extends WizardAndami
implements DataTransformWizard {
    private static final long serialVersionUID = 8346790424453722486L;
    private List<DataTransformWizardPanel> transformWizardPanels = null;
    private LoadLayerWizardPanel loadLayerWizardPanel = new LoadLayerWizardPanel();
    private SelectDataStoreWizardPanel selectDataStoreWizardPanel = new SelectDataStoreWizardPanel();
    private SelectTransformWizardPanel selectTransformWizardPanel = new SelectTransformWizardPanel();
    private DataTransformGui dataTransformGui = null;
    private int PANELS_TO_REFRESH = 2;

    public DefaultDataTransformWizard() {
        super(IconThemeHelper.getImageIcon((String)"feature-transform-wizard"));
        this.initialize();
        this.setSize(this.selectTransformWizardPanel.getMaxHeight(), this.selectTransformWizardPanel.getMaxWidth());
    }

    private void initialize() {
        this.getWizardComponents().getFinishButton().setEnabled(false);
        this.getWizardComponents().getBackButton().setEnabled(false);
        this.getWindowInfo().setTitle(PluginServices.getText((Object)this, (String)"transform_wizard"));
        this.addDataTransformWizardPanel(this.selectTransformWizardPanel);
        this.addDataTransformWizardPanel(this.selectDataStoreWizardPanel);
        this.getWizardComponents().setFinishAction((FinishAction)new DataTransformSelectionAction(this));
    }

    @Override
    public void setApplicable(boolean isEnabled) {
        this.getWizardComponents().getNextButton().setEnabled(isEnabled);
    }

    @Override
    public DataTransformGui getDataTransformGui() {
        if (this.dataTransformGui == null) {
            return this.selectTransformWizardPanel.getFeatureTransformGui();
        }
        return this.dataTransformGui;
    }

    public void updateGui() {
        int i;
        for (i = this.getWizardComponents().getWizardPanelList().size() - 1; i >= this.PANELS_TO_REFRESH; --i) {
            this.getWizardComponents().removeWizardPanel(i);
        }
        this.transformWizardPanels = this.getDataTransformGui().createPanels();
        for (i = 0; i < this.transformWizardPanels.size(); ++i) {
            this.addDataTransformWizardPanel(this.transformWizardPanels.get(i));
        }
        this.addDataTransformWizardPanel(this.loadLayerWizardPanel);
    }

    public void addDataTransformWizardPanel(DataTransformWizardPanel dataTransformWizardPanel) {
        dataTransformWizardPanel.setDataTransformWizard(this);
        this.getWizardComponents().addWizardPanel((JWizardPanel)new DataTransformWizardContainer((JWizardComponents)this.getWizardComponents(), dataTransformWizardPanel));
    }

    @Override
    public FeatureStore getFeatureStore() {
        return this.selectDataStoreWizardPanel.getFeatureStore();
    }

    @Override
    public boolean isFeatureStoreLayer() {
        return this.selectDataStoreWizardPanel.isFeatureStoreLayer();
    }

    public boolean isLayerLoaded() {
        return this.loadLayerWizardPanel.isLayerLoaded();
    }

    public MapContext getMapContext() {
        return this.loadLayerWizardPanel.getMapContext();
    }

    @Override
    public IWindow getWindow() {
        return this;
    }

    @Override
    public void setDataTransformGui(DataTransformGui dataTransformGui) {
        this.dataTransformGui = dataTransformGui;
        this.PANELS_TO_REFRESH = 1;
        this.getWizardComponents().removeWizardPanel(0);
        this.selectDataStoreWizardPanel.updatePanel();
    }
}

