/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.daltransform.swing.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.project.ProjectManager;
import org.gvsig.app.project.documents.Document;
import org.gvsig.app.project.documents.view.BaseViewDocument;
import org.gvsig.app.project.documents.view.ViewManager;
import org.gvsig.app.project.documents.view.gui.IView;
import org.gvsig.daltransform.swing.DataTransformGui;
import org.gvsig.daltransform.swing.impl.AbstractDataTransformWizardPanel;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureStoreTransform;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.mapcontext.MapContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadLayerWizardPanel
extends AbstractDataTransformWizardPanel
implements ItemListener {
    private static final long serialVersionUID = -7893735055404404591L;
    private static final Logger logger = LoggerFactory.getLogger(LoadLayerWizardPanel.class);
    private JCheckBox loadLayerCb = null;
    private JScrollPane messageScroll = null;
    private JTextArea messageTextArea = null;
    private JPanel northPanel = null;
    private JLabel selectViewLabel;
    private JComboBox selectViewCombo;
    private JPanel centerPanel;
    private FeatureStoreTransform transform = null;

    public LoadLayerWizardPanel() {
        this.initComponents();
        this.initLabels();
        this.addViews();
        this.loadLayerCb.addItemListener(this);
        this.loadLayerCb.setSelected(true);
        this.selectViewLabel.setEnabled(true);
        this.selectViewCombo.setEnabled(true);
    }

    private void initLabels() {
        this.loadLayerCb.setText(PluginServices.getText((Object)this, (String)"transform_load_layer_query"));
        this.selectViewLabel.setText(PluginServices.getText((Object)this, (String)"transform_view_to_load"));
    }

    private void initComponents() {
        this.northPanel = new JPanel();
        this.messageScroll = new JScrollPane();
        this.messageTextArea = new JTextArea();
        this.loadLayerCb = new JCheckBox();
        this.selectViewLabel = new JLabel();
        this.centerPanel = new JPanel();
        this.selectViewCombo = new JComboBox();
        this.setLayout(new BorderLayout());
        this.northPanel.setLayout(new GridBagLayout());
        this.messageScroll.setBorder(null);
        this.messageTextArea.setColumns(20);
        this.messageTextArea.setEditable(false);
        this.messageTextArea.setLineWrap(true);
        this.messageTextArea.setWrapStyleWord(true);
        this.messageTextArea.setBackground(this.northPanel.getBackground());
        Font fnt = this.messageTextArea.getFont();
        fnt = fnt.deriveFont(0);
        this.messageTextArea.setFont(fnt);
        this.messageTextArea.setRows(5);
        this.messageTextArea.setBorder(null);
        this.messageScroll.setViewportView(this.messageTextArea);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 5, 2);
        this.northPanel.add((Component)this.messageScroll, gridBagConstraints);
        this.loadLayerCb.setText("jCheckBox1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 2, 2, 2);
        this.northPanel.add((Component)this.loadLayerCb, gridBagConstraints);
        this.add((Component)this.northPanel, "North");
        this.centerPanel.setLayout(new GridBagLayout());
        this.selectViewLabel.setText("jLabel1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 2, 5, 2);
        this.centerPanel.add((Component)this.selectViewLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 2, 2, 2);
        this.centerPanel.add((Component)this.selectViewCombo, gridBagConstraints);
        this.add((Component)this.centerPanel, "Center");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updatePanel() {
        DataTransformGui featureTransformGui = this.getDataTransformWizard().getDataTransformGui();
        FeatureStore featureStore = this.getFeatureStore();
        try {
            this.transform = featureTransformGui.createFeatureStoreTransform(featureStore);
            featureStore.getTransforms().add(this.transform);
            if (this.getDataTransformWizard().isFeatureStoreLayer()) {
                this.updateGuiForLayer(this.transform);
            } else {
                this.updateGuiForTable(this.transform);
            }
        }
        catch (DataException e) {
            logger.error("Error creating the transformation", (Throwable)e);
        }
        finally {
            if (this.transform != null) {
                featureStore.getTransforms().remove(this.transform);
            }
        }
    }

    private void updateGuiForTable(FeatureStoreTransform transform) throws DataException {
        FeatureType featureType = transform.getDefaultFeatureType();
        FeatureAttributeDescriptor[] featureAttributeDescriptors = featureType.getAttributeDescriptors();
        boolean hasGeometry = false;
        for (int i = 0; i < featureAttributeDescriptors.length; ++i) {
            if (featureAttributeDescriptors[i].getType() != 66) continue;
            hasGeometry = true;
        }
        if (hasGeometry) {
            if (this.selectViewCombo.getItemCount() == 0) {
                this.messageTextArea.setText(PluginServices.getText((Object)this, (String)"transform_layout_not_view_to_load"));
                this.setLoadLayerVisible(false);
            } else {
                this.messageTextArea.setText(PluginServices.getText((Object)this, (String)"transform_layout_geometry"));
                this.setLoadLayerVisible(true);
            }
        } else {
            this.messageTextArea.setText(PluginServices.getText((Object)this, (String)"transform_layout_no_geometry"));
            this.setLoadLayerVisible(false);
        }
    }

    private void setLoadLayerVisible(boolean isVisible) {
        this.loadLayerCb.setVisible(isVisible);
        this.selectViewLabel.setVisible(isVisible);
        this.selectViewCombo.setVisible(isVisible);
    }

    private void addViews() {
        this.selectViewCombo.removeAllItems();
        List views = ProjectManager.getInstance().getCurrentProject().getDocuments(ViewManager.TYPENAME);
        for (Document view : views) {
            this.selectViewCombo.addItem(view);
        }
        IWindow window = PluginServices.getMDIManager().getActiveWindow();
        if (window instanceof IView) {
            this.selectViewCombo.setSelectedItem(window);
        }
    }

    @Override
    public boolean isNextButtonEnabled() {
        return true;
    }

    private void updateGuiForLayer(FeatureStoreTransform transform) {
        this.messageTextArea.setText(PluginServices.getText((Object)this, (String)"transform_layer"));
        this.setLoadLayerVisible(false);
    }

    public boolean isLayerLoaded() {
        if (!this.loadLayerCb.isVisible()) {
            return false;
        }
        return this.loadLayerCb.isSelected();
    }

    public FeatureStoreTransform getTransform() {
        return this.transform;
    }

    public MapContext getMapContext() {
        Object obj = this.selectViewCombo.getSelectedItem();
        if (obj != null) {
            return ((BaseViewDocument)obj).getMapContext();
        }
        return null;
    }

    @Override
    public void itemStateChanged(ItemEvent arg0) {
        boolean isSelected = this.loadLayerCb.isSelected();
        this.selectViewLabel.setEnabled(isSelected);
        this.selectViewCombo.setEnabled(isSelected);
    }

    @Override
    public String getPanelTitle() {
        return PluginServices.getText((Object)this, (String)"transform_apply");
    }
}

