/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.prov.smoothline;

import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.primitive.Line;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.vectorediting.lib.prov.smoothline.ControlCurve;

public class BSpline
extends ControlCurve {
    public BSpline(Line line) {
        super(line);
    }

    float b(int i, float t) {
        switch (i) {
            case -2: {
                return (((-t + 3.0f) * t - 3.0f) * t + 1.0f) / 6.0f;
            }
            case -1: {
                return ((3.0f * t - 6.0f) * t * t + 4.0f) / 6.0f;
            }
            case 0: {
                return (((-3.0f * t + 3.0f) * t + 3.0f) * t + 1.0f) / 6.0f;
            }
            case 1: {
                return t * t * t / 6.0f;
            }
        }
        return 0.0f;
    }

    private Point p(int i, float t, int subtype) throws CreateGeometryException {
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        float px = 0.0f;
        float py = 0.0f;
        for (int j = -2; j <= 1; ++j) {
            px = (float)((double)px + (double)this.b(j, t) * this.m_X[i + j]);
            py = (float)((double)py + (double)this.b(j, t) * this.m_Y[i + j]);
        }
        return geomManager.createPoint((double)Math.round(px), (double)Math.round(py), subtype);
    }

    @Override
    public Line getSmoothedLine(int iSteps, int subtype) throws CreateGeometryException {
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        Line smoothedLine = geomManager.createLine(subtype);
        Point q = this.p(2, 0.0f, subtype);
        smoothedLine.addVertex(q.getX(), q.getY());
        for (int i = 2; i < this.m_X.length - 1; ++i) {
            for (int j = 1; j <= iSteps; ++j) {
                q = this.p(i, (float)j / (float)iSteps, subtype);
                smoothedLine.addVertex(q);
            }
        }
        return smoothedLine;
    }
}

