/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.css;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import org.fit.cssbox.css.Output;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NormalOutput
extends Output {
    private boolean filterStyles = true;

    public NormalOutput(Node root) {
        super(root);
    }

    public NormalOutput(Node root, boolean filterStyles) {
        super(root);
        this.filterStyles = filterStyles;
    }

    @Override
    public void dumpTo(OutputStream out) {
        PrintWriter writer;
        try {
            writer = new PrintWriter(new OutputStreamWriter(out, "utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            writer = new PrintWriter(out);
        }
        this.recursiveDump(this.root, 0, writer);
        writer.close();
    }

    @Override
    public void dumpTo(PrintWriter writer) {
        this.recursiveDump(this.root, 0, writer);
    }

    private void recursiveDump(Node n, int level, PrintWriter p) {
        if (n.getNodeType() == 1) {
            String tag = "";
            Element el = (Element)n;
            if (this.filterStyles) {
                if (el.getTagName().equals("style")) {
                    return;
                }
                if (el.getTagName().equals("link") && (el.getAttribute("rel").equalsIgnoreCase("stylesheet") || el.getAttribute("type").equalsIgnoreCase("text/css"))) {
                    return;
                }
            }
            if (el.getTagName().equals("meta") && el.getAttribute("name").equals("generator")) {
                el.setAttribute("content", "CSS Transformer by Radek Burget, burgetr@fit.vutbr.cz");
            }
            if (el.getTagName().equals("meta") && el.getAttribute("http-equiv").equalsIgnoreCase("content-type")) {
                el.setAttribute("content", "text/html; charset=utf-8");
            }
            tag = tag + "<" + el.getTagName();
            NamedNodeMap attrs = el.getAttributes();
            for (int i = 0; i < attrs.getLength(); ++i) {
                Node attr = attrs.item(i);
                tag = tag + " " + attr.getNodeName() + "=\"" + attr.getNodeValue() + "\"";
            }
            tag = tag + ">";
            p.print(tag);
        } else if (n.getNodeType() == 3) {
            p.print(n.getNodeValue());
        }
        NodeList child = n.getChildNodes();
        for (int i = 0; i < child.getLength(); ++i) {
            this.recursiveDump(child.item(i), level + 1, p);
        }
        if (n.getNodeType() == 1) {
            p.print("</" + n.getNodeName() + ">");
        }
    }

    private void recursiveDumpNice(Node n, int level, PrintWriter p) {
        if (n.getNodeType() == 1) {
            String tag = "";
            Element el = (Element)n;
            if (el.getTagName().equals("style")) {
                return;
            }
            tag = tag + "<" + el.getTagName();
            NamedNodeMap attrs = el.getAttributes();
            for (int i = 0; i < attrs.getLength(); ++i) {
                Node attr = attrs.item(i);
                tag = tag + " " + attr.getNodeName() + "=\"" + attr.getNodeValue() + "\"";
            }
            tag = tag + ">";
            this.indent(level, p);
            p.println(tag);
        } else if (n.getNodeType() == 3) {
            this.indent(level, p);
            p.println(n.getNodeValue());
        }
        NodeList child = n.getChildNodes();
        for (int i = 0; i < child.getLength(); ++i) {
            this.recursiveDumpNice(child.item(i), level + 1, p);
        }
        if (n.getNodeType() == 1) {
            this.indent(level, p);
            p.println("</" + n.getNodeName() + ">");
        }
    }

    private void indent(int level, PrintWriter p) {
        String ind = "";
        for (int i = 0; i < level * 4; ++i) {
            ind = ind + ' ';
        }
        p.print(ind);
    }
}

