/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.reproject.app;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashMap;
import javax.swing.JOptionPane;
import org.cresques.cts.IProjection;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.project.documents.view.gui.AbstractViewPanel;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.FLayers;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.algorithm.RasterBaseAlgorithmLibrary;
import org.gvsig.raster.algorithm.process.DataProcess;
import org.gvsig.raster.algorithm.process.IProcessActions;
import org.gvsig.raster.algorithm.process.ProcessException;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.gvsig.raster.mainplugin.RasterMainPluginUtils;
import org.gvsig.raster.reproject.algorithm.ReprojectProcess;
import org.gvsig.raster.reproject.algorithm.swing.api.RasterReprojectionPanel;
import org.gvsig.raster.reproject.algorithm.swing.api.ReprojectionPanelDataModel;
import org.gvsig.raster.reproject.app.ReprojectWindow;
import org.gvsig.raster.swing.RasterSwingLibrary;
import org.gvsig.raster.swing.RasterSwingLocator;
import org.gvsig.raster.util.RasterNotLoadException;

public class ReprojectListener
implements ActionListener,
IProcessActions {
    private RasterReprojectionPanel reprojectPanel = null;
    private FLayer lyr = null;
    private ReprojectionPanelDataModel dataModel = null;
    private ReprojectWindow window = null;

    public ReprojectListener(FLayer lyr, ReprojectionPanelDataModel dataModel, ReprojectWindow window, RasterReprojectionPanel reprojectPanel) {
        this.lyr = lyr;
        this.dataModel = dataModel;
        this.window = window;
        this.reprojectPanel = reprojectPanel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.reprojectPanel.getObjectSelected(e.getSource()) == 1) {
            DataProcess process;
            double cellsize = this.dataModel.getCellSize();
            int w = this.dataModel.getSize()[0];
            int h = this.dataModel.getSize()[1];
            IProjection srcPrj = this.dataModel.getSrcProjection();
            IProjection dstPrj = this.dataModel.getDstProjection();
            if (cellsize <= 0.0 || w <= 0 || h <= 0) {
                ReprojectListener.messageBoxError("wrong_size");
                return;
            }
            if (srcPrj == null || dstPrj == null) {
                ReprojectListener.messageBoxError("wrong_projection");
                return;
            }
            try {
                process = RasterBaseAlgorithmLibrary.getManager().createRasterTask("RasterReprojectionProcess");
            }
            catch (ProcessException e1) {
                ReprojectListener.messageBoxError("error_creating_algorithm");
                return;
            }
            String path = this.getPath();
            if (path == null) {
                return;
            }
            process.setActions((IProcessActions)this);
            process.addParam(ReprojectProcess.RASTER_STORE, (Object)((FLyrRaster)this.lyr).getDataStore());
            process.addParam(ReprojectProcess.SIZEX, (Object)w);
            process.addParam(ReprojectProcess.SIZEY, (Object)h);
            process.addParam(ReprojectProcess.PATH, (Object)path);
            process.addParam(ReprojectProcess.SRC_PROJECTION, (Object)this.dataModel.getSrcProjection());
            process.addParam(ReprojectProcess.DST_PROJECTION, (Object)this.dataModel.getDstProjection());
            process.addParam(ReprojectProcess.CELLSIZE, (Object)this.dataModel.getCellSize());
            process.addParam(ReprojectProcess.INTERPOLATION, (Object)this.dataModel.getInterpolationMethodSelected());
            process.start();
        }
        if (this.reprojectPanel.getObjectSelected(e.getSource()) == 2 && this.window != null) {
            PluginServices.getMDIManager().closeWindow((IWindow)this.window);
            this.window = null;
        }
    }

    private String getPath() {
        String dir;
        String file = this.reprojectPanel.getFileSelected();
        if (file == null || file.equals("") || !file.matches("[a-zA-Z0-9_]*")) {
            ReprojectListener.messageBoxError(Messages.getText((String)"file_name_not_valid") + "\n" + file + "\n " + Messages.getText((String)"valid_characters") + " a-zA-Z0-9_");
            return null;
        }
        if (!file.endsWith(".tif")) {
            file = file + ".tif";
        }
        if (!new File(dir = this.reprojectPanel.getDirectorySelected()).exists()) {
            ReprojectListener.messageBoxError("directory_does_not_exists");
            return null;
        }
        if (new File(dir + File.separator + file).exists() && !RasterSwingLibrary.messageBoxYesOrNot((String)(Messages.getText((String)"file_exists") + "\n " + dir + File.separator + file + "\n " + Messages.getText((String)"overwrite")), null)) {
            return null;
        }
        return dir + File.separator + file;
    }

    public static void messageBoxError(String msg) {
        String string = Messages.getText((String)"accept");
        Object[] options = new Object[]{string};
        JOptionPane.showOptionDialog((Component)PluginServices.getMainFrame(), "<html>" + Messages.getText((String)msg).replaceAll("\n", "<br>") + "</html>", Messages.getText((String)"confirmacion"), 0, 0, null, options, string);
    }

    public void end(Object params) {
        if (this.window != null) {
            PluginServices.getMDIManager().closeWindow((IWindow)this.window);
            this.window = null;
        }
        if (params instanceof HashMap) {
            HashMap map = (HashMap)params;
            String fName = (String)map.get(ReprojectProcess.FILENAME);
            long milis = (Long)map.get(ReprojectProcess.TIME);
            this.processFinalize(fName, milis);
            RasterSwingLocator.getSwingManager().showSummaryProcessDialog(fName, milis);
        }
    }

    private void processFinalize(String fileName, long milis) {
        if (!new File(fileName).exists()) {
            return;
        }
        String viewName = this.getViewName();
        if (viewName != null && RasterSwingLibrary.messageBoxYesOrNot((String)"cargar_toc", null)) {
            try {
                RasterMainPluginUtils.loadLayer((String)viewName, (String)fileName, null);
            }
            catch (RasterNotLoadException e) {
                ReprojectListener.messageBoxError("error_load_layer");
            }
        }
    }

    private String getViewName() {
        IWindow[] w = PluginServices.getMDIManager().getAllWindows();
        for (int i = 0; i < w.length; ++i) {
            if (!(w[i] instanceof AbstractViewPanel)) continue;
            FLayers lyrs = ((AbstractViewPanel)w[i]).getMapControl().getMapContext().getLayers();
            for (int j = 0; j < lyrs.getLayersCount(); ++j) {
                FLayer lyr = lyrs.getLayer(j);
                if (this.lyr != lyr) continue;
                return PluginServices.getMDIManager().getWindowInfo((IWindow)((AbstractViewPanel)w[i])).getTitle();
            }
        }
        return null;
    }

    public void interrupted() {
    }

    public void updateProgress(int current, int total) {
    }
}

