/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.reproject.app;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.cresques.cts.ICoordTrans;
import org.cresques.cts.IProjection;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.project.documents.view.gui.AbstractViewPanel;
import org.gvsig.fmap.crs.CRSFactory;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.datastruct.Extent;
import org.gvsig.fmap.dal.coverage.exception.RasterDriverException;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.layers.FLayers;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.gvsig.raster.reproject.algorithm.ReprojectProcess;
import org.gvsig.raster.reproject.algorithm.swing.api.ReprojectionPanelDataModel;

public class ReprojectionPanelDataModelImpl
implements ReprojectionPanelDataModel {
    private double cellSize = 0.0;
    private IProjection dstProjection = null;
    private IProjection srcProjection = null;
    private List<String> interpolationMethodList = null;
    private int interpolationMethod = 0;
    private String layerName = null;
    private int[] size = new int[]{0, 0};
    private FLyrRaster lyr = null;
    private Extent newBbox = null;

    public ReprojectionPanelDataModelImpl(FLyrRaster lyr) {
        this.lyr = lyr;
        this.cellSize = lyr.getDataStore().getCellSize();
        try {
            this.srcProjection = lyr.readProjection();
        }
        catch (RasterDriverException e) {
            this.srcProjection = this.getViewProjection(lyr);
        }
        if (this.srcProjection == null) {
            this.srcProjection = this.getViewProjection(lyr);
        }
        if (this.srcProjection == null) {
            this.srcProjection = CRSFactory.getCRS((String)"EPSG:23030");
        }
        this.dstProjection = this.srcProjection;
        this.layerName = lyr.getName();
        this.size = new int[]{(int)lyr.getDataStore().getWidth(), (int)lyr.getDataStore().getHeight()};
        this.interpolationMethod = -1;
        this.interpolationMethodList = new ArrayList<String>();
        for (int i = 0; i < ReprojectProcess.INTERP_METHODS.length; ++i) {
            this.interpolationMethodList.add(ReprojectProcess.INTERP_METHODS[i]);
        }
    }

    private IProjection getViewProjection(FLyrRaster lyr) {
        IWindow[] w = PluginServices.getMDIManager().getAllWindows();
        for (int i = 0; i < w.length; ++i) {
            if (!(w[i] instanceof AbstractViewPanel)) continue;
            MapContext mapContext = ((AbstractViewPanel)w[i]).getMapControl().getMapContext();
            FLayers lyrs = mapContext.getLayers();
            for (int j = 0; j < lyrs.getLayersCount(); ++j) {
                if (lyrs.getLayer(j) != lyr) continue;
                return ((AbstractViewPanel)w[i]).getProjection();
            }
        }
        return null;
    }

    private void updateValues(RasterDataStore store) {
        ICoordTrans transf = this.srcProjection.getCT(this.dstProjection);
        Extent bbox = store.getExtent();
        Point2D ul = new Point2D.Double(bbox.getULX(), bbox.getULY());
        Point2D lr = new Point2D.Double(bbox.getLRX(), bbox.getLRY());
        if (transf == null) {
            return;
        }
        ul = transf.convert(ul, ul);
        lr = transf.convert(lr, lr);
        this.newBbox = RasterLocator.getManager().getDataStructFactory().createExtent(ul, lr);
        double sumSideOldBBox = bbox.width() + bbox.height();
        double sumSideNewBBox = this.newBbox.width() + this.newBbox.height();
        double d1x = bbox.width() * 100.0 / sumSideOldBBox;
        double d1y = bbox.height() * 100.0 / sumSideOldBBox;
        double d2x = this.newBbox.width() * 100.0 / sumSideNewBBox;
        double d2y = this.newBbox.height() * 100.0 / sumSideNewBBox;
        double p2y = store.getHeight() * d2y / d1y;
        double p2x = store.getWidth() * d2x / d1x;
        double newCellSize = this.newBbox.width() / p2x;
        this.size[0] = (int)Math.round(p2x);
        this.size[1] = (int)Math.round(p2y);
        this.cellSize = newCellSize;
    }

    public double getCellSize() {
        return this.cellSize;
    }

    public IProjection getDstProjection() {
        return this.dstProjection;
    }

    public List<String> getInterpolationMethodList() {
        return this.interpolationMethodList;
    }

    public int getInterpolationMethodSelected() {
        return this.interpolationMethod;
    }

    public String getLayerName() {
        return this.layerName;
    }

    public int[] getSize() {
        return this.size;
    }

    public IProjection getSrcProjection() {
        return this.srcProjection;
    }

    public void setCellSize(double cellSize) {
        this.cellSize = cellSize;
        this.size[0] = (int)(this.newBbox.width() / cellSize);
        this.size[1] = (int)(this.newBbox.height() / cellSize);
    }

    public void setDstProjection(IProjection dst) {
        this.dstProjection = dst;
        this.updateValues(this.lyr.getDataStore());
    }

    public void setSrcProjection(IProjection src) {
        this.srcProjection = src;
        this.updateValues(this.lyr.getDataStore());
    }

    public void setInterpolationMethodList(List<String> list) {
        this.interpolationMethodList = list;
    }

    public void setInterpolationMethodSelected(int method) {
        this.interpolationMethod = method;
    }

    public void setLayerName(String layerName) {
        this.layerName = layerName;
    }

    public void setSize(int w, int h) {
        this.size = new int[]{w, h};
    }
}

