/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.reproject.app.preparelayer;

import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.raster.algorithm.process.DataProcess;
import org.gvsig.raster.algorithm.process.IProcessActions;
import org.gvsig.raster.algorithm.process.ProcessException;
import org.gvsig.raster.util.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReprojectionQueue
extends Thread {
    private Queue queue = new Queue();
    private DataProcess executionProcess = null;
    private static ReprojectionQueue singleton = null;
    private Logger logger = LoggerFactory.getLogger((String)ReprojectionQueue.class.toString());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReprojectionQueue getSingleton() {
        if (singleton == null) {
            ReprojectionQueue reprojectionQueue = singleton = new ReprojectionQueue();
            synchronized (reprojectionQueue) {
                singleton.start();
            }
        }
        return singleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ReprojectionQueue reprojectionQueue = this;
        synchronized (reprojectionQueue) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        while (true) {
            if (this.queue.size() < 1) {
                continue;
            }
            Object[] obj = (Object[])this.queue.get();
            this.executionProcess = (DataProcess)obj[0];
            if (this.executionProcess == null) continue;
            this.executionProcess.showIncrementableWindow();
            try {
                this.executionProcess.execute();
            }
            catch (ProcessInterruptedException processInterruptedException) {
            }
            catch (ProcessException e) {
                this.logger.debug(RasterLocator.getManager().getRasterUtils().getTrace((Exception)((Object)e)));
            }
            this.executionProcess.getIncrementableTask().processFinalize();
            Object object = obj[1];
            synchronized (object) {
                obj[1].notify();
            }
            if (this.queue.size() > 0) continue;
            object = this;
            synchronized (object) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public synchronized void add(DataProcess process, IProcessActions obj) {
        this.queue.put((Object)new Object[]{process, obj});
    }
}

