/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.swing.impl.canvas.layer.function;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.List;
import org.gvsig.raster.swing.gcanvas.SquareRootPowLine;
import org.gvsig.raster.swing.impl.DefaultRasterSwingManager;
import org.gvsig.raster.swing.impl.canvas.layer.DefaultInfoLayer;
import org.gvsig.raster.swing.impl.canvas.layer.function.DefaultStraightLine;

public class DefaultSquareRootPowLine
extends DefaultStraightLine
implements SquareRootPowLine {
    private double num = 40.0;
    private double valueFunction = 1.0;

    public DefaultSquareRootPowLine(Color c, double point) {
        super(c);
        this.setShowSquares(false);
        this.valueFunction = point;
        this.recalcList();
    }

    private void setInfoPoint(Double perc) {
        List list;
        if (this.canvas != null && (list = this.canvas.getDrawableElements(DefaultInfoLayer.class)).size() > 0) {
            DefaultInfoLayer infoLayer = (DefaultInfoLayer)((Object)list.get(0));
            if (perc == null) {
                infoLayer.setStatusLeft(null);
                infoLayer.setStatusRight(null);
                ((Component)this.canvas).repaint();
                return;
            }
            if (perc > 0.0) {
                infoLayer.setStatusLeft(DefaultRasterSwingManager.getText((Object)this, "square_root"));
            } else {
                infoLayer.setStatusLeft(DefaultRasterSwingManager.getText((Object)this, "pow"));
            }
            infoLayer.setStatusRight(this.clipDecimals(Math.abs(perc * 100.0), 2) + "%");
        }
    }

    private void recalcList() {
        double y = 0.0;
        this.setInfoPoint(new Double(this.valueFunction));
        this.listSquare.clear();
        int i = 0;
        while ((double)i <= this.num) {
            double x = (double)i / this.num;
            if (this.valueFunction >= 0.0 && this.valueFunction <= 1.0) {
                y = this.squareFunction(x);
                y = x + (y - x) * this.valueFunction;
            }
            if (this.valueFunction > 1.0 && this.valueFunction <= 2.0) {
                y = this.squareFunction(x);
                y += (1.0 - y) * (this.valueFunction - 1.0);
            }
            if (this.valueFunction >= -1.0 && this.valueFunction < 0.0) {
                y = this.powFunction(x);
                y = x - (x - y) * Math.abs(this.valueFunction);
            }
            if (this.valueFunction >= -2.0 && this.valueFunction < -1.0) {
                y = this.powFunction(x);
                y *= 1.0 - (Math.abs(this.valueFunction) - 1.0);
            }
            if (y < 0.0) {
                y = 0.0;
            }
            if (y > 1.0) {
                y = 1.0;
            }
            this.listSquare.add(new DefaultStraightLine.Square((DefaultStraightLine)this, x, y));
            ++i;
        }
    }

    private double squareFunction(double x) {
        return Math.sqrt(x);
    }

    private double powFunction(double x) {
        return Math.pow(x, 2.0);
    }

    @Override
    public boolean mouseDragged(MouseEvent e) {
        if (((Component)this.canvas).getCursor().getType() != 0) {
            return true;
        }
        double x = this.pixelToValueX(e.getX());
        double y = this.pixelToValueY(e.getY());
        double y2 = 0.0;
        this.valueFunction = y >= x ? (y < (y2 = this.squareFunction(x)) ? (y - x) / (y2 - x) : (y - y2) / (1.0 - y2) + 1.0) : (y > (y2 = this.powFunction(x)) ? -Math.abs((y - x) / (y2 - x)) : -Math.abs((y2 - y) / y2) - 1.0);
        if (this.valueFunction < -2.0) {
            this.valueFunction = -2.0;
        }
        if (this.valueFunction > 2.0) {
            this.valueFunction = 2.0;
        }
        this.recalcList();
        ((Component)this.canvas).repaint();
        this.canvas.callDataDragged("line", (Object)this);
        return false;
    }

    @Override
    public boolean mouseMoved(MouseEvent e) {
        return true;
    }

    @Override
    public boolean mousePressed(MouseEvent e) {
        return this.mouseDragged(e);
    }

    @Override
    public boolean mouseReleased(MouseEvent e) {
        this.setInfoPoint(null);
        return true;
    }

    @Override
    public int getFunctionType() {
        return 2;
    }

    @Override
    public double getValueFunction() {
        return this.valueFunction;
    }
}

