/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.swing.impl.pagedtable;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import org.gvsig.raster.swing.impl.pagedtable.MoveRowsPanel;
import org.gvsig.raster.swing.impl.pagedtable.Pager;
import org.gvsig.raster.swing.impl.pagedtable.PaginationBarPanel;
import org.gvsig.raster.swing.impl.pagedtable.TableEntryControllerPanel;
import org.gvsig.raster.swing.pagedtable.ModelLoader;
import org.gvsig.raster.swing.pagedtable.PagedTableEvent;

public class PagedTablePanel
extends JPanel
implements MouseListener,
Observer,
TableModelListener {
    private static final long serialVersionUID = 1L;
    private PagedJTable jTable = null;
    private ModelLoader modelLoader = null;
    private DefaultTableModel model = null;
    private Pager pager = null;
    private int heightLine = 16;

    public PagedTablePanel(ModelLoader modelLoader, Pager pager, PaginationBarPanel paginationBar, MoveRowsPanel moveRowsPanel, TableEntryControllerPanel tableEntryControllerPanel) {
        this.modelLoader = modelLoader;
        this.pager = pager;
        this.model = (DefaultTableModel)modelLoader.getTableModel();
        this.initGUI(paginationBar, moveRowsPanel, tableEntryControllerPanel);
    }

    private void initGUI(PaginationBarPanel paginationBar, MoveRowsPanel moveRowsPanel, TableEntryControllerPanel tableEntryControllerPanel) {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)this.getJTableWithHeader(), gbc);
        gbc.fill = 3;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        gbc.gridx = 1;
        gbc.gridy = 0;
        this.add((Component)paginationBar, gbc);
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(1, 0, 0));
        panel.add(tableEntryControllerPanel);
        panel.add(moveRowsPanel);
        this.add((Component)panel, gbc);
    }

    public Pager getPager(int nEntriesPerPage) {
        this.pager.setEntriesPerPage(nEntriesPerPage);
        return this.pager;
    }

    public JPanel getJTableWithHeader() {
        JPanel p = new JPanel(new BorderLayout());
        JTableHeader header = this.getJTable().getTableHeader();
        p.add((Component)header, "North");
        p.add((Component)this.getJTable(), "Center");
        return p;
    }

    public JTable getJTable() {
        if (this.jTable == null) {
            this.jTable = new PagedJTable(this.model, this.modelLoader.getColumnNames());
            this.jTable.addMouseListener(this);
            this.jTable.setAutoResizeMode(4);
            this.model.addTableModelListener(this);
            TableColumn column = null;
            int widthPerColumn = this.getWidth() / this.modelLoader.getColumnNames().length;
            for (int i = 0; i < this.modelLoader.getColumnNames().length; ++i) {
                column = this.jTable.getColumnModel().getColumn(i);
                column.setResizable(true);
                if (this.modelLoader.getColumnWidths() == null) {
                    column.setPreferredWidth(widthPerColumn);
                } else if (i < this.modelLoader.getColumnWidths().length && this.modelLoader.getColumnWidths()[i] > 0) {
                    column.setMaxWidth(this.modelLoader.getColumnWidths()[i]);
                } else if (this.modelLoader.getColumnWidths()[i] == 0) {
                    column.setMinWidth(0);
                    column.setMaxWidth(0);
                } else {
                    column.setPreferredWidth(widthPerColumn);
                }
                if (this.modelLoader.getCellEditorForColumn(i) != null) {
                    column.setCellEditor(this.modelLoader.getCellEditorForColumn(i));
                }
                if (this.modelLoader.getRenderForColumn(i) == null) continue;
                column.setCellRenderer(this.modelLoader.getRenderForColumn(i));
            }
        }
        return this.jTable;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        int column;
        if (e.getType() == 0 && (column = e.getColumn()) != -1) {
            Object[] entry = this.pager.getEntry(this.pager.getRowFromPageRow(e.getFirstRow()));
            if (entry != null && column >= 0 && column < entry.length) {
                entry[column] = this.model.getValueAt(e.getFirstRow(), column);
            }
            this.pager.throwEvent(PagedTableEvent.EVENT_MODIFY_ENTRY, new int[]{e.getFirstRow()});
        }
    }

    public void setLineHeight(int height) {
        this.heightLine = height;
    }

    public int getRowTableCount() {
        return this.model.getRowCount();
    }

    public int getSelectedTableRow() {
        return this.getJTable().getSelectedRow();
    }

    private int reloadPage() {
        this.model.setNumRows(0);
        List<Object> lines = this.pager.getSelectedPage();
        if (lines == null) {
            return this.pager.getSelectedPageNumber();
        }
        for (int i = 0; i < lines.size(); ++i) {
            this.model.addRow((Object[])lines.get(i));
        }
        return this.pager.getSelectedPageNumber();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int selVisualRow;
        if (e.getSource() == this.jTable && (selVisualRow = this.getSelectedTableRow()) >= 0) {
            int selRow = this.pager.getSelectedPageNumber() * this.pager.getEntriesPerPage() + selVisualRow;
            this.pager.setSelectedRows(new int[]{selRow});
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o instanceof Pager && arg instanceof Integer) {
            int[] selectedRows;
            Pager pager;
            int[] selectedRows2;
            int option = (Integer)arg;
            if (option == PagedTableEvent.EVENT_SELECTED_ROWS && (selectedRows2 = (pager = (Pager)o).getSelectedRows()) != null && selectedRows2.length > 0) {
                int r;
                if (!pager.isInCurrentPage(selectedRows2[0])) {
                    pager.setSelectedPage(pager.getPageFromRow(selectedRows2[0]));
                    this.reloadPage();
                }
                if (pager.getEntriesPerPage() > 0 && (r = selectedRows2[0] % pager.getEntriesPerPage()) >= 0 && r < this.model.getRowCount()) {
                    this.getJTable().setRowSelectionInterval(r, r);
                }
            }
            if (option == PagedTableEvent.EVENT_ADD_ENTRY) {
                this.model.addRow(this.pager.getLastEntry());
                int lastTableRow = this.model.getRowCount() - 1;
                this.getJTable().setRowSelectionInterval(lastTableRow, lastTableRow);
            }
            if (option == PagedTableEvent.EVENT_REMOVE_ENTRY) {
                int r;
                selectedRows = this.pager.getSelectedRows();
                this.reloadPage();
                if (selectedRows != null && this.pager.getEntriesPerPage() > 0 && (r = selectedRows[0] % this.pager.getEntriesPerPage()) >= 0 && r < this.model.getRowCount()) {
                    this.getJTable().setRowSelectionInterval(r, r);
                }
            }
            if (option == PagedTableEvent.EVENT_REMOVE_ALL) {
                this.model.setNumRows(0);
            }
            if (option == PagedTableEvent.EVENT_SELECTED_PAGE || option == PagedTableEvent.EVENT_MODIFY_ENTRY) {
                this.reloadPage();
                selectedRows = this.pager.getSelectedRows();
                if (selectedRows != null && this.pager.getEntriesPerPage() > 0) {
                    int nPage = this.pager.getSelectedPageNumber();
                    int initEntry = nPage * this.pager.getEntriesPerPage();
                    int endEntry = Math.min(initEntry + this.pager.getEntriesPerPage(), this.pager.getEntriesCount());
                    int selectedRow = selectedRows[0];
                    this.getJTable().clearSelection();
                    if (selectedRow >= initEntry && selectedRow < endEntry) {
                        int r = selectedRows[0] % this.pager.getEntriesPerPage();
                        this.getJTable().setRowSelectionInterval(r, r);
                    }
                }
            }
            if (option == PagedTableEvent.EVENT_SWAP_ENTRIES) {
                this.reloadPage();
            }
        }
    }

    public class PagedJTable
    extends JTable {
        private static final long serialVersionUID = 1L;

        public PagedJTable(DefaultTableModel model, String[] columnNames) {
            super((Object[][])null, columnNames);
            this.setModel(model);
        }

        @Override
        public void setBounds(int x, int y, int width, int height) {
            super.setBounds(x, y, width, height);
            int entriesPerPage = (int)((double)this.getHeight() / (double)PagedTablePanel.this.heightLine);
            PagedTablePanel.this.getPager(entriesPerPage);
        }
    }
}

