/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.swing.impl.slider;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.gvsig.gui.beans.slidertext.listeners.SliderEvent;
import org.gvsig.gui.beans.slidertext.listeners.SliderListener;
import org.gvsig.raster.swing.slider.SliderText;

public class SliderTextContainer
extends JPanel
implements SliderText,
ChangeListener,
FocusListener,
KeyListener,
MouseListener {
    private static final long serialVersionUID = 1876415954410511634L;
    private ArrayList<SliderListener> actionCommandListeners = new ArrayList();
    private JPanel pText = null;
    private JSlider slider = null;
    private JTextField text = null;
    private int min = 0;
    private int max = 255;
    private double interval = 1.0;
    private int defaultPos = 0;
    private boolean decimal = false;
    private boolean disconnectEvent = false;
    private boolean dragged = false;
    private boolean showBorder = false;

    public SliderTextContainer(int min, int max, int defaultPos) {
        this(min, max, defaultPos, false);
    }

    public SliderTextContainer(int min, int max, int defaultPos, boolean border) {
        this.min = min;
        this.max = max;
        this.defaultPos = defaultPos;
        this.showBorder = border;
        this.initialize();
    }

    public SliderTextContainer() {
        this(0, 100, 0);
    }

    protected void callChangeValue(boolean forceEvent) {
        if (!this.getSlider().isEnabled() && !forceEvent) {
            return;
        }
        for (SliderListener listener : this.actionCommandListeners) {
            listener.actionValueChanged(new SliderEvent((Object)this));
        }
    }

    protected void callDraggedValue() {
        for (SliderListener listener : this.actionCommandListeners) {
            listener.actionValueDragged(new SliderEvent((Object)this));
        }
    }

    public void addValueChangedListener(SliderListener listener) {
        if (!this.actionCommandListeners.contains(listener)) {
            this.actionCommandListeners.add(listener);
        }
    }

    public void removeValueChangedListener(SliderListener listener) {
        this.actionCommandListeners.remove(listener);
    }

    public void setBorder(String name) {
        this.setBorder(BorderFactory.createTitledBorder(null, name, 0, 0, null, null));
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getSlider(), "Center");
        this.add((Component)this.getPText(), "East");
        if (this.showBorder) {
            this.setBorder(BorderFactory.createLineBorder(Color.gray, 1));
        }
    }

    private JPanel getPText() {
        if (this.pText == null) {
            this.pText = new JPanel();
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.insets = new Insets(0, 10, 8, 0);
            this.pText.setLayout(new GridBagLayout());
            this.pText.add((Component)this.getTextField(), gridBagConstraints1);
        }
        return this.pText;
    }

    public JSlider getSlider() {
        if (this.slider == null) {
            this.slider = new JSlider();
            this.slider.setMinimum(0);
            this.slider.setMaximum((int)((double)(this.max - this.min) / this.interval));
            this.slider.setValue((int)((double)(this.defaultPos - this.min) / this.interval));
            this.updateTicks();
            this.slider.addChangeListener(this);
            this.slider.addMouseListener(this);
        }
        return this.slider;
    }

    public JTextField getTextField() {
        if (this.text == null) {
            this.text = new JTextField();
            this.text.setText(this.defaultPos + "");
            this.text.setPreferredSize(new Dimension(40, 26));
            this.text.setMinimumSize(new Dimension(40, 26));
            this.text.addFocusListener(this);
            this.text.addKeyListener(this);
        }
        return this.text;
    }

    public void setComponentSize(int w, int h) {
    }

    public double getValue() {
        return new Double(this.getTextField().getText());
    }

    public void setValue(double value) {
        if (this.decimal) {
            this.getTextField().setText(String.valueOf(value));
        } else {
            this.getTextField().setText(String.valueOf((int)value));
        }
        this.getSlider().setValue((int)((value - (double)this.min) / this.interval));
    }

    public void setControlEnabled(boolean active) {
        this.getSlider().setEnabled(active);
        this.getTextField().setEnabled(active);
        if (!active) {
            this.getTextField().setBackground(this.pText.getBackground());
        } else {
            this.getTextField().setBackground(Color.white);
        }
    }

    public void setDecimal(boolean dec) {
        this.decimal = dec;
        String s = this.getTextField().getText();
        if (dec) {
            this.getTextField().setText(s + ".0");
        } else {
            int index = s.lastIndexOf(".");
            if (index == -1 || index == 0) {
                index = s.length() - 1;
            }
            this.getTextField().setText(s.substring(0, index + 1));
        }
    }

    public boolean getDecimal() {
        return this.decimal;
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int max) {
        this.setMaximum(max);
    }

    public void setMaximum(int max) {
        this.max = max;
        this.updateInterval();
    }

    public int getMin() {
        return this.min;
    }

    public void setMin(int min) {
        this.setMinimum(min);
    }

    public void setMinimum(int min) {
        this.min = min;
        this.updateInterval();
    }

    private void updateTicks() {
        int ticks = (int)((double)(this.max - this.min) / this.interval) / 40;
        this.getSlider().setMajorTickSpacing(ticks * 4);
        this.slider.setPaintTicks(true);
        this.getSlider().setMinorTickSpacing(ticks);
    }

    private void updateInterval() {
        double aux = this.getValue();
        this.getSlider().setMinimum(0);
        this.getSlider().setMaximum((int)((double)(this.max - this.min) / this.interval));
        this.setValue(aux);
        this.updateTicks();
    }

    public void setInterval(double value) {
        this.interval = value;
        this.updateInterval();
    }

    public double getInterval() {
        return this.interval;
    }

    private void checkDecimalTextAndUpdateSlider() {
        String text = this.getTextField().getText();
        double value = 0.0;
        this.disconnectEvent = true;
        try {
            if (!text.equals("")) {
                value = Double.parseDouble(text) * 100.0 / (double)(this.getMax() - this.getMin());
                value = Double.valueOf(text);
                if (value < (double)this.getMin()) {
                    value = this.getMin();
                }
                if (value > (double)this.getMax()) {
                    value = this.getMax();
                }
            }
            this.setValue(value);
            this.callChangeValue(true);
        }
        catch (NumberFormatException exc) {
            this.setValue((double)this.getSlider().getValue() * this.interval + (double)this.min);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (!this.disconnectEvent) {
            double value = (double)this.getSlider().getValue() * this.getInterval() + (double)this.getMin();
            if (!this.getDecimal()) {
                this.getTextField().setText((int)value + "");
            } else {
                this.getTextField().setText((double)((int)(value * 10.0)) / 10.0 + "");
            }
            if (this.dragged) {
                this.callDraggedValue();
            } else {
                this.callChangeValue(true);
            }
        }
        this.disconnectEvent = false;
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.checkDecimalTextAndUpdateSlider();
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            this.checkDecimalTextAndUpdateSlider();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.dragged = true;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.dragged = false;
        this.callChangeValue(false);
    }

    public JComponent getComponent() {
        return this;
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

