/*
 * Decompiled with CFR 0.152.
 */
package es.gva.cit.jmrsid;

import es.gva.cit.jmrsid.JNIBase;
import es.gva.cit.jmrsid.LTIGeoCoord;
import es.gva.cit.jmrsid.LTIMetadataDatabase;
import es.gva.cit.jmrsid.LTIPixel;
import es.gva.cit.jmrsid.MrSIDException;

public class LTIImage
extends JNIBase {
    private int[] magsize = new int[2];
    LTIGeoCoord geocoord = null;

    private native long getMetadataNat(long var1);

    private native int getDimsAtMagWidthNat(long var1, double var3);

    private native int getDimsAtMagHeightNat(long var1, double var3);

    private native long getPixelPropsNat(long var1);

    private native long getBackgroundPixelNat(long var1);

    private native long getNoDataPixelNat(long var1);

    private native int getGeoCoordNat(long var1, LTIGeoCoord var3);

    private native void FreeLTIImageNat(long var1);

    private native double getMinMagnificationNat(long var1);

    private native double getMaxMagnificationNat(long var1);

    public LTIImage() {
    }

    public LTIImage(long cPtr) {
        this.cPtr = cPtr;
    }

    protected void finalize() {
        if (this.cPtr != 0L) {
            this.FreeLTIImageNat(this.cPtr);
            this.cPtr = -1L;
        }
    }

    public void initialize() throws MrSIDException {
        String msg1 = "Error en initialize. El Open del MrSID no tuvo \u00ef\u00bf\u00bdxito";
        String msg2 = "La llamada nativa a initialize ha devuelto un c\u00ef\u00bf\u00bddigo de error";
        int codigo = 0;
        if (codigo > 0) {
            throw new MrSIDException("La llamada nativa a initialize ha devuelto el c\u00ef\u00bf\u00bddigo de error " + codigo);
        }
    }

    public LTIMetadataDatabase getMetadata() throws MrSIDException {
        if (this.cPtr == 0L) {
            throw new MrSIDException("Error en getMetadataDatabase. El Open del MrSID no tuvo \u00ef\u00bf\u00bdxito");
        }
        LTIMetadataDatabase metadata = new LTIMetadataDatabase(this.getMetadataNat(this.cPtr));
        if (metadata == null) {
            throw new MrSIDException("Objeto LTIMetadataDatabase nulo");
        }
        return metadata;
    }

    public int getWidth() throws MrSIDException {
        String msg1 = "Error en getNumLevels. No se ha obtenido un puntero valido a LTIImage";
        String msg2 = "La llamada nativa a getNumLevels ha devuelto un c\u00ef\u00bf\u00bddigo de error";
        return this.baseSimpleFunction(3, msg1, msg2);
    }

    public int getHeight() throws MrSIDException {
        String msg1 = "Error en getNumLevels. No se ha obtenido un puntero valido a LTIImage";
        String msg2 = "La llamada nativa a getNumLevels ha devuelto un c\u00ef\u00bf\u00bddigo de error";
        return this.baseSimpleFunction(4, msg1, msg2);
    }

    public int getNumBands() throws MrSIDException {
        String msg1 = "Error en getNumBands. No se ha obtenido un puntero valido a LTIImage";
        String msg2 = "La llamada nativa a getNumBands ha devuelto un c\u00ef\u00bf\u00bddigo de error";
        return this.baseSimpleFunction(6, msg1, msg2);
    }

    public int getColorSpace() throws MrSIDException {
        String msg1 = "Error en getColorSpace. No se ha obtenido un puntero valido a LTIImage";
        String msg2 = "La llamada nativa a getColorSpace ha devuelto un c\u00ef\u00bf\u00bddigo de error";
        return this.baseSimpleFunction(7, msg1, msg2);
    }

    public int getDataType() throws MrSIDException {
        String msg1 = "Error en getDataType. No se ha obtenido un puntero valido a LTIImage";
        String msg2 = "La llamada nativa a getDataType ha devuelto un c\u00ef\u00bf\u00bddigo de error";
        return this.baseSimpleFunction(8, msg1, msg2);
    }

    public int[] getDimsAtMag(double mag) throws MrSIDException {
        if (this.cPtr == 0L) {
            throw new MrSIDException("Error en getDimsAtMag. El Open del MrSID no tuvo \u00ef\u00bf\u00bdxito");
        }
        this.magsize[0] = this.getDimsAtMagWidthNat(this.cPtr, mag);
        this.magsize[1] = this.getDimsAtMagHeightNat(this.cPtr, mag);
        if (this.magsize[0] < 0 || this.magsize[1] < 0) {
            throw new MrSIDException("Error en getDimsAtMag. El Open del MrSID no tuvo \u00ef\u00bf\u00bdxito");
        }
        return this.magsize;
    }

    public LTIPixel getPixelProps() throws MrSIDException {
        if (this.cPtr == 0L) {
            throw new MrSIDException("Error en getPixelProps. El Open del MrSID no tuvo \u00ef\u00bf\u00bdxito");
        }
        LTIPixel props = new LTIPixel(this.getPixelPropsNat(this.cPtr));
        if (props == null) {
            throw new MrSIDException("Error en getPixelProps. No se ha podido obtener LTIPixel");
        }
        return props;
    }

    public LTIGeoCoord getGeoCoord() throws MrSIDException {
        int res = 0;
        if (this.cPtr == 0L) {
            throw new MrSIDException("Error en getGeoCoord. El Open del MrSID no tuvo \u00ef\u00bf\u00bdxito");
        }
        if (this.geocoord == null) {
            this.geocoord = new LTIGeoCoord();
            res = this.getGeoCoordNat(this.cPtr, this.geocoord);
        }
        if (res < 0) {
            throw new MrSIDException("Error en getGeoCoord. No se ha podido obtener un LTIGeoCoord valido");
        }
        return this.geocoord;
    }

    public LTIPixel getBackgroundPixel() throws MrSIDException {
        if (this.cPtr == 0L) {
            throw new MrSIDException("Error en getBackgroundPixel. El Open del MrSID no tuvo \u00ef\u00bf\u00bdxito");
        }
        LTIPixel pixel = new LTIPixel(this.getBackgroundPixelNat(this.cPtr));
        if (pixel.getPtr() == 0L) {
            return null;
        }
        return pixel;
    }

    public LTIPixel getNoDataPixel() throws MrSIDException {
        if (this.cPtr == 0L) {
            throw new MrSIDException("Error en getNoData. El Open del MrSID no tuvo \u00ef\u00bf\u00bdxito");
        }
        LTIPixel pixel = new LTIPixel(this.getNoDataPixelNat(this.cPtr));
        if (pixel.getPtr() == 0L) {
            return null;
        }
        return pixel;
    }

    public double getMinMagnification() throws MrSIDException {
        if (this.cPtr == 0L) {
            throw new MrSIDException("Error en getMinMagnification(). El Open del MrSID no tuvo \u00ef\u00bf\u00bdxito");
        }
        return this.getMinMagnificationNat(this.cPtr);
    }

    public double getMaxMagnification() throws MrSIDException {
        if (this.cPtr == 0L) {
            throw new MrSIDException("Error en getMaxMagnification(). El Open del MrSID no tuvo \u00ef\u00bf\u00bdxito");
        }
        return this.getMaxMagnificationNat(this.cPtr);
    }
}

