/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.geoprocess.algorithm.fusespatially;

import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.exceptions.UnsupportedOutputChannelException;
import es.unex.sextante.outputs.NullOutputChannel;
import java.util.ArrayList;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.geoprocess.algorithm.fusespatially.FuseSpatiallyOperation;
import org.gvsig.geoprocess.algorithm.fusespatially.FuseSpatiallyOperationFast2;
import org.gvsig.geoprocess.lib.sextante.AbstractSextanteGeoProcess;
import org.gvsig.geoprocess.lib.sextante.dataObjects.FlyrVectIVectorLayer;
import org.gvsig.tools.dispose.DisposableIterator;
import org.gvsig.tools.task.SimpleTaskStatus;

public class FuseSpatiallyAlgorithm
extends AbstractSextanteGeoProcess {
    public static final String RESULT = "RESULT";
    public static final String RESULT_TABLE = "RESULT_TABLE";
    public static final String LAYER = "LAYER";
    public static final String SELECTED_GEOM = "SELECTED_GEOM";
    private AbstractSextanteGeoProcess process = null;
    private String fid = "FID";

    public void defineCharacteristics() {
        this.setName(this.getTranslation("fusespatially"));
        this.setGroup(this.getTranslation("basic_vect_algorithms"));
        try {
            this.m_Parameters.addInputVectorLayer(LAYER, this.getTranslation("Input_layer"), -1, true);
            this.m_Parameters.addBoolean(SELECTED_GEOM, this.getTranslation("Selected_geometries_fuse"), false);
            this.addOutputVectorLayer(RESULT, this.getTranslation("fuse_spatially") + " ", -1);
            this.addOutputVectorLayer(RESULT_TABLE, this.getTranslation("fuse_spatially") + "_" + this.getTranslation("Table") + " ", -1);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public void setParentProcess(AbstractSextanteGeoProcess process) {
        this.process = process;
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        if (this.existsOutPutFile(RESULT, 0)) {
            throw new GeoAlgorithmExecutionException(this.getTranslation("file_exists"));
        }
        IVectorLayer layer = this.m_Parameters.getParameterValueAsVectorLayer(LAYER);
        boolean selectedGeom = this.m_Parameters.getParameterValueAsBoolean(SELECTED_GEOM);
        FeatureStore storeLayer = null;
        if (!(layer instanceof FlyrVectIVectorLayer)) {
            return false;
        }
        storeLayer = ((FlyrVectIVectorLayer)layer).getFeatureStore();
        try {
            FeatureStore outFeatStore;
            boolean createTable;
            if (this.getOutputChannel(RESULT_TABLE) instanceof NullOutputChannel) {
                createTable = false;
                String[] attrNames = new String[storeLayer.getDefaultFeatureType().getAttributeDescriptors().length + 1];
                Class[] types = new Class[storeLayer.getDefaultFeatureType().getAttributeDescriptors().length + 1];
                attrNames[0] = "FID";
                types[0] = Integer.class;
                int count = 1;
                for (FeatureAttributeDescriptor attributeDescriptor : storeLayer.getDefaultFeatureType().getAttributeDescriptors()) {
                    attrNames[count] = attributeDescriptor.getName();
                    types[count] = attributeDescriptor.getObjectClass();
                    ++count;
                }
                outFeatStore = this.buildFuseSpatiallyOutPutStore(attrNames, types, layer.getShapeType(), this.getTranslation("fusespatially"), RESULT);
            } else {
                String[] attrNames = new String[]{"FID"};
                Class[] types = new Class[]{Integer.class};
                createTable = true;
                outFeatStore = this.buildFuseSpatiallyOutPutStore(attrNames, types, layer.getShapeType(), this.getTranslation("fusespatially"), RESULT);
            }
            return this.execute(storeLayer, outFeatStore, layer.getShapeType(), selectedGeom, (SimpleTaskStatus)this.getStatus(), "FID", createTable);
        }
        catch (DataException e) {
            Sextante.addErrorToLog((Throwable)e);
            return false;
        }
    }

    public boolean execute(FeatureStore inputStoreLayer, FeatureStore outFeatStore, int shapeType, boolean selectedGeom, SimpleTaskStatus status, String idField, boolean createTable) throws DataException {
        FeatureStore outFeatStoreTable = null;
        String[] attrNamesTable = null;
        if (createTable) {
            attrNamesTable = new String[inputStoreLayer.getDefaultFeatureType().size() + 1];
            Class[] typesTable = new Class[inputStoreLayer.getDefaultFeatureType().size() + 1];
            attrNamesTable[0] = this.fid;
            typesTable[0] = Integer.class;
            for (int i = 0; i < inputStoreLayer.getDefaultFeatureType().size(); ++i) {
                FeatureAttributeDescriptor attrDesc = inputStoreLayer.getDefaultFeatureType().getAttributeDescriptor(i);
                attrNamesTable[i + 1] = attrDesc.getName();
                typesTable[i + 1] = attrDesc.getDataType().getDefaultClass();
            }
            attrNamesTable = this.checkFields(attrNamesTable);
            outFeatStoreTable = this.buildFuseSpatiallyOutPutStore(attrNamesTable, typesTable, shapeType, this.getTranslation("fusespatially") + "_Table", RESULT_TABLE);
        }
        FuseSpatiallyOperationFast2 operation = new FuseSpatiallyOperationFast2(this);
        operation.setTaskStatus((SimpleTaskStatus)this.getStatus());
        operation.computesGeometryOperation(inputStoreLayer, outFeatStore, outFeatStoreTable, new String[]{this.fid}, attrNamesTable, selectedGeom, false, idField);
        return !this.getTaskMonitor().isCanceled();
    }

    public String[] checkFields(String[] names) {
        if (names.length <= 1) {
            return names;
        }
        int cont = 0;
        for (int i = 1; i < names.length; ++i) {
            if (names[0].compareTo(names[i]) != 0) continue;
            names[0] = "FID_" + cont;
            i = 0;
            ++cont;
        }
        return names;
    }

    public void computesGeometryOperation(FeatureStore inFeatStore, FeatureStore outFeatStore, FeatureStore outFeatStoreTable, String[] attrNames, String[] attrNamesTable, boolean selectedGeom, SimpleTaskStatus status, String idField) throws DataException {
        FeatureSet featuresSet = null;
        DisposableIterator it = null;
        featuresSet = selectedGeom ? (FeatureSet)inFeatStore.getSelection() : inFeatStore.getFeatureSet();
        it = featuresSet.iterator();
        int numberOfFeatures = (int)featuresSet.getSize();
        if (status != null) {
            status.setRangeOfValues(0L, (long)numberOfFeatures);
        }
        ArrayList<Feature> featList = new ArrayList<Feature>();
        while (it.hasNext()) {
            Feature feature = (Feature)it.next();
            featList.add(feature);
        }
        FuseSpatiallyOperation operation = new FuseSpatiallyOperation(featList, outFeatStoreTable, attrNamesTable, idField, this);
        operation.setFeatureStore(outFeatStore, attrNames);
        int size = featList.size();
        operation.setGeoProcess(this, size);
        while (featList.size() > 0 && !this.m_Task.isCanceled()) {
            Feature f = (Feature)featList.remove(featList.size() - 1);
            operation.invoke(f.getDefaultGeometry(), f);
            this.setProgress(size - featList.size(), size);
        }
        if (operation.getWriter() != null) {
            operation.getWriter().end();
        }
    }

    public boolean setProgress(int step, int size) {
        if (this.process != null) {
            return this.process.setProgress(step, size);
        }
        return super.setProgress(step, size);
    }

    protected FeatureStore buildFuseSpatiallyOutPutStore(String[] attrNames, Class[] types, int shapeType, String sextanteLayerName, String sextanteLayerLabel) {
        try {
            IVectorLayer output = this.getNewVectorLayer(sextanteLayerLabel, sextanteLayerName, shapeType, types, attrNames);
            return ((FlyrVectIVectorLayer)output).getFeatureStore();
        }
        catch (UnsupportedOutputChannelException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (GeoAlgorithmExecutionException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        return null;
    }
}

