/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.extension;

import java.util.List;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.app.project.documents.view.gui.IView;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.FLayers;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.fmap.mapcontrol.MapControl;

public class ClearSelectionExtension
extends Extension {
    public void execute(String s) {
        ApplicationManager application = ApplicationLocator.getManager();
        IView view = (IView)((Object)application.getActiveComponent(ViewDocument.class));
        if (view == null) {
            return;
        }
        ViewDocument document = view.getViewDocument();
        if (s.equalsIgnoreCase("selection-clear-view")) {
            MapControl mapCtrl = view.getMapControl();
            FLayers layers = document.getMapContext().getLayers();
            List activeLayers = layers.getLayers(FLayers.LAYER_ACTIVE.and(FLayers.LAYER_AVALAIBLE).and(FLayers.LAYER_FLYRVECT));
            List layersToDeselect = activeLayers.size() >= 1 ? layers.getLayers(FLayers.LAYER_ACTIVE.and(FLayers.LAYER_AVALAIBLE).and(FLayers.LAYER_FLYRVECT).and(FLayers.LAYER_SELECTION_EMPTY.negate())) : layers.getLayers(FLayers.LAYER_AVALAIBLE.and(FLayers.LAYER_FLYRVECT).and(FLayers.LAYER_SELECTION_EMPTY.negate()));
            this.clearSelectionOfView(layersToDeselect);
            mapCtrl.drawMap(false);
            document.setModified(true);
        }
    }

    private void clearSelectionOfView(List<FLayer> layers) {
        for (FLayer layer : layers) {
            FeatureStore featureStore = ((FLyrVect)layer).getFeatureStore();
            try {
                featureStore.getFeatureSelection().deselectAll();
            }
            catch (DataException ex) {
                ex.printStackTrace();
            }
        }
    }

    public boolean isVisible() {
        ApplicationManager application = ApplicationLocator.getManager();
        IView view = (IView)((Object)application.getActiveComponent(ViewDocument.class));
        if (view == null) {
            return false;
        }
        ViewDocument document = view.getViewDocument();
        MapContext mapa = document.getMapContext();
        return mapa.getLayers().getLayersCount() > 0;
    }

    public boolean isEnabled() {
        ApplicationManager application = ApplicationLocator.getManager();
        IView view = (IView)((Object)application.getActiveComponent(ViewDocument.class));
        if (view == null) {
            return false;
        }
        ViewDocument document = view.getViewDocument();
        if (document == null) {
            return false;
        }
        FLayers layers = document.getMapContext().getLayers();
        List activeLayers = layers.getLayers(FLayers.LAYER_ACTIVE);
        if (activeLayers.size() >= 1) {
            List activeLayersWithSelection = layers.getLayers(FLayers.LAYER_ACTIVE.and(FLayers.LAYER_AVALAIBLE).and(FLayers.LAYER_FLYRVECT).and(FLayers.LAYER_SELECTION_EMPTY.negate()));
            return activeLayersWithSelection.size() >= 1;
        }
        List selectionLayers = layers.getLayers(FLayers.LAYER_AVALAIBLE.and(FLayers.LAYER_FLYRVECT).and(FLayers.LAYER_SELECTION_EMPTY.negate()));
        return selectionLayers.size() >= 1;
    }

    public void initialize() {
        IconThemeHelper.registerIcon((String)"action", (String)"edit-clear", (Object)((Object)this));
    }
}

