/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.extension;

import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.andami.ui.mdiManager.MDIManager;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.gui.command.CommandStackDialog;
import org.gvsig.app.project.documents.view.gui.IView;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.tools.undo.RedoException;
import org.gvsig.tools.undo.UndoException;
import org.gvsig.tools.undo.UndoRedoStack;

public class UndoRedoViewExtension
extends Extension {
    public void initialize() {
        IconThemeHelper.registerIcon((String)"action", (String)"edit-undo", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"action", (String)"edit-redo", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"action", (String)"edit-undo-redo-actions", (Object)((Object)this));
    }

    public void execute(String s) {
        switch (s) {
            case "edit-undo-layer": {
                this.undo();
                break;
            }
            case "edit-redo-layer": {
                this.redo();
                break;
            }
            case "edit-undo-redo-actions-layer": {
                this.showHistory();
            }
        }
    }

    private void undo() {
        try {
            FLyrVect layer = this.getActiveAndEditingLayer();
            if (layer == null) {
                return;
            }
            if (!layer.getFeatureStore().canUndo()) {
                return;
            }
            ApplicationManager application = ApplicationLocator.getApplicationManager();
            IView vista = (IView)application.getActiveWindow();
            layer.getFeatureStore().undo();
            vista.getMapControl().drawMap(false);
            application.refreshMenusAndToolBars();
        }
        catch (UndoException ex) {
            logger.warn("Can't undo", (Throwable)ex);
        }
    }

    private void showHistory() {
        FLyrVect layer = this.getActiveAndEditingLayer();
        if (layer == null) {
            return;
        }
        ApplicationManager application = ApplicationLocator.getApplicationManager();
        MDIManager uiManager = application.getUIManager();
        FeatureStore featureStore = layer.getFeatureStore();
        CommandStackDialog csd = new CommandStackDialog();
        csd.setModel((UndoRedoStack)featureStore);
        csd.setLabelModel(featureStore.getName());
        uiManager.addWindow((IWindow)csd);
    }

    private void redo() {
        try {
            FLyrVect layer = this.getActiveAndEditingLayer();
            if (layer == null) {
                return;
            }
            if (!layer.getFeatureStore().canRedo()) {
                return;
            }
            ApplicationManager application = ApplicationLocator.getApplicationManager();
            IView vista = (IView)application.getActiveWindow();
            layer.getFeatureStore().redo();
            vista.getMapControl().drawMap(false);
            application.refreshMenusAndToolBars();
        }
        catch (RedoException ex) {
            logger.warn("Can't undo", (Throwable)ex);
        }
    }

    public boolean canQueryByAction() {
        return true;
    }

    public boolean isEnabled(String action) {
        FLyrVect layer = this.getActiveAndEditingLayer();
        switch (action) {
            case "edit-undo-layer": {
                if (layer == null) {
                    return false;
                }
                return layer.getFeatureStore().canUndo();
            }
            case "edit-redo-layer": {
                if (layer == null) {
                    return false;
                }
                return layer.getFeatureStore().canRedo();
            }
            case "edit-undo-redo-actions-layer": {
                return true;
            }
        }
        return false;
    }

    private FLyrVect getActiveAndEditingLayer() {
        ApplicationManager application = ApplicationLocator.getApplicationManager();
        IView vista = (IView)application.getActiveWindow();
        MapControl mapControl = vista.getMapControl();
        FLayer[] activeLayers = mapControl.getMapContext().getLayers().getActives();
        if (activeLayers.length != 1) {
            return null;
        }
        FLayer layer = activeLayers[0];
        if (layer instanceof FLyrVect && ((FLyrVect)layer).getFeatureStore().isEditing()) {
            return (FLyrVect)layer;
        }
        return null;
    }

    public boolean isVisible(String action) {
        ApplicationManager application = ApplicationLocator.getApplicationManager();
        if (!(application.getActiveWindow() instanceof IView)) {
            return false;
        }
        return this.getActiveAndEditingLayer() != null;
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isVisible() {
        return true;
    }
}

