/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.extension.copytable;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.extension.copytable.CopyTable2Panel;
import org.gvsig.app.extension.copytable.CopyTable2Process;
import org.gvsig.app.extension.copytable.CopyTable2ProcessParameters;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.jdbc.JDBCConnectionDialog;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager_v2;
import org.gvsig.tools.task.SimpleTaskStatus;

public class CopyTableExtension
extends Extension {
    public void initialize() {
    }

    public void execute(String actionCommand) {
        switch (actionCommand.toLowerCase()) {
            case "tools-copytable": {
                this.doCopyTable2();
                break;
            }
            case "tools-dbconnections": {
                this.doConnections();
            }
        }
    }

    private void doConnections() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        JDBCConnectionDialog dialog = DALSwingLocator.getSwingManager().createJDBCConectionDialog();
        WindowManager_v2 winmgr = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
        winmgr.showWindow(dialog.asJComponent(), i18n.getTranslation("_Connections"), WindowManager.MODE.WINDOW, Collections.singletonMap("align", 10));
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isVisible() {
        return true;
    }

    private void doCopyTable2() {
        WindowManager_v2 windowManager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
        final CopyTable2Panel panel = new CopyTable2Panel();
        I18nManager i18n = ToolsLocator.getI18nManager();
        final Dialog dialog = windowManager.createDialog((JComponent)panel, i18n.getTranslation("_Copy_table"), "Copia datos de una tabla a otra", 3);
        dialog.setAutoclose(false);
        dialog.setButtonLabel(1, "Copiar datos");
        dialog.setButtonLabel(2, "Cerrar");
        dialog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                switch (dialog.getAction()) {
                    case 1: {
                        dialog.setButtonEnabled(1, false);
                        CopyTable2Process process = CopyTable2Process.createProcess();
                        CopyTable2ProcessParameters params = process.createParameters();
                        panel.fetch(params);
                        panel.addHistory(params);
                        process.setParameters(params).setStatus(panel.getStatus()).setPostProcess(() -> {
                            CopyTableExtension.this.postProcess(dialog, process, panel);
                            DisposeUtils.dispose((Object)params);
                        });
                        process.start();
                        break;
                    }
                    case 2: {
                        ((JComponent)dialog).setVisible(false);
                    }
                }
            }
        });
        dialog.show(WindowManager.MODE.WINDOW, Collections.singletonMap("align", 10));
    }

    public void postProcess(Dialog dialog, CopyTable2Process process, CopyTable2Panel panel) {
        if (SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(() -> this.postProcess(dialog, process, panel));
            return;
        }
        CopyTable2ProcessParameters params = process.getParameters();
        ApplicationLocator.getApplicationManager().refreshDocument(params.getTargetStore());
        dialog.setButtonEnabled(1, true);
        SimpleTaskStatus status = process.getStatus();
        if (status.isCancelled()) {
            panel.message("Copia cancelada.");
        } else if (!status.isAborted()) {
            panel.message("Copia completada.");
        }
    }
}

