/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectPreviewPanel
extends JPanel
implements PropertyChangeListener {
    private static final Logger LOG = LoggerFactory.getLogger(ProjectPreviewPanel.class);
    private static final long serialVersionUID = -8314273002829710953L;
    private int width;
    private int height;
    private Image image;
    private static final int ACCSIZE = 155;
    private final Color bg;

    public ProjectPreviewPanel() {
        this.setPreferredSize(new Dimension(155, -1));
        this.bg = this.getBackground();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String propertyName = e.getPropertyName();
        if (propertyName.equals("SelectedFileChangedProperty")) {
            File selection = (File)e.getNewValue();
            if (selection == null) {
                return;
            }
            String name = selection.getAbsolutePath();
            if (name != null) {
                try {
                    ZipFile zfile = new ZipFile(name);
                    ZipEntry entry = zfile.getEntry("preview.jpg");
                    if (entry != null) {
                        this.image = ImageIO.read(zfile.getInputStream(entry));
                        this.scaleImage();
                    } else {
                        this.image = null;
                    }
                    this.repaint();
                }
                catch (Throwable ex) {
                    LOG.warn("Can't load project preview. Ignore preview.", ex);
                }
            }
        }
    }

    private void scaleImage() {
        this.width = this.image.getWidth(this);
        this.height = this.image.getHeight(this);
        double ratio = 1.0;
        if (this.width >= this.height) {
            ratio = 150.0 / (double)this.width;
            this.width = 150;
            this.height = (int)((double)this.height * ratio);
        } else if (this.getHeight() > 150) {
            ratio = 150.0 / (double)this.height;
            this.height = 150;
            this.width = (int)((double)this.width * ratio);
        } else {
            ratio = (double)this.getHeight() / (double)this.height;
            this.height = this.getHeight();
            this.width = (int)((double)this.width * ratio);
        }
        this.image = this.image.getScaledInstance(this.width, this.height, 1);
    }

    @Override
    public void paintComponent(Graphics g) {
        g.setColor(this.bg);
        g.fillRect(0, 0, 155, this.getHeight());
        if (this.image != null) {
            g.drawImage(this.image, this.getWidth() / 2 - this.width / 2 + 5, this.getHeight() / 2 - this.height / 2, this);
        }
    }
}

