/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.gui;

import java.awt.Window;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.cresques.cts.IProjection;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.gui.wizards.WizardListener;
import org.gvsig.app.gui.wizards.WizardListenerSupport;
import org.gvsig.app.prepareAction.PrepareContextView_v1;
import org.gvsig.app.project.documents.view.toc.actions.LayerErrorsPanel;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemStoreParameters;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.MapContextManager;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.fmap.mapcontrol.MapControlCreationException;
import org.gvsig.fmap.mapcontrol.MapControlLocator;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.arguments.Arguments;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dynobject.DynField;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.identitymanagement.UnauthorizedException;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WizardPanel
extends JPanel {
    private static final Logger logger = LoggerFactory.getLogger(WizardPanel.class);
    private static final long serialVersionUID = 5317749209668850863L;
    private String tabName = "TabName";
    private MapControl mapCtrl = null;
    private final WizardListenerSupport listenerSupport = new WizardListenerSupport();
    private MapContext mapContext;
    private boolean b_isMapControlAvailable = false;
    protected Arguments arguments;
    private final Map<Long, Thread> tasks = new HashMap<Long, Thread>();

    public void addWizardListener(WizardListener listener) {
        this.listenerSupport.addWizardListener(listener);
    }

    public void callError(Exception descripcion) {
        this.listenerSupport.callError(descripcion);
    }

    public void removeWizardListener(WizardListener listener) {
        this.listenerSupport.removeWizardListener(listener);
    }

    public void callStateChanged(boolean finishable) {
        this.listenerSupport.callStateChanged(finishable);
    }

    protected void setTabName(String name) {
        this.tabName = name;
    }

    public String getTabName() {
        return this.tabName;
    }

    public abstract void initWizard();

    public abstract void execute();

    public Object executeWizard() {
        this.execute();
        return null;
    }

    public abstract void close();

    public abstract DataStoreParameters[] getParameters();

    public MapControl getMapCtrl() {
        if (this.mapCtrl != null) {
            return this.mapCtrl;
        }
        if (this.mapContext != null) {
            MapControl mc;
            try {
                mc = MapControlLocator.getMapControlManager().createJMapControlPanel(this.mapContext);
            }
            catch (MapControlCreationException ex) {
                logger.warn("Can't create a MapControl.", (Throwable)ex);
                throw new RuntimeException(ex);
            }
            this.mapCtrl = mc;
        }
        return this.mapCtrl;
    }

    public void setMapCtrl(MapControl mapCtrl) {
        this.mapCtrl = mapCtrl;
        this.b_isMapControlAvailable = mapCtrl != null;
    }

    public MapContext getMapContext() {
        if (this.mapContext != null || this.mapCtrl == null) {
            return this.mapContext;
        }
        return this.mapCtrl.getMapContext();
    }

    public void setMapContext(MapContext mapContext) {
        this.mapContext = mapContext;
    }

    public boolean isMapControlAvailable() {
        return this.b_isMapControlAvailable;
    }

    protected void doAddLayer(final String layerName, final DataStoreParameters parameters) {
        final boolean b_isMapControlAvail = this.isMapControlAvailable();
        final MapControl mapControl = this.getMapCtrl();
        final MapContext mapContext = this.getMapContext();
        final ApplicationManager application = ApplicationLocator.getManager();
        final MapContextManager manager = MapContextLocator.getMapContextManager();
        logger.info("addLayer('{}',...)", (Object)layerName);
        Thread task = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            @Override
            public void run() {
                FLayer layer;
                block12: {
                    layer = null;
                    FLayer preparedLayer = null;
                    try {
                        DataManager dataManager = DALLocator.getDataManager();
                        DataStore dataStore = dataManager.openStore(parameters.getDataStoreName(), parameters);
                        String layerName2 = dataStore.getName();
                        layer = manager.createLayer(layerName2, dataStore);
                        DisposeUtils.disposeQuietly((Disposable)dataStore);
                        preparedLayer = application.prepareOpenLayer(layer, new PrepareContextView_v1(){

                            @Override
                            public Window getOwnerWindow() {
                                return null;
                            }

                            @Override
                            public MapControl getMapControl() {
                                return mapControl;
                            }

                            @Override
                            public IProjection getViewProjection() {
                                return mapContext.getProjection();
                            }

                            @Override
                            public MapContext getMapContext() {
                                return mapContext;
                            }

                            @Override
                            public boolean isMapControlAvailable() {
                                return b_isMapControlAvail;
                            }
                        });
                        if (preparedLayer != null) {
                            mapContext.getLayers().addLayer(preparedLayer);
                        }
                        if (preparedLayer == layer) break block12;
                    }
                    catch (UnauthorizedException e) {
                        block13: {
                            I18nManager i18nManager = ToolsLocator.getI18nManager();
                            ApplicationManager application2 = ApplicationLocator.getManager();
                            String resource = "";
                            if (e.getResource() instanceof FilesystemStoreParameters) {
                                resource = ((FilesystemStoreParameters)e.getResource()).getFile().getPath();
                            }
                            application2.messageDialog(i18nManager.getTranslation("_User_0_is_not_authorized_to_1_on_resource_2_3", new String[]{e.getIdentity().getID(), e.getActionName(), e.getResourceName(), resource}), i18nManager.getTranslation("_Unauthorized_access"), 2);
                            logger.warn("Unauthorized access to layer '" + layerName + "'.", (Throwable)e);
                            if (preparedLayer == layer) break block13;
                            DisposeUtils.disposeQuietly((Disposable)preparedLayer);
                        }
                        DisposeUtils.disposeQuietly((Disposable)layer);
                    }
                    catch (Exception e2) {
                        block14: {
                            LayerErrorsPanel panel = new LayerErrorsPanel(layerName, e2);
                            if (preparedLayer != null) {
                                panel.setLayer(preparedLayer);
                            } else if (layer != null) {
                                panel.setLayer(layer);
                            }
                            I18nManager i18nManager = ToolsLocator.getI18nManager();
                            ToolsSwingLocator.getWindowManager().showWindow((JComponent)panel, i18nManager.getTranslation("_Problems_loading_the_layer"), WindowManager.MODE.WINDOW);
                            logger.warn("Can't load layer '" + layerName + "'.", (Throwable)e2);
                            if (preparedLayer == layer) break block14;
                            {
                                catch (Throwable throwable) {
                                    if (preparedLayer != layer) {
                                        DisposeUtils.disposeQuietly(preparedLayer);
                                    }
                                    DisposeUtils.disposeQuietly(layer);
                                    throw throwable;
                                }
                            }
                            DisposeUtils.disposeQuietly((Disposable)preparedLayer);
                        }
                        DisposeUtils.disposeQuietly((Disposable)layer);
                    }
                    DisposeUtils.disposeQuietly((Disposable)preparedLayer);
                }
                DisposeUtils.disposeQuietly((Disposable)layer);
            }
        });
        task.start();
    }

    protected void doAddLayer(MapControl mapControl, String layerName, DataStoreParameters parameters) {
        this.setMapCtrl(mapControl);
        this.doAddLayer(layerName, parameters);
    }

    public boolean areSettingsValid() {
        return true;
    }

    protected void fixCRS(DataStoreParameters params) {
        IProjection proj = this.getMapCtrl().getProjection();
        DynField[] fields = params.getDynClass().getDynFields();
        int crsfields = 0;
        DynField crsfield = null;
        for (DynField field : fields) {
            if (field.getType() != 65) continue;
            ++crsfields;
            crsfield = field;
            if (!field.isMandatory() || params.getDynValue(field.getName()) != null) continue;
            params.setDynValue(field.getName(), (Object)proj);
        }
        if (crsfields == 1 && crsfield != null && params.getDynValue(crsfield.getName()) == null) {
            params.setDynValue(crsfield.getName(), (Object)proj);
        }
    }

    public boolean addArguments(Arguments args) {
        this.arguments = args;
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addTask(Thread task) {
        Map<Long, Thread> map = this.tasks;
        synchronized (map) {
            this.clearTasks();
            this.tasks.put(task.getId(), task);
        }
    }

    protected void startTask(Thread task) {
        this.addTask(task);
        task.start();
        try {
            Thread.sleep(1L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearTasks() {
        Map<Long, Thread> map = this.tasks;
        synchronized (map) {
            Iterator<Thread> it = this.tasks.values().iterator();
            while (it.hasNext()) {
                Thread currTask = it.next();
                if (currTask.isAlive()) continue;
                it.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitTasks(long timeoutms) {
        try {
            while (true) {
                Thread task;
                Map<Long, Thread> map = this.tasks;
                synchronized (map) {
                    this.clearTasks();
                    Long taskId = this.tasks.keySet().iterator().next();
                    task = this.tasks.get(taskId);
                }
                if (task != null) {
                    task.join(timeoutms);
                    continue;
                }
                break;
            }
        }
        catch (Exception ex) {
        }
    }
}

