/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.gui.command;

import javax.swing.table.AbstractTableModel;
import org.gvsig.tools.undo.RedoException;
import org.gvsig.tools.undo.UndoException;
import org.gvsig.tools.undo.UndoRedoStack;
import org.gvsig.tools.undo.command.Command;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandTableModel
extends AbstractTableModel {
    private static final Logger LOG = LoggerFactory.getLogger(CommandTableModel.class);
    private UndoRedoStack undoRedoStack;

    public CommandTableModel(UndoRedoStack undoRedoStack) {
        this.undoRedoStack = undoRedoStack;
    }

    public int getPos() {
        if (this.undoRedoStack == null || this.undoRedoStack.getUndoInfos() == null) {
            return 0;
        }
        return this.undoRedoStack.getUndoInfos().size() - 1;
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public int getRowCount() {
        if (this.undoRedoStack == null || this.undoRedoStack.getUndoInfos() == null || this.undoRedoStack.getRedoInfos() == null) {
            return 0;
        }
        return this.undoRedoStack.getRedoInfos().size() + this.undoRedoStack.getUndoInfos().size();
    }

    @Override
    public Object getValueAt(int i, int j) {
        Command[] undos = this.undoRedoStack.getUndoInfos().toArray(new Command[0]);
        Command[] redos = this.undoRedoStack.getRedoInfos().toArray(new Command[0]);
        if (i < undos.length) {
            return undos[undos.length - 1 - i];
        }
        return redos[i - undos.length];
    }

    public void setPos(int newpos) {
        try {
            int currentPos = this.getPos();
            if (newpos > currentPos) {
                this.undoRedoStack.redo(newpos - currentPos);
            } else if (newpos < this.getPos()) {
                this.undoRedoStack.undo(currentPos - newpos);
            }
        }
        catch (RedoException e) {
            LOG.error("Error executing the command", (Throwable)e);
        }
        catch (UndoException e) {
            LOG.error("Error executing the command", (Throwable)e);
        }
    }
}

